/*
 * Decompiled with CFR 0.152.
 */
package exnihiloadscensio.barrel;

import exnihiloadscensio.barrel.IBarrelMode;
import exnihiloadscensio.networking.MessageBarrelModeUpdate;
import exnihiloadscensio.networking.MessageFluidUpdate;
import exnihiloadscensio.networking.PacketHandler;
import exnihiloadscensio.registries.BarrelLiquidBlacklistRegistry;
import exnihiloadscensio.registries.BarrelModeRegistry;
import exnihiloadscensio.tiles.TileBarrel;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class BarrelFluidHandler
extends FluidTank {
    private TileBarrel barrel;

    public BarrelFluidHandler(TileBarrel barrel) {
        this(1000);
        this.barrel = barrel;
    }

    public BarrelFluidHandler(int capacity) {
        super(capacity);
    }

    public BarrelFluidHandler(@Nullable FluidStack fluidStack, int capacity) {
        super(fluidStack, capacity);
    }

    public BarrelFluidHandler(Fluid fluid, int amount, int capacity) {
        super(fluid, amount, capacity);
    }

    public boolean canFillFluidType(FluidStack fluid) {
        if (fluid == null || fluid.getFluid() == null || BarrelLiquidBlacklistRegistry.isBlacklisted(this.barrel.getTier(), fluid.getFluid().getName())) {
            return false;
        }
        for (IBarrelMode mode : BarrelModeRegistry.getModes(BarrelModeRegistry.TriggerType.FLUID)) {
            if (!mode.isTriggerFluidStack(fluid)) continue;
            return true;
        }
        return false;
    }

    public boolean canFill() {
        return this.barrel.getMode() == null ? true : this.barrel.getMode().canFillWithFluid(this.barrel);
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.barrel.getMode() != null && !this.barrel.getMode().canFillWithFluid(this.barrel)) {
            return 0;
        }
        int amount = super.fill(resource, doFill);
        if (amount > 0) {
            PacketHandler.sendToAllAround(new MessageFluidUpdate(this.fluid, this.barrel.func_174877_v()), this.barrel);
            if (this.fluid != null && this.barrel.getMode() == null) {
                this.barrel.setMode("fluid");
                PacketHandler.sendToAllAround(new MessageBarrelModeUpdate(this.barrel.getMode().getName(), this.barrel.func_174877_v()), this.barrel);
            }
        }
        return amount;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack stack = super.drain(resource, doDrain);
        if (stack != null && stack.amount > 0) {
            PacketHandler.sendToAllAround(new MessageFluidUpdate(this.fluid, this.barrel.func_174877_v()), this.barrel);
        }
        if (this.fluid == null && this.barrel.getMode() != null && this.barrel.getMode().getName().equals("fluid")) {
            this.barrel.setMode("null");
            PacketHandler.sendToAllAround(new MessageBarrelModeUpdate("null", this.barrel.func_174877_v()), this.barrel);
        }
        return stack;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack stack = super.drain(maxDrain, doDrain);
        if (stack != null && stack.amount > 0) {
            PacketHandler.sendToAllAround(new MessageFluidUpdate(this.fluid, this.barrel.func_174877_v()), this.barrel);
        }
        if (this.fluid == null && this.barrel.getMode() != null && this.barrel.getMode().getName().equals("fluid")) {
            this.barrel.setMode("null");
            PacketHandler.sendToAllAround(new MessageBarrelModeUpdate("null", this.barrel.func_174877_v()), this.barrel);
        }
        return stack;
    }

    protected void onContentsChanged() {
    }

    public void setBarrel(TileBarrel barrel) {
        this.barrel = barrel;
    }
}

