/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.component.misc;

import com.amadornes.rscircuits.api.IAdvancedComparatorOverride;
import com.amadornes.rscircuits.api.circuit.ICircuit;
import com.amadornes.rscircuits.api.component.EnumCircuitSide;
import com.amadornes.rscircuits.api.component.EnumComponentSlot;
import com.amadornes.rscircuits.api.component.IComponentFactory;
import com.amadornes.rscircuits.component.ComponentBaseInt;
import com.amadornes.rscircuits.component.SimpleFactory;
import com.amadornes.rscircuits.init.SCMItems;
import com.amadornes.rscircuits.item.EnumResourceType;
import com.amadornes.rscircuits.util.RedstoneUtils;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import mcmultipart.MCMultiPartMod;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ComponentInventoryScanner
extends ComponentBaseInt {
    public static final ResourceLocation NAME = new ResourceLocation("rscircuits", "inv_scanner");
    private byte input = 0;

    public ComponentInventoryScanner(ICircuit circuit) {
        super(circuit);
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }

    @Override
    public float getComplexity() {
        return 0.125f;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public EnumSet<EnumComponentSlot> getSlots() {
        return EnumSet.of(EnumComponentSlot.BOTTOM, EnumComponentSlot.CENTER);
    }

    @Override
    public boolean isOutput(EnumComponentSlot slot, EnumCircuitSide side) {
        return side != EnumCircuitSide.TOP;
    }

    @Override
    public byte getOutputSignal(EnumComponentSlot slot, EnumCircuitSide side, EnumDyeColor color, boolean bundled) {
        return side.face.func_176740_k() != EnumFacing.Axis.Y ? this.input : (byte)0;
    }

    @Override
    public void onScheduledTick(int type, Object data) {
        byte prevInput = this.input;
        this.input = (Byte)data;
        if (this.input != prevInput) {
            this.getCircuit().markDirty();
            this.getCircuit().notifyUpdate(this.getPos(), EnumComponentSlot.BOTTOM, EnumCircuitSide.HORIZONTALS);
            this.getCircuit().sendUpdate(this.getPos(), EnumComponentSlot.BOTTOM, false);
        }
    }

    @Override
    public void onAdded() {
        this.onWorldTileChange();
    }

    @Override
    public void onCircuitAdded() {
        this.onWorldTileChange();
    }

    @Override
    public void onWorldChange() {
        this.onWorldTileChange();
    }

    @Override
    public void onWorldTileChange() {
        BlockPos pos = this.getPos();
        if (pos.func_177956_o() == 0) {
            EnumCircuitSide side = null;
            if (pos.func_177958_n() == 0) {
                if (pos.func_177952_p() != 0) {
                    if (pos.func_177952_p() < 6) {
                        side = EnumCircuitSide.RIGHT;
                    } else if (pos.func_177952_p() == 6) {
                        // empty if block
                    }
                }
            } else if (pos.func_177958_n() < 6) {
                if (pos.func_177952_p() == 0) {
                    side = EnumCircuitSide.BACK;
                } else if (pos.func_177952_p() >= 6 && pos.func_177952_p() == 6) {
                    side = EnumCircuitSide.FRONT;
                }
            } else if (pos.func_177958_n() == 6 && pos.func_177952_p() != 0) {
                if (pos.func_177952_p() < 6) {
                    side = EnumCircuitSide.LEFT;
                } else if (pos.func_177952_p() == 6) {
                    // empty if block
                }
            }
            if (side != null) {
                byte input = this.calculateInputStrength(this.getCircuit().getWorld(), this.getCircuit().getPos(), RedstoneUtils.convert(this.getCircuit().getFace(), side));
                this.getCircuit().scheduleTick(this, 1, 0, input);
                this.getCircuit().markDirty();
            }
        }
    }

    protected byte calculateInputStrength(World world, BlockPos pos, EnumFacing side) {
        int in = 0;
        IBlockState state = world.func_180495_p(pos = pos.func_177972_a(side));
        if (state.func_185912_n()) {
            in = state.func_177230_c() instanceof IAdvancedComparatorOverride ? ((IAdvancedComparatorOverride)state.func_177230_c()).getAdvancedComparatorInputOverride(state, world, pos, side.func_176734_d()) & 0xFF : state.func_185888_a(world, pos) * 17;
        } else if (state.func_185915_l()) {
            EntityItemFrame itemframe;
            state = world.func_180495_p(pos = pos.func_177972_a(side));
            if (state.func_185912_n()) {
                in = state.func_177230_c() instanceof IAdvancedComparatorOverride ? ((IAdvancedComparatorOverride)state.func_177230_c()).getAdvancedComparatorInputOverride(state, world, pos, side.func_176734_d()) & 0xFF : state.func_185888_a(world, pos) * 17;
            } else if (state.func_185904_a() == Material.field_151579_a && (itemframe = this.findItemFrame(world, side, pos)) != null) {
                in = itemframe.func_174866_q() * 17;
            }
        }
        return (byte)in;
    }

    private EntityItemFrame findItemFrame(World worldIn, EnumFacing facing, BlockPos pos) {
        List list = worldIn.func_175647_a(EntityItemFrame.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1)), p_apply_1_ -> p_apply_1_ != null && p_apply_1_.func_174811_aO() == facing);
        return list.size() == 1 ? (EntityItemFrame)list.get(0) : null;
    }

    @Override
    public void addSelectionBoxes(List<AxisAlignedBB> boxes) {
        boxes.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    }

    @Override
    public List<ItemStack> getDrops() {
        return Arrays.asList(this.getPickedItem());
    }

    @Override
    public ItemStack getPickedItem() {
        return new ItemStack(SCMItems.resource, 1, EnumResourceType.INV_SCANNER.ordinal());
    }

    @Override
    public AxisAlignedBB getSelectionBox(AxisAlignedBB box) {
        return box;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag = super.writeToNBT(tag);
        tag.func_74774_a("input", this.input);
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.input = tag.func_74771_c("input");
    }

    @Override
    public void serializePlacement(PacketBuffer buf) {
    }

    @Override
    public void deserializePlacement(PacketBuffer buf) {
    }

    @Override
    public NBTTagCompound serializeTickData(int type, Object data) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74774_a("input", ((Byte)data).byteValue());
        return tag;
    }

    @Override
    public Object deserializeTickData(int type, NBTTagCompound tag) {
        return tag.func_74771_c("input");
    }

    public static class Factory
    extends SimpleFactory<ComponentInventoryScanner> {
        @Override
        public BlockStateContainer createBlockState() {
            return new BlockStateContainer((Block)MCMultiPartMod.multipart, new IProperty[0]);
        }

        @Override
        public ResourceLocation getModelPath() {
            return new ResourceLocation("rscircuits", "component/inv_scanner");
        }

        @Override
        public boolean isValidPlacementStack(ItemStack stack, EntityPlayer player) {
            return stack.func_77973_b() == SCMItems.resource && stack.func_77952_i() == EnumResourceType.INV_SCANNER.ordinal();
        }

        @Override
        public ComponentInventoryScanner getPlacementData(ICircuit circuit, BlockPos pos, EnumCircuitSide faceClicked, Vec3d hitVec, ItemStack stack, EntityPlayer player, IComponentFactory.EnumPlacementType type, ComponentInventoryScanner previousData, Map<BlockPos, ComponentInventoryScanner> otherData, IComponentFactory.EnumInstantanceUse use) {
            if (pos.func_177956_o() == 0) {
                ComponentInventoryScanner data = super.getPlacementData(circuit, pos, faceClicked, hitVec, stack, player, type, previousData, otherData, use);
                data.setPos(pos);
                return data.isOnEdge(data.getEdgeOn()) ? data : null;
            }
            return null;
        }

        @Override
        public ComponentInventoryScanner instantiate(ICircuit circuit) {
            return new ComponentInventoryScanner(circuit);
        }
    }
}

