/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.component;

import com.amadornes.rscircuits.api.circuit.ICircuit;
import com.amadornes.rscircuits.api.component.EnumComponentSlot;
import com.amadornes.rscircuits.component.ComponentFace;
import com.amadornes.rscircuits.component.SimpleFactory;
import com.amadornes.rscircuits.init.SCMItems;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public abstract class ComponentFaceRotatable
extends ComponentFace {
    protected int rotation;

    public ComponentFaceRotatable(ICircuit circuit, EnumComponentSlot slot, int rotation) {
        super(circuit, slot);
        this.rotation = rotation;
    }

    public ComponentFaceRotatable(ICircuit circuit, EnumComponentSlot slot) {
        super(circuit, slot);
    }

    @Override
    public void rotatePre(Rotation rotation) {
        this.rotation = (this.rotation + rotation.ordinal()) % 4;
    }

    @Override
    public void rotatePost() {
        this.getCircuit().notifyUpdateAll(this.getPos(), this.slot);
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack heldItem, Vec3d hit) {
        if (hand == EnumHand.MAIN_HAND && heldItem != null && heldItem.func_77973_b() == SCMItems.screwdriver && !player.func_70093_af()) {
            if (!this.getCircuit().getWorld().field_72995_K) {
                this.rotatePre(Rotation.CLOCKWISE_90);
                this.rotatePost();
                this.getCircuit().markDirty();
                this.getCircuit().notifyUpdateAll(this.getPos(), this.slot);
                this.getCircuit().sendUpdate(this.getPos(), this.slot, !this.isDynamic());
            }
            return true;
        }
        return super.onActivated(player, hand, heldItem, hit);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("rotation", this.rotation);
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.rotation = tag.func_74762_e("rotation");
    }

    @Override
    public void writeDescription(PacketBuffer buf) {
        super.writeDescription(buf);
        buf.writeInt(this.rotation);
    }

    @Override
    public void readDescription(PacketBuffer buf) {
        super.readDescription(buf);
        this.rotation = buf.readInt();
    }

    @Override
    public void serializePlacement(PacketBuffer buf) {
        super.serializePlacement(buf);
        buf.writeInt(this.rotation);
    }

    @Override
    public void deserializePlacement(PacketBuffer buf) {
        super.deserializePlacement(buf);
        this.rotation = buf.readInt();
    }

    public static abstract class RotatableFactory<C extends ComponentFaceRotatable>
    extends SimpleFactory<C> {
        public int getRotation(EntityPlayer player) {
            return MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 3.5)) & 3;
        }
    }
}

