/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core.part;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetwork;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.part.PartStateBase;
import org.cyclops.integratedtunnels.core.part.PartTypeTunnel;

public abstract class PartTypeInterfacePositionedAddon<N extends IPositionedAddonsNetwork, T, P extends IPartType<P, S>, S extends State<P, N, T>>
extends PartTypeTunnel<P, S> {
    public PartTypeInterfacePositionedAddon(String name) {
        super(name);
    }

    protected abstract Capability<N> getNetworkCapability();

    protected abstract Capability<T> getTargetCapability();

    protected boolean isTargetCapabilityValid(T capability) {
        return capability != null;
    }

    public void afterNetworkReAlive(INetwork network, IPartNetwork partNetwork, PartTarget target, S state) {
        super.afterNetworkReAlive(network, partNetwork, target, state);
        this.addTargetToNetwork(network, target.getTarget(), state.getPriority(), state);
    }

    public void onNetworkRemoval(INetwork network, IPartNetwork partNetwork, PartTarget target, S state) {
        super.onNetworkRemoval(network, partNetwork, target, state);
        this.removeTargetFromNetwork(network, target.getTarget(), state);
    }

    public void onNetworkAddition(INetwork network, IPartNetwork partNetwork, PartTarget target, S state) {
        super.onNetworkAddition(network, partNetwork, target, state);
        this.addTargetToNetwork(network, target.getTarget(), state.getPriority(), state);
    }

    public void onBlockNeighborChange(@Nullable INetwork network, @Nullable IPartNetwork partNetwork, PartTarget target, S state, IBlockAccess world, Block neighborBlock) {
        super.onBlockNeighborChange(network, partNetwork, target, state, world, neighborBlock);
        if (network != null) {
            this.removeTargetFromNetwork(network, target.getTarget(), state);
            this.addTargetToNetwork(network, target.getTarget(), state.getPriority(), state);
        }
    }

    public void setPriority(INetwork network, IPartNetwork partNetwork, PartTarget target, S state, int priority) {
        this.removeTargetFromNetwork(network, target.getTarget(), state);
        super.setPriority(network, partNetwork, target, state, priority);
        this.addTargetToNetwork(network, target.getTarget(), priority, state);
    }

    protected T getTargetCapabilityInstance(PartPos pos) {
        return (T)TileHelpers.getCapability((DimPos)pos.getPos(), (EnumFacing)pos.getSide(), this.getTargetCapability());
    }

    protected void addTargetToNetwork(INetwork network, PartPos pos, int priority, S state) {
        if (network.hasCapability(this.getNetworkCapability())) {
            T capability = this.getTargetCapabilityInstance(pos);
            if (this.isTargetCapabilityValid(capability)) {
                IPositionedAddonsNetwork networkCapability = (IPositionedAddonsNetwork)network.getCapability(this.getNetworkCapability());
                networkCapability.addPosition(pos, priority);
            }
            ((State)((Object)state)).setPositionedAddonsNetwork((IPositionedAddonsNetwork)((IPositionedAddonsNetwork)network.getCapability(this.getNetworkCapability())));
            ((State)((Object)state)).setPos(pos);
        }
    }

    protected void removeTargetFromNetwork(INetwork network, PartPos pos, S state) {
        if (network.hasCapability(this.getNetworkCapability())) {
            IPositionedAddonsNetwork networkCapability = (IPositionedAddonsNetwork)network.getCapability(this.getNetworkCapability());
            networkCapability.removePosition(pos);
        }
        ((State)((Object)state)).setPositionedAddonsNetwork(null);
        ((State)((Object)state)).setPos(null);
    }

    public static abstract class State<P extends IPartType, N extends IPositionedAddonsNetwork, T>
    extends PartStateBase<P> {
        private N positionedAddonsNetwork = null;
        private PartPos pos = null;

        protected abstract Capability<T> getTargetCapability();

        public N getPositionedAddonsNetwork() {
            return this.positionedAddonsNetwork;
        }

        public void setPositionedAddonsNetwork(N positionedAddonsNetwork) {
            this.positionedAddonsNetwork = positionedAddonsNetwork;
        }

        public PartPos getPos() {
            return this.pos;
        }

        public void setPos(PartPos pos) {
            this.pos = pos;
        }

        protected void disablePosition() {
            N positionedNetwork = this.getPositionedAddonsNetwork();
            PartPos pos = this.getPos();
            if (positionedNetwork != null) {
                positionedNetwork.disablePosition(pos);
            }
        }

        protected void enablePosition() {
            N positionedNetwork = this.getPositionedAddonsNetwork();
            PartPos pos = this.getPos();
            if (positionedNetwork != null) {
                positionedNetwork.enablePosition(pos);
            }
        }

        public boolean hasCapability(Capability<?> capability) {
            return this.getPositionedAddonsNetwork() != null && capability == this.getTargetCapability() || super.hasCapability(capability);
        }

        public <T> T getCapability(Capability<T> capability) {
            if (this.getPositionedAddonsNetwork() != null && capability == this.getTargetCapability()) {
                return (T)((Object)this);
            }
            return (T)super.getCapability(capability);
        }
    }
}

