/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels;

import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.ConfigurableTypeCategory;
import org.cyclops.cyclopscore.config.extendedconfig.DummyConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.tracking.Analytics;
import org.cyclops.cyclopscore.tracking.IModVersion;
import org.cyclops.cyclopscore.tracking.Versions;
import org.cyclops.integratedtunnels.IntegratedTunnels;

public class GeneralConfig
extends DummyConfig {
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="Config version for Integrated Tunnels.\nDO NOT EDIT MANUALLY!", showInGui=false)
    public static String version = "1.2.5";
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="Set 'true' to enable development debug mode. This will result in a lower performance!", requiresMcRestart=true)
    public static boolean debug = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If the recipe loader should crash when finding invalid recipes.", requiresMcRestart=true)
    public static boolean crashOnInvalidRecipe = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If mod compatibility loader should crash hard if errors occur in that process.", requiresMcRestart=true)
    public static boolean crashOnModCompatCrash = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If an anonymous mod startup analytics request may be sent to our analytics service.")
    public static boolean analytics = true;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If the version checker should be enabled.")
    public static boolean versionChecker = true;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="How many ticks importers/exporters should sleep until checking targets again when they were previously unchanged.")
    public static int inventoryUnchangedTickTimeout = 10;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="The maximum network fluid transfer rate.", isCommandable=true, minimalValue=0)
    public static int fluidRateLimit = Integer.MAX_VALUE;
    public static ConfigurableType TYPE = ConfigurableType.DUMMY;

    public GeneralConfig() {
        super((ModBase)IntegratedTunnels._instance, true, "general", null, GeneralConfig.class);
    }

    public void onRegistered() {
        if (!version.equals("1.2.5")) {
            this.getMod().log(Level.WARN, "The config file of Integrated Tunnels is out of date and might cause problems, please remove it so it can be regenerated.");
        }
        this.getMod().putGenericReference(ModBase.REFKEY_CRASH_ON_INVALID_RECIPE, (Object)crashOnInvalidRecipe);
        this.getMod().putGenericReference(ModBase.REFKEY_DEBUGCONFIG, (Object)debug);
        this.getMod().putGenericReference(ModBase.REFKEY_CRASH_ON_MODCOMPAT_CRASH, (Object)crashOnModCompatCrash);
        if (analytics) {
            Analytics.registerMod((ModBase)this.getMod(), (String)"UA-65307010-10");
        }
        if (versionChecker) {
            Versions.registerMod((ModBase)this.getMod(), (IModVersion)IntegratedTunnels._instance, (String)"https://raw.githubusercontent.com/CyclopsMC/Versions/master/1.10/IntegratedTunnels.txt");
        }
    }

    public boolean isEnabled() {
        return true;
    }
}

