/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave.engine;

import crazypants.enderio.Log;
import info.loenwind.autosave.Registry;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.exceptions.NoHandlerFoundException;
import info.loenwind.autosave.handlers.IHandler;
import info.loenwind.autosave.handlers.internal.HandleStorable;
import info.loenwind.autosave.handlers.internal.NullHandler;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class StorableEngine {
    private static final ThreadLocal<StorableEngine> INSTANCE = new ThreadLocal<StorableEngine>(){

        @Override
        protected StorableEngine initialValue() {
            return new StorableEngine();
        }
    };
    @Nonnull
    public static final String NULL_POSTFIX = "__null";
    @Nonnull
    public static final String SUPERCLASS_KEY = "__superclass";
    @Nonnull
    private final Map<Class<?>, List<Field>> fieldCache = new HashMap();
    @Nonnull
    private final Map<Field, Set<Store.StoreFor>> phaseCache = new HashMap<Field, Set<Store.StoreFor>>();
    @Nonnull
    private final Map<Field, List<IHandler>> fieldHandlerCache = new HashMap<Field, List<IHandler>>();
    @Nonnull
    private final Map<Class<?>, Class<?>> superclassCache = new HashMap();
    @Nonnull
    private final Map<Class<?>, List<IHandler>> superclassHandlerCache = new HashMap();

    private StorableEngine() {
    }

    public static <T> void read(@Nonnull Registry registry, @Nonnull Set<Store.StoreFor> phase, @Nonnull NBTTagCompound tag, @Nonnull T object) throws IllegalAccessException, InstantiationException, NoHandlerFoundException {
        INSTANCE.get().read_impl(registry, phase, tag, object);
    }

    public static <T> void store(@Nonnull Registry registry, @Nonnull Set<Store.StoreFor> phase, @Nonnull NBTTagCompound tag, @Nonnull T object) throws IllegalAccessException, InstantiationException, NoHandlerFoundException {
        INSTANCE.get().store_impl(registry, phase, tag, object);
    }

    public <T> void read_impl(@Nonnull Registry registry, @Nonnull Set<Store.StoreFor> phase, @Nonnull NBTTagCompound tag, @Nonnull T object) throws IllegalAccessException, InstantiationException, NoHandlerFoundException {
        Class<?> clazz = object.getClass();
        if (!this.fieldCache.containsKey(clazz)) {
            this.cacheHandlers(registry, clazz);
        }
        Log.livetraceNBT("Reading NBT data for object ", object, " of class ", clazz, " for phase(s) ", phase, " from NBT ", tag);
        block0: for (Field field : this.fieldCache.get(clazz)) {
            if (!Collections.disjoint((Collection)this.phaseCache.get(field), phase)) {
                Object fieldData = field.get(object);
                String fieldName = field.getName();
                if (!tag.func_74764_b(fieldName + NULL_POSTFIX) && fieldName != null) {
                    for (IHandler handler : this.fieldHandlerCache.get(field)) {
                        Log.livetraceNBT("Trying to read data for field ", fieldName, " with handler ", handler);
                        Object result = handler.read(registry, phase, tag, field, fieldName, fieldData);
                        if (result == null) continue;
                        Log.livetraceNBT("Read data for field ", fieldName, " with handler ", handler, " yielded data: ", result);
                        field.set(object, result);
                        continue block0;
                    }
                    continue;
                }
                Log.livetraceNBT("Field ", fieldName, " is set to null. NULL_POSTFIX=", tag.func_74764_b(fieldName + NULL_POSTFIX));
                field.set(object, null);
                continue;
            }
            Log.livetraceNBT("Field ", field.getName(), " is not part of the current phase.");
        }
        Class<?> superclazz = this.superclassCache.get(clazz);
        if (superclazz != null) {
            for (IHandler handler : this.superclassHandlerCache.get(superclazz)) {
                Log.livetraceNBT("Trying to read data for super class ", superclazz, " with handler ", handler);
                if (handler.read(registry, phase, tag, null, SUPERCLASS_KEY, object) == null) continue;
                Log.livetraceNBT("Read data for super class ", superclazz, " with handler ", handler);
                break;
            }
        }
        Log.livetraceNBT("Read NBT data for object ", object, " of class ", clazz);
    }

    public <T> void store_impl(@Nonnull Registry registry, @Nonnull Set<Store.StoreFor> phase, @Nonnull NBTTagCompound tag, @Nonnull T object) throws IllegalAccessException, InstantiationException, NoHandlerFoundException {
        Class<?> clazz = object.getClass();
        if (!this.fieldCache.containsKey(clazz)) {
            this.cacheHandlers(registry, clazz);
        }
        Log.livetraceNBT("Saving NBT data for object ", object, " of class ", clazz, " for phase(s) ", phase, " into NBT ", tag);
        block0: for (Field field : this.fieldCache.get(clazz)) {
            if (!Collections.disjoint((Collection)this.phaseCache.get(field), phase)) {
                Object fieldData = field.get(object);
                String fieldName = field.getName();
                if (fieldData != null && fieldName != null) {
                    for (IHandler handler : this.fieldHandlerCache.get(field)) {
                        Log.livetraceNBT("Trying to save data for field ", fieldName, " with handler ", handler);
                        if (!handler.store(registry, phase, tag, fieldName, fieldData)) continue;
                        Log.livetraceNBT("Saved data for field ", fieldName, " with handler ", handler, ". NBT now is ", tag);
                        continue block0;
                    }
                    continue;
                }
                Log.livetraceNBT("Field ", fieldName, " is null. Setting NULL_POSTFIX.");
                tag.func_74757_a(fieldName + NULL_POSTFIX, true);
                continue;
            }
            Log.livetraceNBT("Field ", field.getName(), " is not part of the current phase.");
        }
        Class<?> superclazz = this.superclassCache.get(clazz);
        if (superclazz != null) {
            for (IHandler handler : this.superclassHandlerCache.get(superclazz)) {
                Log.livetraceNBT("Trying to save data for super class ", superclazz, " with handler ", handler);
                if (!handler.store(registry, phase, tag, SUPERCLASS_KEY, object)) continue;
                Log.livetraceNBT("Saved data for super class ", superclazz, " with handler ", handler);
                break;
            }
        }
        Log.livetraceNBT("Saved NBT data for object ", object, " of class ", clazz);
    }

    public static <T> T getSingleField(@Nonnull Registry registry, @Nonnull Set<Store.StoreFor> phase, @Nonnull NBTTagCompound tag, @Nonnull String fieldName, @Nonnull Class<T> clazz, @Nullable T object) throws InstantiationException, IllegalAccessException, IllegalArgumentException, NoHandlerFoundException {
        if (!tag.func_74764_b(fieldName + NULL_POSTFIX)) {
            for (IHandler handler : registry.findHandlers(clazz)) {
                T result = handler.read(registry, phase, tag, null, fieldName, object);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public static <T> void setSingleField(@Nonnull Registry registry, @Nonnull Set<Store.StoreFor> phase, @Nonnull NBTTagCompound tag, @Nonnull String fieldName, @Nonnull Class<T> clazz, @Nullable T fieldData) throws InstantiationException, IllegalAccessException, IllegalArgumentException, NoHandlerFoundException {
        if (fieldData != null) {
            tag.func_82580_o(fieldName + NULL_POSTFIX);
            for (IHandler handler : registry.findHandlers(clazz)) {
                if (!handler.store(registry, phase, tag, fieldName, fieldData)) continue;
                return;
            }
            throw new NoHandlerFoundException(clazz, fieldName);
        }
        tag.func_82580_o(fieldName);
        tag.func_74757_a(fieldName + NULL_POSTFIX, true);
    }

    private void cacheHandlers(@Nonnull Registry registry, Class<?> clazz) throws IllegalAccessException, InstantiationException, NoHandlerFoundException {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Field field : clazz.getDeclaredFields()) {
            Store annotation = field.getAnnotation(Store.class);
            if (annotation == null) continue;
            ArrayList<IHandler> handlerList = new ArrayList<IHandler>();
            String fieldName = field.getName();
            if (fieldName == null) continue;
            Class<?> fieldType = field.getType();
            if (annotation.handler() != NullHandler.class) {
                handlerList.add(annotation.handler().newInstance());
            }
            handlerList.addAll(registry.findHandlers(fieldType));
            if (handlerList.isEmpty()) {
                throw new NoHandlerFoundException(field, clazz);
            }
            EnumSet<Store.StoreFor> enumSet = EnumSet.noneOf(Store.StoreFor.class);
            enumSet.addAll(Arrays.asList(annotation.value()));
            this.phaseCache.put(field, enumSet);
            field.setAccessible(true);
            fieldList.add(field);
            this.fieldHandlerCache.put(field, handlerList);
        }
        Class<?> superclazz = clazz.getSuperclass();
        if (superclazz != null) {
            Storable annotation = superclazz.getAnnotation(Storable.class);
            if (annotation != null) {
                if (annotation.handler() == HandleStorable.class) {
                    this.cacheHandlers(registry, superclazz);
                    fieldList.addAll((Collection)this.fieldCache.get(superclazz));
                } else {
                    this.superclassCache.put(clazz, superclazz);
                    if (!this.superclassCache.containsKey(superclazz)) {
                        this.superclassHandlerCache.put(superclazz, Arrays.asList(annotation.handler().newInstance()));
                    }
                }
            } else {
                List<IHandler> handlers = registry.findHandlers(superclazz);
                if (!handlers.isEmpty()) {
                    this.superclassCache.put(clazz, superclazz);
                    if (!this.superclassCache.containsKey(superclazz)) {
                        this.superclassHandlerCache.put(superclazz, handlers);
                    }
                }
            }
        }
        this.fieldCache.put(clazz, fieldList);
    }
}

