/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.power;

import crazypants.enderio.power.IInternalPoweredItem;
import crazypants.enderio.power.ItemPowerCapabilityBackend;
import crazypants.util.NbtValue;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public abstract class AbstractPoweredItem
extends Item
implements IInternalPoweredItem {
    protected int maxEneryStored;
    protected int maxInput;
    protected int maxOutput;

    public AbstractPoweredItem(int maxEneryStored, int maxInput, int maxOutput) {
        this.maxEneryStored = maxEneryStored;
        this.maxInput = maxInput;
        this.maxOutput = maxOutput;
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.maxEneryStored;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return NbtValue.ENERGY.getInt(container);
    }

    @Override
    public void setEnergyStored(ItemStack container, int energy) {
        NbtValue.ENERGY.setInt(container, MathHelper.func_76125_a((int)energy, (int)0, (int)this.maxEneryStored));
    }

    @Override
    public int getMaxInput(ItemStack container) {
        return this.maxInput;
    }

    @Override
    public int getMaxOutput(ItemStack container) {
        return this.maxOutput;
    }

    public void setFull(ItemStack container) {
        this.setEnergyStored(container, this.getMaxEnergyStored(container));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new ItemPowerCapabilityBackend(stack);
    }
}

