/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.recipe;

import crazypants.enderio.machine.recipe.RecipeInput;
import crazypants.util.Prep;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictionaryRecipeInput
extends RecipeInput {
    @Nonnull
    private static final Map<String, Set<StackWrapper>> oreCache = new HashMap<String, Set<StackWrapper>>();
    @Nonnull
    private final String oreDict;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private static Set<StackWrapper> getCached(@Nonnull String oreDict) {
        Set<StackWrapper> set = oreCache.get(oreDict);
        if (set == null) {
            set = new HashSet<StackWrapper>();
            List ores = OreDictionary.getOres((String)oreDict);
            for (ItemStack ore : ores) {
                if (!Prep.isValid(ore)) continue;
                set.add(new StackWrapper(ore));
            }
            Map<String, Set<StackWrapper>> map = oreCache;
            synchronized (map) {
                oreCache.put(oreDict, set);
            }
        }
        return set;
    }

    public OreDictionaryRecipeInput(@Nonnull ItemStack stack, @Nonnull String oreDict, float multiplier, int slot) {
        super(stack, true, multiplier, slot);
        this.oreDict = oreDict;
    }

    public OreDictionaryRecipeInput(OreDictionaryRecipeInput copy) {
        super(copy.getInput(), true, copy.getMulitplier(), copy.getSlotNumber());
        this.oreDict = copy.oreDict;
    }

    @Override
    public RecipeInput copy() {
        return new OreDictionaryRecipeInput(this);
    }

    @Override
    public boolean isInput(ItemStack test) {
        if (Prep.isInvalid(test)) {
            return false;
        }
        return OreDictionaryRecipeInput.getCached(this.oreDict).contains(new StackWrapper(test));
    }

    @Override
    public ItemStack[] getEquivelentInputs() {
        Set<StackWrapper> cached = OreDictionaryRecipeInput.getCached(this.oreDict);
        if (cached.isEmpty()) {
            return null;
        }
        ItemStack[] result = new ItemStack[cached.size()];
        int i = 0;
        for (StackWrapper stackWrapper : cached) {
            result[i++] = stackWrapper.getStackCopy(this.getInput().field_77994_a);
        }
        return result;
    }

    @Override
    public String toString() {
        return "OreDictionaryRecipeInput [oreDict=" + this.oreDict + " amount=" + this.getInput().field_77994_a + "]";
    }

    static class StackWrapper {
        @Nonnull
        private final ItemStack stack;

        StackWrapper(@Nonnull ItemStack stack) {
            this.stack = stack;
        }

        public ItemStack getStackCopy(int size) {
            ItemStack copy = this.stack.func_77946_l();
            copy.field_77994_a = size;
            return copy;
        }

        public int hashCode() {
            return this.stack.func_77973_b().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StackWrapper other = (StackWrapper)obj;
            if (this.stack.func_77973_b() != other.stack.func_77973_b()) {
                return false;
            }
            if (!this.stack.func_77981_g()) {
                return true;
            }
            if (this.stack.func_77960_j() == Short.MAX_VALUE) {
                return true;
            }
            if (other.stack.func_77960_j() == Short.MAX_VALUE) {
                return true;
            }
            return this.stack.func_77960_j() == other.stack.func_77960_j();
        }
    }
}

