/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.monitor;

import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.ManagedTESR;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.client.render.VertexRotationFacing;
import com.enderio.core.common.vecmath.Vector3d;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.monitor.TilePowerMonitor;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TESRPowerMonitor
extends ManagedTESR<TilePowerMonitor> {
    private static final float px = 0.0625f;
    private static BoundingBox bb1 = new BoundingBox(0.0625f, 0.0625f, 0.921875f, 0.9375f, 0.9375f, 0.921875f);
    private static BoundingBox bb2 = new BoundingBox(0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
    ThreadLocal<Helper> threadLocalHelper = new ThreadLocal<Helper>(){

        @Override
        protected Helper initialValue() {
            return new Helper();
        }
    };

    public TESRPowerMonitor() {
        super(ModObject.blockPowerMonitorv2.getBlock());
    }

    protected boolean shouldRender(@Nonnull TilePowerMonitor te, @Nonnull IBlockState blockState, int renderPass) {
        return te.isAdvanced();
    }

    protected void renderTileEntity(@Nonnull TilePowerMonitor te, @Nonnull IBlockState blockState, float partialTicks, int destroyStage) {
        boolean isPainted = te.getPaintSource() != null;
        VertexRotationFacing xform = new VertexRotationFacing(te.getFacing());
        xform.setCenter(new Vector3d(0.5, 0.5, 0.5));
        xform.setRotation(EnumFacing.SOUTH);
        te.bindTexture();
        Helper helper = this.threadLocalHelper.get();
        VertexBuffer tes = Tessellator.func_178181_a().func_178180_c();
        tes.func_181668_a(7, DefaultVertexFormats.field_181712_l);
        if (isPainted) {
            helper.setupVertices(bb2, (VertexTransform)xform);
            helper.renderSingleFace(tes, EnumFacing.SOUTH, 0.0f, 0.875f, 0.0f, 0.875f, (VertexTransform)xform, Helper.stdBrightness, false);
        } else {
            helper.setupVertices(bb1, (VertexTransform)xform);
            helper.renderSingleFace(tes, EnumFacing.SOUTH, 0.0625f, 0.9375f, 0.0625f, 0.9375f, (VertexTransform)xform, Helper.stdBrightness, false);
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    private static class Helper {
        final Vector3d[] verts = new Vector3d[8];
        static final float[] stdBrightness = new float[6];
        static final float[] stdBrightnessInside = new float[6];
        private static final double ROTATION_AMOUNT = 1.5707963267948966;

        Helper() {
            for (int i = 0; i < this.verts.length; ++i) {
                this.verts[i] = new Vector3d();
            }
        }

        void setupVertices(BoundingBox bound, VertexTransform xForm) {
            this.verts[0].set(bound.field_72340_a, bound.field_72338_b, bound.field_72339_c);
            this.verts[1].set(bound.field_72336_d, bound.field_72338_b, bound.field_72339_c);
            this.verts[2].set(bound.field_72336_d, bound.field_72337_e, bound.field_72339_c);
            this.verts[3].set(bound.field_72340_a, bound.field_72337_e, bound.field_72339_c);
            this.verts[4].set(bound.field_72340_a, bound.field_72338_b, bound.field_72334_f);
            this.verts[5].set(bound.field_72336_d, bound.field_72338_b, bound.field_72334_f);
            this.verts[6].set(bound.field_72336_d, bound.field_72337_e, bound.field_72334_f);
            this.verts[7].set(bound.field_72340_a, bound.field_72337_e, bound.field_72334_f);
            if (xForm != null) {
                for (Vector3d vec : this.verts) {
                    xForm.apply(vec);
                }
            }
        }

        EnumFacing rotate(VertexTransform xForm, EnumFacing dir) {
            if (xForm instanceof VertexRotationFacing) {
                double angle = ((VertexRotationFacing)xForm).getAngle();
                if (angle < 0.7853981633974483 || angle >= 5.497787143782138) {
                    return dir;
                }
                if (angle >= 0.7853981633974483 && angle < 2.356194490192345) {
                    return dir.func_176746_e();
                }
                if (angle >= 2.356194490192345 && angle < 3.9269908169872414) {
                    return dir.func_176734_d();
                }
                if (angle >= 3.9269908169872414 && angle < 5.497787143782138) {
                    return dir.func_176735_f();
                }
            }
            return dir;
        }

        void addVecWithUV(VertexBuffer tes, Vector3d vec, double u, double v, float cm, EnumFacing normal) {
            tes.func_181662_b(vec.x, vec.y, vec.z).func_187315_a(u, v).func_181666_a(cm, cm, cm, 1.0f).func_181663_c((float)normal.func_176730_m().func_177958_n(), (float)normal.func_176730_m().func_177956_o(), (float)normal.func_176730_m().func_177952_p()).func_181675_d();
        }

        void renderSingleFace(VertexBuffer tes, EnumFacing face, float minU, float maxU, float minV, float maxV, VertexTransform xForm, float[] brightnessPerSide, boolean inside) {
            float cm;
            EnumFacing normal = this.rotate(xForm, inside ? face.func_176734_d() : face);
            float f = cm = brightnessPerSide != null ? brightnessPerSide[normal.ordinal()] : 1.0f;
            if (inside) {
                switch (face) {
                    case NORTH: {
                        this.addVecWithUV(tes, this.verts[0], maxU, maxV, cm, normal);
                        this.addVecWithUV(tes, this.verts[1], minU, maxV, cm, normal);
                        this.addVecWithUV(tes, this.verts[2], minU, minV, cm, normal);
                        this.addVecWithUV(tes, this.verts[3], maxU, minV, cm, normal);
                        break;
                    }
                    case SOUTH: {
                        this.addVecWithUV(tes, this.verts[5], maxU, maxV, cm, normal);
                        this.addVecWithUV(tes, this.verts[4], minU, maxV, cm, normal);
                        this.addVecWithUV(tes, this.verts[7], minU, minV, cm, normal);
                        this.addVecWithUV(tes, this.verts[6], maxU, minV, cm, normal);
                        break;
                    }
                    case UP: {
                        this.addVecWithUV(tes, this.verts[2], maxU, minV, cm, normal);
                        this.addVecWithUV(tes, this.verts[6], maxU, maxV, cm, normal);
                        this.addVecWithUV(tes, this.verts[7], minU, maxV, cm, normal);
                        this.addVecWithUV(tes, this.verts[3], minU, minV, cm, normal);
                        break;
                    }
                    case DOWN: {
                        this.addVecWithUV(tes, this.verts[1], maxU, minV, cm, normal);
                        this.addVecWithUV(tes, this.verts[0], minU, minV, cm, normal);
                        this.addVecWithUV(tes, this.verts[4], minU, maxV, cm, normal);
                        this.addVecWithUV(tes, this.verts[5], maxU, maxV, cm, normal);
                        break;
                    }
                    case EAST: {
                        this.addVecWithUV(tes, this.verts[6], minU, minV, cm, normal);
                        this.addVecWithUV(tes, this.verts[2], maxU, minV, cm, normal);
                        this.addVecWithUV(tes, this.verts[1], maxU, maxV, cm, normal);
                        this.addVecWithUV(tes, this.verts[5], minU, maxV, cm, normal);
                        break;
                    }
                    case WEST: {
                        this.addVecWithUV(tes, this.verts[4], maxU, maxV, cm, normal);
                        this.addVecWithUV(tes, this.verts[0], minU, maxV, cm, normal);
                        this.addVecWithUV(tes, this.verts[3], minU, minV, cm, normal);
                        this.addVecWithUV(tes, this.verts[7], maxU, minV, cm, normal);
                        break;
                    }
                }
            } else {
                switch (face) {
                    case NORTH: {
                        this.addVecWithUV(tes, this.verts[1], minU, maxV, cm, normal);
                        this.addVecWithUV(tes, this.verts[0], maxU, maxV, cm, normal);
                        this.addVecWithUV(tes, this.verts[3], maxU, minV, cm, normal);
                        this.addVecWithUV(tes, this.verts[2], minU, minV, cm, normal);
                        break;
                    }
                    case SOUTH: {
                        this.addVecWithUV(tes, this.verts[4], minU, maxV, cm, normal);
                        this.addVecWithUV(tes, this.verts[5], maxU, maxV, cm, normal);
                        this.addVecWithUV(tes, this.verts[6], maxU, minV, cm, normal);
                        this.addVecWithUV(tes, this.verts[7], minU, minV, cm, normal);
                        break;
                    }
                    case UP: {
                        this.addVecWithUV(tes, this.verts[6], maxU, maxV, cm, normal);
                        this.addVecWithUV(tes, this.verts[2], maxU, minV, cm, normal);
                        this.addVecWithUV(tes, this.verts[3], minU, minV, cm, normal);
                        this.addVecWithUV(tes, this.verts[7], minU, maxV, cm, normal);
                        break;
                    }
                    case DOWN: {
                        this.addVecWithUV(tes, this.verts[0], minU, minV, cm, normal);
                        this.addVecWithUV(tes, this.verts[1], maxU, minV, cm, normal);
                        this.addVecWithUV(tes, this.verts[5], maxU, maxV, cm, normal);
                        this.addVecWithUV(tes, this.verts[4], minU, maxV, cm, normal);
                        break;
                    }
                    case EAST: {
                        this.addVecWithUV(tes, this.verts[2], maxU, minV, cm, normal);
                        this.addVecWithUV(tes, this.verts[6], minU, minV, cm, normal);
                        this.addVecWithUV(tes, this.verts[5], minU, maxV, cm, normal);
                        this.addVecWithUV(tes, this.verts[1], maxU, maxV, cm, normal);
                        break;
                    }
                    case WEST: {
                        this.addVecWithUV(tes, this.verts[0], minU, maxV, cm, normal);
                        this.addVecWithUV(tes, this.verts[4], maxU, maxV, cm, normal);
                        this.addVecWithUV(tes, this.verts[7], maxU, minV, cm, normal);
                        this.addVecWithUV(tes, this.verts[3], minU, minV, cm, normal);
                    }
                }
            }
        }

        static {
            for (EnumFacing dir : EnumFacing.values()) {
                Helper.stdBrightness[dir.ordinal()] = RenderUtil.getColorMultiplierForFace((EnumFacing)dir);
                Helper.stdBrightnessInside[dir.ordinal()] = RenderUtil.getColorMultiplierForFace((EnumFacing)dir) * 0.75f;
            }
        }
    }
}

