/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.generator.zombie;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.fluid.FluidWrapper;
import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.fluid.Fluids;
import crazypants.enderio.fluid.SmartTank;
import crazypants.enderio.fluid.SmartTankFluidHandler;
import crazypants.enderio.fluid.SmartTankFluidMachineHandler;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.generator.AbstractGeneratorEntity;
import crazypants.enderio.machine.generator.zombie.IHasNutrientTank;
import crazypants.enderio.machine.generator.zombie.PacketNutrientTank;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.PowerDistributor;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Storable
public class TileZombieGenerator
extends AbstractGeneratorEntity
implements ITankAccess.IExtendedTankAccess,
IHasNutrientTank {
    private static int IO_MB_TICK = 250;
    @Store
    final SmartTank tank = new SmartTank(Fluids.fluidNutrientDistillation, 2000);
    int outputPerTick = Config.zombieGeneratorRfPerTick;
    int tickPerBucketOfFuel = Config.zombieGeneratorTicksPerBucketFuel;
    private boolean tanksDirty;
    @Store(value={Store.StoreFor.CLIENT})
    private boolean active = false;
    private PowerDistributor powerDis;
    private int ticksRemaingFuel;
    private boolean inPause;
    private SmartTankFluidHandler smartTankFluidHandler;

    public TileZombieGenerator() {
        super(new SlotDefinition(0, 0, 0), ModObject.blockZombieGenerator);
        this.tank.setTileEntity((TileEntity)this);
        this.tank.setCanDrain(false);
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return ModObject.blockZombieGenerator.getUnlocalisedName();
    }

    @Override
    public boolean supportsMode(@Nullable EnumFacing faceHit, @Nullable IoMode mode) {
        return mode != IoMode.PUSH && mode != IoMode.PUSH_PULL;
    }

    @Override
    protected boolean doPull(@Nullable EnumFacing dir) {
        boolean res = super.doPull(dir);
        if (dir != null && this.tank.getFluidAmount() < this.tank.getCapacity() && FluidWrapper.transfer((IBlockAccess)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(dir), (EnumFacing)dir.func_176734_d(), (FluidTank)this.tank, (int)IO_MB_TICK) > 0) {
            this.setTanksDirty();
        }
        return res;
    }

    @Override
    public int getPowerUsePerTick() {
        return this.outputPerTick;
    }

    @Override
    public boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void onNeighborBlockChange(Block blockId) {
        super.onNeighborBlockChange(blockId);
        if (this.powerDis != null) {
            this.powerDis.neighboursChanged();
        }
    }

    @Override
    protected boolean processTasks(boolean redstoneCheck) {
        boolean res = false;
        if (!redstoneCheck) {
            if (this.active) {
                this.active = false;
                res = true;
            }
            return res;
        }
        boolean isActive = this.generateEnergy();
        if (isActive != this.active) {
            this.active = isActive;
            res = true;
        }
        if (this.getEnergyStored() >= this.getMaxEnergyStored()) {
            this.inPause = true;
        }
        this.transmitEnergy();
        if (this.tanksDirty) {
            PacketHandler.sendToAllAround((IMessage)new PacketNutrientTank(this), (TileEntity)this);
            this.tanksDirty = false;
        }
        return res;
    }

    private boolean generateEnergy() {
        if (this.inPause && this.getEnergyStored() >= this.getMaxEnergyStored() - this.outputPerTick * 200 && this.getEnergyStored() > this.getMaxEnergyStored() / 8) {
            return false;
        }
        this.inPause = false;
        if (this.tank.getFluidAmount() < this.getActivationAmount()) {
            return false;
        }
        --this.ticksRemaingFuel;
        if (this.ticksRemaingFuel <= 0) {
            this.tank.removeFluidAmount(1);
            this.ticksRemaingFuel = this.tickPerBucketOfFuel / 1000;
        }
        this.setEnergyStored(this.getEnergyStored() + this.outputPerTick);
        return true;
    }

    int getActivationAmount() {
        return (int)((float)this.tank.getCapacity() * 0.7f);
    }

    private boolean transmitEnergy() {
        if (this.getEnergyStored() <= 0) {
            return false;
        }
        if (this.powerDis == null) {
            this.powerDis = new PowerDistributor(new BlockCoord((TileEntity)this));
        }
        int transmitted = this.powerDis.transmitEnergy(this.field_145850_b, Math.min(this.outputPerTick * 2, this.getEnergyStored()));
        this.setEnergyStored(this.getEnergyStored() - transmitted);
        return transmitted > 0;
    }

    public int getFluidStored(EnumFacing from) {
        return this.tank.getFluidAmount();
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        if (forFluidType != null && forFluidType.getFluid() == Fluids.fluidNutrientDistillation) {
            return this.tank;
        }
        return null;
    }

    public FluidTank[] getOutputTanks() {
        return new FluidTank[0];
    }

    public void setTanksDirty() {
        this.tanksDirty = true;
    }

    @Override
    public SmartTank getNutrientTank() {
        return this.tank;
    }

    @Nonnull
    public List<ITankAccess.ITankData> getTankDisplayData() {
        return Collections.singletonList(new ITankAccess.ITankData(){

            @Nonnull
            public ITankAccess.ITankData.EnumTankType getTankType() {
                return ITankAccess.ITankData.EnumTankType.INPUT;
            }

            @Nullable
            public FluidStack getContent() {
                return TileZombieGenerator.this.tank.getFluid();
            }

            public int getCapacity() {
                return TileZombieGenerator.this.tank.getCapacity();
            }
        });
    }

    protected SmartTankFluidHandler getSmartTankFluidHandler() {
        if (this.smartTankFluidHandler == null) {
            this.smartTankFluidHandler = new SmartTankFluidMachineHandler(this, new IFluidHandler[]{this.tank});
        }
        return this.smartTankFluidHandler;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facingIn) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.getSmartTankFluidHandler().get(facingIn);
        }
        return super.getCapability(capability, facingIn);
    }
}

