/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import com.enderio.core.common.util.Util;
import crazypants.enderio.capability.ItemTools;
import crazypants.enderio.capability.LegacyMachineWrapper;
import crazypants.enderio.capacitor.CapacitorHelper;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.util.Prep;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

@Storable
public abstract class AbstractInventoryMachineEntity
extends AbstractMachineEntity
implements ISidedInventory {
    @Store
    protected ItemStack[] inventory;
    protected final SlotDefinition slotDefinition;
    @Nonnull
    private final int[] allSlots;

    public AbstractInventoryMachineEntity(SlotDefinition slotDefinition) {
        this.slotDefinition = slotDefinition;
        this.inventory = new ItemStack[slotDefinition.getNumSlots()];
        this.allSlots = new int[slotDefinition.getNumSlots()];
        for (int i = 0; i < this.allSlots.length; ++i) {
            this.allSlots[i] = i;
        }
    }

    public SlotDefinition getSlotDefinition() {
        return this.slotDefinition;
    }

    public boolean isValidUpgrade(@Nonnull ItemStack itemstack) {
        for (int i = this.slotDefinition.getMinUpgradeSlot(); i <= this.slotDefinition.getMaxUpgradeSlot(); ++i) {
            if (!this.func_94041_b(i, itemstack)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidInput(@Nonnull ItemStack itemstack) {
        for (int i = this.slotDefinition.getMinInputSlot(); i <= this.slotDefinition.getMaxInputSlot(); ++i) {
            if (!this.func_94041_b(i, itemstack)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidOutput(@Nonnull ItemStack itemstack) {
        for (int i = this.slotDefinition.getMinOutputSlot(); i <= this.slotDefinition.getMaxOutputSlot(); ++i) {
            if (!this.func_94041_b(i, itemstack)) continue;
            return true;
        }
        return false;
    }

    public final boolean func_94041_b(int i, ItemStack itemstack) {
        if (Prep.isInvalid(itemstack)) {
            return false;
        }
        if (this.slotDefinition.isUpgradeSlot(i)) {
            return CapacitorHelper.isValidUpgrade(itemstack);
        }
        return this.isMachineItemValidForSlot(i, itemstack);
    }

    public abstract boolean isMachineItemValidForSlot(int var1, ItemStack var2);

    @Override
    protected boolean doPush(@Nullable EnumFacing dir) {
        if (dir == null || this.slotDefinition.getNumOutputSlots() <= 0 || !this.shouldDoWorkThisTick(20) || !this.hasStuffToPush()) {
            return false;
        }
        ItemTools.MoveResult res = ItemTools.move(this.getPushLimit(), (IBlockAccess)this.field_145850_b, this.func_174877_v(), dir, this.func_174877_v().func_177972_a(dir), dir.func_176734_d());
        return res == ItemTools.MoveResult.MOVED;
    }

    @Override
    protected boolean doPull(@Nullable EnumFacing dir) {
        if (dir == null || this.slotDefinition.getNumInputSlots() <= 0 || !this.shouldDoWorkThisTick(20) || !this.hasSpaceToPull()) {
            return false;
        }
        ItemTools.MoveResult res = ItemTools.move(this.getPullLimit(), (IBlockAccess)this.field_145850_b, this.func_174877_v().func_177972_a(dir), dir.func_176734_d(), this.func_174877_v(), dir);
        return res == ItemTools.MoveResult.MOVED;
    }

    protected boolean hasStuffToPush() {
        for (int slot = this.slotDefinition.minOutputSlot; slot <= this.slotDefinition.maxOutputSlot; ++slot) {
            if (!Prep.isValid(this.inventory[slot])) continue;
            return true;
        }
        return false;
    }

    protected boolean hasSpaceToPull() {
        boolean hasSpace = false;
        for (int slot = this.slotDefinition.minInputSlot; slot <= this.slotDefinition.maxInputSlot && !hasSpace; ++slot) {
            hasSpace = Prep.isInvalid(this.inventory[slot]) ? true : this.inventory[slot].field_77994_a < Math.min(this.inventory[slot].func_77976_d(), this.getInventoryStackLimit(slot));
        }
        return hasSpace;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public final boolean hasCapability(Capability<?> capability, EnumFacing facing1) {
        return this.getCapability(capability, facing1) != null;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing1) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)new LegacyMachineWrapper(this, facing1);
        }
        return (T)super.getCapability(capability, facing1);
    }

    public int func_70302_i_() {
        return this.slotDefinition.getNumSlots();
    }

    public int getInventoryStackLimit(int slot) {
        return this.func_70297_j_();
    }

    public int func_70297_j_() {
        return 64;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot < 0 || slot >= this.inventory.length) {
            return null;
        }
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return Util.decrStackSize((IInventory)this, (int)slot, (int)amount);
    }

    public void func_70299_a(int slot, @Nullable ItemStack contents) {
        if (Prep.isInvalid(contents)) {
            this.inventory[slot] = Prep.getEmpty();
        } else {
            this.inventory[slot] = contents.func_77946_l();
            if (this.inventory[slot].field_77994_a > this.getInventoryStackLimit(slot)) {
                this.inventory[slot].field_77994_a = this.getInventoryStackLimit(slot);
                contents.field_77994_a -= this.getInventoryStackLimit(slot);
                Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)contents);
            }
        }
        this.func_70296_d();
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inventory.length; ++i) {
            this.inventory[i] = null;
        }
        this.func_70296_d();
    }

    public ItemStack func_70304_b(int index) {
        ItemStack res = this.inventory[index];
        this.inventory[index] = Prep.getEmpty();
        this.func_70296_d();
        return res;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    @Nonnull
    public String func_70005_c_() {
        return this.getMachineName();
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    @Nonnull
    public int[] func_180463_a(EnumFacing var1) {
        if (this.isSideDisabled(var1)) {
            return new int[0];
        }
        return this.allSlots;
    }

    public boolean func_180462_a(int slot, ItemStack itemstack, EnumFacing side) {
        if (this.isSideDisabled(side) || !this.slotDefinition.isInputSlot(slot)) {
            return false;
        }
        ItemStack existing = this.inventory[slot];
        if (existing != null) {
            return existing.func_77985_e() && existing.field_77994_a < existing.func_77976_d() && existing.func_77969_a(itemstack);
        }
        return this.isMachineItemValidForSlot(slot, itemstack);
    }

    public boolean func_180461_b(int slot, ItemStack itemstack, EnumFacing side) {
        if (this.isSideDisabled(side)) {
            return false;
        }
        if (!this.slotDefinition.isOutputSlot(slot)) {
            return false;
        }
        return this.canExtractItem(slot, itemstack);
    }

    protected boolean canExtractItem(int slot, ItemStack itemstack) {
        if (this.inventory[slot] == null || this.inventory[slot].field_77994_a < itemstack.field_77994_a) {
            return false;
        }
        return itemstack.func_77973_b() == this.inventory[slot].func_77973_b();
    }
}

