/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel.upgrade;

import com.enderio.core.common.util.Log;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.darksteel.DarkSteelController;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.item.darksteel.upgrade.SpeedUpgrade;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SpeedController {
    @Nonnull
    private static final AttributeModifier[] walkModifiers = new AttributeModifier[]{new AttributeModifier(new UUID(12879874982L, 320981923L), "generic.movementSpeed", (double)SpeedUpgrade.WALK_MULTIPLIERS[0], 1), new AttributeModifier(new UUID(12879874982L, 320981923L), "generic.movementSpeed", (double)SpeedUpgrade.WALK_MULTIPLIERS[1], 1), new AttributeModifier(new UUID(12879874982L, 320981923L), "generic.movementSpeed", (double)SpeedUpgrade.WALK_MULTIPLIERS[2], 1)};
    @Nonnull
    private static final AttributeModifier[] sprintModifiers = new AttributeModifier[]{new AttributeModifier(new UUID(12879874982L, 320981923L), "generic.movementSpeed", (double)SpeedUpgrade.SPRINT_MULTIPLIERS[0], 1), new AttributeModifier(new UUID(12879874982L, 320981923L), "generic.movementSpeed", (double)SpeedUpgrade.SPRINT_MULTIPLIERS[1], 1), new AttributeModifier(new UUID(12879874982L, 320981923L), "generic.movementSpeed", (double)SpeedUpgrade.SPRINT_MULTIPLIERS[2], 1)};
    private boolean ignoreFovEvent = false;

    public void updateSpeed(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K || !player.field_70122_E) {
            return;
        }
        IAttributeInstance moveInst = player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d);
        if (moveInst.func_111127_a(walkModifiers[0].func_111167_a()) != null) {
            moveInst.func_188479_b(walkModifiers[0].func_111167_a());
        } else if (moveInst.func_111127_a(sprintModifiers[0].func_111167_a()) != null) {
            moveInst.func_188479_b(sprintModifiers[0].func_111167_a());
        }
        SpeedUpgrade speedUpgrade = this.getActiveSpeedUpgrade(player);
        if (speedUpgrade == null) {
            return;
        }
        double horzMovement = Math.abs(player.field_70140_Q - player.field_70141_P);
        double costModifier = player.func_70051_ag() ? (double)Config.darkSteelSprintPowerCost : (double)Config.darkSteelWalkPowerCost;
        costModifier += costModifier * (double)speedUpgrade.getWalkMultiplier();
        int cost = (int)(horzMovement * costModifier);
        DarkSteelController.instance.usePlayerEnergy(player, DarkSteelItems.itemDarkSteelLeggings, cost);
        if (player.func_70051_ag()) {
            moveInst.func_111121_a(sprintModifiers[speedUpgrade.getLevel() - 1]);
        } else {
            moveInst.func_111121_a(walkModifiers[speedUpgrade.getLevel() - 1]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void handleFovUpdate(FOVUpdateEvent evt) {
        if (this.ignoreFovEvent) {
            return;
        }
        boolean limitFov = true;
        boolean disableFov = false;
        if (!limitFov && !disableFov) {
            return;
        }
        EntityPlayer player = evt.getEntity();
        SpeedUpgrade speedUpgrade = this.getActiveSpeedUpgrade(player);
        if (speedUpgrade == null) {
            return;
        }
        if (disableFov) {
            if (!this.isBowDrawn(player)) {
                evt.setNewfov(1.0f);
            } else {
                evt.setNewfov(this.getVanillaFovModifier(player));
            }
        } else if (limitFov) {
            IAttributeInstance moveInst = player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d);
            if (moveInst.func_111127_a(walkModifiers[0].func_111167_a()) != null) {
                moveInst.func_188479_b(walkModifiers[0].func_111167_a());
            } else if (moveInst.func_111127_a(sprintModifiers[0].func_111167_a()) != null) {
                moveInst.func_188479_b(sprintModifiers[0].func_111167_a());
            }
            evt.setNewfov(this.getVanillaFovModifier(player));
            if (player.func_70051_ag()) {
                moveInst.func_111121_a(sprintModifiers[speedUpgrade.getLevel() - 1]);
            } else {
                moveInst.func_111121_a(walkModifiers[speedUpgrade.getLevel() - 1]);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private float getVanillaFovModifier(EntityPlayer player) {
        if (!(player instanceof AbstractClientPlayer)) {
            Log.warn((String)("invalid player type when adjusting FOV " + player));
            return 1.0f;
        }
        try {
            this.ignoreFovEvent = true;
            float f = ((AbstractClientPlayer)player).func_175156_o();
            return f;
        }
        finally {
            this.ignoreFovEvent = false;
        }
    }

    private boolean isBowDrawn(EntityPlayer player) {
        return player.func_184587_cr() && player.func_184607_cu() != null && player.func_184607_cu().func_77973_b() == Items.field_151031_f;
    }

    private SpeedUpgrade getActiveSpeedUpgrade(EntityPlayer player) {
        ItemStack leggings = player.func_184582_a(EntityEquipmentSlot.LEGS);
        if (leggings == null || leggings.func_77973_b() != DarkSteelItems.itemDarkSteelLeggings) {
            return null;
        }
        SpeedUpgrade speedUpgrade = SpeedUpgrade.loadFromItem(leggings);
        if (speedUpgrade == null) {
            return null;
        }
        if (DarkSteelController.instance.isSpeedActive(player) && DarkSteelController.instance.getPlayerEnergy(player, DarkSteelItems.itemDarkSteelLeggings) > 0) {
            return speedUpgrade;
        }
        return null;
    }
}

