/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel.upgrade;

import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.item.darksteel.upgrade.AbstractUpgrade;
import crazypants.enderio.item.darksteel.upgrade.EnergyUpgrade;
import crazypants.enderio.item.darksteel.upgrade.IRenderUpgrade;
import crazypants.enderio.item.darksteel.upgrade.SolarUpgradeLayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SolarUpgrade
extends AbstractUpgrade {
    private static final String KEY_LEVEL = "level";
    private static final String UPGRADE_NAME = "solar";
    public static final SolarUpgrade SOLAR_ONE = new SolarUpgrade("enderio.darksteel.upgrade.solar_one", 1, Config.darkSteelSolarOneCost);
    public static final SolarUpgrade SOLAR_TWO = new SolarUpgrade("enderio.darksteel.upgrade.solar_two", 2, Config.darkSteelSolarTwoCost);
    public static final SolarUpgrade SOLAR_THREE = new SolarUpgrade("enderio.darksteel.upgrade.solar_three", 3, Config.darkSteelSolarThreeCost);
    private final byte level;

    public static SolarUpgrade loadFromItem(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.func_77978_p() == null) {
            return null;
        }
        if (!stack.func_77978_p().func_74764_b("enderio.darksteel.upgrade.solar")) {
            return null;
        }
        return new SolarUpgrade((NBTTagCompound)stack.func_77978_p().func_74781_a("enderio.darksteel.upgrade.solar"));
    }

    public SolarUpgrade(NBTTagCompound tag) {
        super(UPGRADE_NAME, tag);
        this.level = tag.func_74771_c(KEY_LEVEL);
    }

    public SolarUpgrade(String unlocName, byte level, int levelCost) {
        super(UPGRADE_NAME, unlocName, new ItemStack(ModObject.blockSolarPanel.getBlock(), 1, level - 1), levelCost);
        this.level = level;
    }

    @Override
    public boolean canAddToItem(ItemStack stack) {
        if (stack == null || stack.func_77973_b() != DarkSteelItems.itemDarkSteelHelmet || !EnergyUpgrade.itemHasAnyPowerUpgrade(stack)) {
            return false;
        }
        SolarUpgrade up = SolarUpgrade.loadFromItem(stack);
        if (up == null) {
            return this.getLevel() == 1;
        }
        return up.getLevel() == this.getLevel() - 1;
    }

    @Override
    public boolean hasUpgrade(ItemStack stack) {
        if (!super.hasUpgrade(stack)) {
            return false;
        }
        SolarUpgrade up = SolarUpgrade.loadFromItem(stack);
        if (up == null) {
            return false;
        }
        return up.unlocName.equals(this.unlocName);
    }

    @Override
    public void writeUpgradeToNBT(NBTTagCompound upgradeRoot) {
        upgradeRoot.func_74774_a(KEY_LEVEL, this.getLevel());
    }

    public int getRFPerSec() {
        return this.getLevel() == 1 ? Config.darkSteelSolarOneGen : (this.getLevel() == 2 ? Config.darkSteelSolarTwoGen : Config.darkSteelSolarThreeGen);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderUpgrade getRender() {
        return SolarUpgradeLayer.instance;
    }

    public byte getLevel() {
        return this.level;
    }
}

