/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.enchantment;

import com.enderio.core.api.common.enchant.IAdvancedEnchant;
import crazypants.enderio.EnderIO;
import crazypants.enderio.Log;
import crazypants.enderio.config.Config;
import crazypants.enderio.integration.baubles.BaublesUtil;
import crazypants.enderio.integration.galacticraft.GalacticraftUtil;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class EnchantmentSoulBound
extends Enchantment
implements IAdvancedEnchant {
    @Nonnull
    private static final String NAME = "soulBound";

    public static EnchantmentSoulBound create() {
        EnchantmentSoulBound res = new EnchantmentSoulBound();
        MinecraftForge.EVENT_BUS.register((Object)res);
        GameRegistry.register((IForgeRegistryEntry)res);
        return res;
    }

    private EnchantmentSoulBound() {
        super(Config.enchantmentSoulBoundRarity, EnumEnchantmentType.ALL, EntityEquipmentSlot.values());
        this.func_77322_b(NAME);
        this.setRegistryName(NAME);
    }

    public int func_77317_b(int level) {
        return 60;
    }

    public int func_77321_a(int level) {
        return 16;
    }

    public int func_77325_b() {
        return 1;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerDeath(PlayerDropsEvent evt) {
        IInventory galacticraft;
        if (evt.getEntityPlayer() == null || evt.getEntityPlayer() instanceof FakePlayer || evt.isCanceled()) {
            return;
        }
        if (evt.getEntityPlayer().field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            return;
        }
        Log.debug("Running onPlayerDeathEarly logic for " + evt.getEntityPlayer().func_70005_c_());
        ListIterator iter = evt.getDrops().listIterator();
        while (iter.hasNext()) {
            EntityItem ei = (EntityItem)iter.next();
            ItemStack item = ei.func_92059_d();
            if (!this.isSoulBound(item) || !this.addToPlayerInventory(evt.getEntityPlayer(), item)) continue;
            iter.remove();
        }
        IInventory baubles = BaublesUtil.instance().getBaubles(evt.getEntityPlayer());
        if (baubles != null) {
            for (int i = 0; i < baubles.func_70302_i_(); ++i) {
                ItemStack item = baubles.func_70301_a(i);
                if (!this.isSoulBound(item) || !this.addToPlayerInventory(evt.getEntityPlayer(), item)) continue;
                baubles.func_70299_a(i, null);
            }
        }
        if (evt.getEntityPlayer() instanceof EntityPlayerMP && (galacticraft = GalacticraftUtil.getGCInventoryForPlayer((EntityPlayerMP)evt.getEntityPlayer())) != null) {
            for (int i = 0; i < galacticraft.func_70302_i_(); ++i) {
                ItemStack item = galacticraft.func_70301_a(i);
                if (!this.isSoulBound(item) || !this.addToPlayerInventory(evt.getEntityPlayer(), item)) continue;
                galacticraft.func_70299_a(i, null);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerDeathLate(PlayerDropsEvent evt) {
        if (evt.getEntityPlayer() == null || evt.getEntityPlayer() instanceof FakePlayer || evt.isCanceled()) {
            return;
        }
        if (evt.getEntityPlayer().field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            return;
        }
        Log.debug("Running onPlayerDeathLate logic for " + evt.getEntityPlayer().func_70005_c_());
        ListIterator iter = evt.getDrops().listIterator();
        while (iter.hasNext()) {
            EntityItem ei = (EntityItem)iter.next();
            ItemStack item = ei.func_92059_d();
            if (!this.isSoulBound(item) || !this.addToPlayerInventory(evt.getEntityPlayer(), item)) continue;
            iter.remove();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerClone(PlayerEvent.Clone evt) {
        ItemStack item;
        int i;
        if (!evt.isWasDeath() || evt.isCanceled()) {
            return;
        }
        if (evt.getOriginal() == null || evt.getEntityPlayer() == null || evt.getEntityPlayer() instanceof FakePlayer) {
            return;
        }
        if (evt.getEntityPlayer().field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            return;
        }
        if (evt.getOriginal() == evt.getEntityPlayer() || evt.getOriginal().field_71071_by == evt.getEntityPlayer().field_71071_by || evt.getOriginal().field_71071_by.field_70460_b == evt.getEntityPlayer().field_71071_by.field_70460_b && evt.getOriginal().field_71071_by.field_70462_a == evt.getEntityPlayer().field_71071_by.field_70462_a) {
            Log.warn("Player " + evt.getEntityPlayer().func_70005_c_() + " just died and respawned in their old body. Did someone fire a PlayerEvent.Clone(death=true) for a teleportation? Supressing Soulbound enchantment for zombie player.");
            return;
        }
        Log.debug("Running onPlayerCloneEarly logic for " + evt.getEntityPlayer().func_70005_c_());
        for (i = 0; i < evt.getOriginal().field_71071_by.field_70460_b.length; ++i) {
            item = evt.getOriginal().field_71071_by.field_70460_b[i];
            if (!this.isSoulBound(item) || !this.addToPlayerInventory(evt.getEntityPlayer(), item)) continue;
            evt.getOriginal().field_71071_by.field_70460_b[i] = null;
        }
        for (i = 0; i < evt.getOriginal().field_71071_by.field_70462_a.length; ++i) {
            item = evt.getOriginal().field_71071_by.field_70462_a[i];
            if (!this.isSoulBound(item) || !this.addToPlayerInventory(evt.getEntityPlayer(), item)) continue;
            evt.getOriginal().field_71071_by.field_70462_a[i] = null;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerCloneLast(PlayerEvent.Clone evt) {
        ItemStack item;
        int i;
        if (!evt.isWasDeath() || evt.isCanceled()) {
            return;
        }
        if (evt.getOriginal() == null || evt.getEntityPlayer() == null || evt.getEntityPlayer() instanceof FakePlayer) {
            return;
        }
        if (evt.getEntityPlayer().field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            return;
        }
        if (evt.getOriginal() == evt.getEntityPlayer() || evt.getOriginal().field_71071_by == evt.getEntityPlayer().field_71071_by || evt.getOriginal().field_71071_by.field_70460_b == evt.getEntityPlayer().field_71071_by.field_70460_b && evt.getOriginal().field_71071_by.field_70462_a == evt.getEntityPlayer().field_71071_by.field_70462_a) {
            return;
        }
        Log.debug("Running onPlayerCloneLate logic for " + evt.getEntityPlayer().func_70005_c_());
        for (i = 0; i < evt.getOriginal().field_71071_by.field_70460_b.length; ++i) {
            item = evt.getOriginal().field_71071_by.field_70460_b[i];
            if (item == null || !this.isSoulBound(item) || !this.addToPlayerInventory(evt.getEntityPlayer(), item) && !this.tryToSpawnItemInWorld(evt.getOriginal(), item)) continue;
            evt.getOriginal().field_71071_by.field_70460_b[i] = null;
        }
        for (i = 0; i < evt.getOriginal().field_71071_by.field_70462_a.length; ++i) {
            item = evt.getOriginal().field_71071_by.field_70462_a[i];
            if (item == null || !this.isSoulBound(item) || !this.addToPlayerInventory(evt.getEntityPlayer(), item) && !this.tryToSpawnItemInWorld(evt.getOriginal(), item)) continue;
            evt.getOriginal().field_71071_by.field_70462_a[i] = null;
        }
    }

    private boolean tryToSpawnItemInWorld(EntityPlayer entityPlayer, @Nonnull ItemStack item) {
        if (entityPlayer != null && entityPlayer.field_70170_p != null) {
            EntityItem entityitem = new EntityItem(entityPlayer.field_70170_p, entityPlayer.field_70165_t, entityPlayer.field_70163_u + 0.5, entityPlayer.field_70161_v, item);
            entityitem.func_174867_a(40);
            entityitem.lifespan *= 2;
            entityitem.field_70159_w = 0.0;
            entityitem.field_70179_y = 0.0;
            entityPlayer.field_70170_p.func_72838_d((Entity)entityitem);
            Log.debug("Running tryToSpawnItemInWorld logic for " + entityPlayer.func_70005_c_() + ": " + item);
            return true;
        }
        return false;
    }

    private boolean isSoulBound(ItemStack item) {
        return EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)item) > 0;
    }

    private boolean addToPlayerInventory(EntityPlayer entityPlayer, ItemStack item) {
        if (item == null || entityPlayer == null) {
            return false;
        }
        if (item.func_77973_b() instanceof ItemArmor) {
            ItemArmor arm = (ItemArmor)item.func_77973_b();
            int index = arm.field_77881_a.func_188454_b();
            if (entityPlayer.field_71071_by.field_70460_b[index] == null) {
                entityPlayer.field_71071_by.field_70460_b[index] = item;
                Log.debug("Running addToPlayerInventory/armor logic for " + entityPlayer.func_70005_c_() + ": " + item);
                return true;
            }
        }
        InventoryPlayer inv = entityPlayer.field_71071_by;
        for (int i = 0; i < inv.field_70462_a.length; ++i) {
            if (inv.field_70462_a[i] != null) continue;
            inv.field_70462_a[i] = item.func_77946_l();
            Log.debug("Running addToPlayerInventory/main logic for " + entityPlayer.func_70005_c_() + ": " + item);
            return true;
        }
        Log.debug("Running addToPlayerInventory/fail logic for " + entityPlayer.func_70005_c_() + ": " + item);
        return false;
    }

    public String[] getTooltipDetails(ItemStack stack) {
        return new String[]{EnderIO.lang.localizeExact("description.enchantment.enderio.soulBound")};
    }
}

