/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.liquid;

import com.enderio.core.api.client.gui.ITabPanel;
import com.enderio.core.common.fluid.FluidWrapper;
import com.enderio.core.common.fluid.IFluidWrapper;
import com.enderio.core.common.util.DyeColor;
import crazypants.enderio.conduit.AbstractConduit;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.gui.LiquidSettings;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.machine.RedstoneControlMode;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractLiquidConduit
extends AbstractConduit
implements ILiquidConduit {
    protected final EnumMap<EnumFacing, RedstoneControlMode> extractionModes = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, DyeColor> extractionColors = new EnumMap(EnumFacing.class);

    public static IFluidWrapper getExternalFluidHandler(IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (world.func_175625_s(pos) instanceof IConduitBundle) {
            return null;
        }
        return FluidWrapper.wrap((IBlockAccess)world, (BlockPos)pos, (EnumFacing)side);
    }

    public IFluidWrapper getExternalHandler(EnumFacing direction) {
        return AbstractLiquidConduit.getExternalFluidHandler((IBlockAccess)this.getBundle().getBundleWorldObj(), this.getLocation().getLocation(direction).getBlockPos(), direction.func_176734_d());
    }

    @Override
    public boolean canConnectToExternal(EnumFacing direction, boolean ignoreDisabled) {
        IFluidWrapper h = this.getExternalHandler(direction);
        return h != null;
    }

    @Override
    public Class<? extends IConduit> getBaseConduitType() {
        return ILiquidConduit.class;
    }

    @Override
    public void setExtractionRedstoneMode(RedstoneControlMode mode, EnumFacing dir) {
        this.extractionModes.put(dir, mode);
    }

    @Override
    @Nonnull
    public RedstoneControlMode getExtractionRedstoneMode(EnumFacing dir) {
        RedstoneControlMode res = this.extractionModes.get(dir);
        if (res == null) {
            res = RedstoneControlMode.NEVER;
        }
        return res;
    }

    @Override
    public void setExtractionSignalColor(EnumFacing dir, DyeColor col) {
        this.extractionColors.put(dir, col);
    }

    @Override
    public DyeColor getExtractionSignalColor(EnumFacing dir) {
        DyeColor result = this.extractionColors.get(dir);
        if (result == null) {
            return DyeColor.RED;
        }
        return result;
    }

    @Override
    public boolean canOutputToDir(EnumFacing dir) {
        if (!this.canInputToDir(dir)) {
            return false;
        }
        if (this.conduitConnections.contains(dir)) {
            return true;
        }
        return this.externalConnections.contains(dir);
    }

    protected boolean autoExtractForDir(EnumFacing dir) {
        if (!this.canExtractFromDir(dir)) {
            return false;
        }
        RedstoneControlMode mode = this.getExtractionRedstoneMode(dir);
        return ConduitUtil.isRedstoneControlModeMet(this, mode, this.getExtractionSignalColor(dir));
    }

    @Override
    public boolean canExtractFromDir(EnumFacing dir) {
        return this.getConnectionMode(dir).acceptsInput();
    }

    @Override
    public boolean canInputToDir(EnumFacing dir) {
        return this.getConnectionMode(dir).acceptsOutput() && !this.autoExtractForDir(dir);
    }

    protected boolean hasExtractableMode() {
        return this.hasConnectionMode(ConnectionMode.INPUT) || this.hasConnectionMode(ConnectionMode.IN_OUT);
    }

    @Override
    protected void readTypeSettings(EnumFacing dir, NBTTagCompound dataRoot) {
        this.setExtractionSignalColor(dir, DyeColor.values()[dataRoot.func_74765_d("extractionSignalColor")]);
        this.setExtractionRedstoneMode(RedstoneControlMode.values()[dataRoot.func_74765_d("extractionRedstoneMode")], dir);
    }

    @Override
    protected void writeTypeSettingsToNbt(EnumFacing dir, NBTTagCompound dataRoot) {
        dataRoot.func_74777_a("extractionSignalColor", (short)this.getExtractionSignalColor(dir).ordinal());
        dataRoot.func_74777_a("extractionRedstoneMode", (short)this.getExtractionRedstoneMode(dir).ordinal());
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtRoot) {
        short ord;
        super.writeToNBT(nbtRoot);
        for (Map.Entry<EnumFacing, RedstoneControlMode> entry : this.extractionModes.entrySet()) {
            if (entry.getValue() == null) continue;
            ord = (short)entry.getValue().ordinal();
            nbtRoot.func_74777_a("extRM." + entry.getKey().name(), ord);
        }
        for (Map.Entry<EnumFacing, RedstoneControlMode> entry : this.extractionColors.entrySet()) {
            if (entry.getValue() == null) continue;
            ord = (short)((DyeColor)entry.getValue()).ordinal();
            nbtRoot.func_74777_a("extSC." + entry.getKey().name(), ord);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtRoot, short nbtVersion) {
        super.readFromNBT(nbtRoot, nbtVersion);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            short ord;
            String key = "extRM." + dir.name();
            if (nbtRoot.func_74764_b(key) && (ord = nbtRoot.func_74765_d(key)) >= 0 && ord < RedstoneControlMode.values().length) {
                this.extractionModes.put(dir, RedstoneControlMode.values()[ord]);
            }
            if (!nbtRoot.func_74764_b(key = "extSC." + dir.name()) || (ord = nbtRoot.func_74765_d(key)) < 0 || ord >= DyeColor.values().length) continue;
            this.extractionColors.put(dir, DyeColor.values()[ord]);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ITabPanel createPanelForConduit(GuiExternalConnection gui, IConduit con) {
        return new LiquidSettings(gui, con);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getTabOrderForConduit(IConduit con) {
        return 1;
    }
}

