/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.forestry.capability.work;

import forestry.api.core.IErrorState;
import forestry.core.errors.EnumErrorCode;
import forestry.core.tiles.TilePowered;
import org.cyclops.commoncapabilities.api.capability.work.IWorker;

public class TilePoweredWorker
implements IWorker {
    private final TilePowered tile;

    public TilePoweredWorker(TilePowered tile) {
        this.tile = tile;
    }

    @Override
    public boolean hasWork() {
        try {
            return this.tile.hasWork();
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    protected boolean isRedstoneEnabled() {
        return this.tile.func_145831_w().func_175687_A(this.tile.func_174877_v()) > 0;
    }

    protected boolean hasEnoughEnergy() {
        return this.tile.getWorkCounter() > 0 || this.tile.getEnergyManager().getTotalEnergyStored() > 0 && !this.tile.getErrorLogic().contains((IErrorState)EnumErrorCode.NO_POWER);
    }

    @Override
    public boolean canWork() {
        return !this.isRedstoneEnabled() && this.hasEnoughEnergy();
    }
}

