/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.proxy;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.util.concurrent.Callable;
import mcjty.lib.base.GeneralConfig;
import mcjty.lib.network.PacketHandler;
import mcjty.lib.varia.WrenchChecker;
import mcjty.rftoolscontrol.ModCrafting;
import mcjty.rftoolscontrol.RFToolsControl;
import mcjty.rftoolscontrol.blocks.ModBlocks;
import mcjty.rftoolscontrol.config.GeneralConfiguration;
import mcjty.rftoolscontrol.gui.GuiProxy;
import mcjty.rftoolscontrol.items.ModItems;
import mcjty.rftoolscontrol.logic.registry.Functions;
import mcjty.rftoolscontrol.logic.registry.Opcodes;
import mcjty.rftoolscontrol.network.RFToolsCtrlMessages;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import org.apache.logging.log4j.Level;

public abstract class CommonProxy {
    public static File modConfigDir;
    private Configuration mainConfig;

    public void preInit(FMLPreInitializationEvent e) {
        GeneralConfig.preInit((FMLPreInitializationEvent)e);
        modConfigDir = e.getModConfigurationDirectory();
        this.mainConfig = new Configuration(new File(modConfigDir.getPath() + File.separator + "rftools", "control.cfg"));
        this.readMainConfig();
        SimpleNetworkWrapper network = PacketHandler.registerMessages((String)"rftoolscontrol", (String)"rftoolsctrl");
        RFToolsCtrlMessages.registerNetworkMessages(network);
        Opcodes.init();
        Functions.init();
        ModItems.init();
        ModBlocks.init();
    }

    private void readMainConfig() {
        Configuration cfg = this.mainConfig;
        try {
            cfg.load();
            cfg.addCustomCategoryComment("general", "General settings");
            GeneralConfiguration.init(cfg);
        }
        catch (Exception e1) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e1, (String)"Problem loading config file!", (Object[])new Object[0]);
        }
        finally {
            if (this.mainConfig.hasChanged()) {
                this.mainConfig.save();
            }
        }
    }

    public void init(FMLInitializationEvent e) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)RFToolsControl.instance, (IGuiHandler)new GuiProxy());
        ModCrafting.init();
    }

    public void postInit(FMLPostInitializationEvent e) {
        if (this.mainConfig.hasChanged()) {
            this.mainConfig.save();
        }
        this.mainConfig = null;
        WrenchChecker.init();
    }

    public World getClientWorld() {
        throw new IllegalStateException("This should only be called from client side");
    }

    public EntityPlayer getClientPlayer() {
        throw new IllegalStateException("This should only be called from client side");
    }

    public <V> ListenableFuture<V> addScheduledTaskClient(Callable<V> callableToSchedule) {
        throw new IllegalStateException("This should only be called from client side");
    }

    public ListenableFuture<Object> addScheduledTaskClient(Runnable runnableToSchedule) {
        throw new IllegalStateException("This should only be called from client side");
    }
}

