/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.network;

import io.netty.buffer.ByteBuf;
import java.util.List;
import mcjty.lib.network.ClientCommandHandler;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.PacketListToClient;
import mcjty.lib.tools.ItemStackTools;
import mcjty.lib.varia.Logging;
import mcjty.rftoolscontrol.RFToolsControl;
import mcjty.typed.Type;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketCraftableItemsReady
extends PacketListToClient<ItemStack> {
    public PacketCraftableItemsReady() {
    }

    public PacketCraftableItemsReady(BlockPos pos, String command, List<ItemStack> list) {
        super(pos, command, list);
    }

    protected ItemStack createItem(ByteBuf buf) {
        if (buf.readBoolean()) {
            return NetworkTools.readItemStack((ByteBuf)buf);
        }
        return ItemStackTools.getEmptyStack();
    }

    protected void writeItemToBuf(ByteBuf buf, ItemStack s) {
        if (ItemStackTools.isEmpty((ItemStack)s)) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)s);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketCraftableItemsReady, IMessage> {
        public IMessage onMessage(PacketCraftableItemsReady message, MessageContext ctx) {
            RFToolsControl.proxy.addScheduledTaskClient(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketCraftableItemsReady message, MessageContext ctx) {
            TileEntity te = RFToolsControl.proxy.getClientWorld().func_175625_s(message.pos);
            if (!(te instanceof ClientCommandHandler)) {
                Logging.log((String)"TileEntity is not a ClientCommandHandler!");
                return;
            }
            ClientCommandHandler clientCommandHandler = (ClientCommandHandler)te;
            if (!clientCommandHandler.execute(message.command, message.list, Type.create(ItemStack.class))) {
                Logging.log((String)("Command " + message.command + " was not handled!"));
            }
        }
    }
}

