/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.clipboard.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0007\b\u0016\u00a2\u0006\u0002\u0010\tB#\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001f"}, d2={"Lnet/shadowfacts/clipboard/network/PacketUpdateClipboard;", "Lnet/minecraftforge/fml/common/network/simpleimpl/IMessage;", "stack", "Lnet/minecraft/item/ItemStack;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/util/EnumHand;)V", "()V", "Ljava/util/UUID;", "tag", "Lnet/minecraft/nbt/NBTTagCompound;", "(Ljava/util/UUID;Lnet/minecraft/util/EnumHand;Lnet/minecraft/nbt/NBTTagCompound;)V", "getHand", "()Lnet/minecraft/util/EnumHand;", "setHand", "(Lnet/minecraft/util/EnumHand;)V", "getPlayer", "()Ljava/util/UUID;", "setPlayer", "(Ljava/util/UUID;)V", "getTag", "()Lnet/minecraft/nbt/NBTTagCompound;", "setTag", "(Lnet/minecraft/nbt/NBTTagCompound;)V", "fromBytes", "", "buf", "Lio/netty/buffer/ByteBuf;", "toBytes", "Clipboard-compileKotlin"})
public final class PacketUpdateClipboard
implements IMessage {
    @Nullable
    private UUID player;
    @Nullable
    private EnumHand hand;
    @Nullable
    private NBTTagCompound tag;

    public void toBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        UUID uUID = this.player;
        if (uUID == null) {
            Intrinsics.throwNpe();
        }
        buf.writeLong(uUID.getMostSignificantBits());
        UUID uUID2 = this.player;
        if (uUID2 == null) {
            Intrinsics.throwNpe();
        }
        buf.writeLong(uUID2.getLeastSignificantBits());
        EnumHand enumHand = this.hand;
        if (enumHand == null) {
            Intrinsics.throwNpe();
        }
        buf.writeInt(enumHand.ordinal());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        this.player = new UUID(buf.readLong(), buf.readLong());
        this.hand = EnumHand.values()[buf.readInt()];
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
    }

    @Nullable
    public final UUID getPlayer() {
        return this.player;
    }

    public final void setPlayer(@Nullable UUID uUID) {
        this.player = uUID;
    }

    @Nullable
    public final EnumHand getHand() {
        return this.hand;
    }

    public final void setHand(@Nullable EnumHand enumHand) {
        this.hand = enumHand;
    }

    @Nullable
    public final NBTTagCompound getTag() {
        return this.tag;
    }

    public final void setTag(@Nullable NBTTagCompound nBTTagCompound) {
        this.tag = nBTTagCompound;
    }

    public PacketUpdateClipboard(@Nullable UUID player, @Nullable EnumHand hand, @Nullable NBTTagCompound tag) {
        this.player = player;
        this.hand = hand;
        this.tag = tag;
    }

    public PacketUpdateClipboard(@NotNull ItemStack stack, @NotNull EntityPlayer player, @NotNull EnumHand hand) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        UUID uUID = player.func_110124_au();
        NBTTagCompound nBTTagCompound = stack.func_77978_p();
        if (nBTTagCompound == null) {
            Intrinsics.throwNpe();
        }
        this(uUID, hand, nBTTagCompound);
    }

    public PacketUpdateClipboard() {
        this((UUID)null, (EnumHand)null, (NBTTagCompound)null);
    }
}

