/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.subblocksystem;

import com.google.common.collect.Maps;
import com.teamacronymcoders.base.IBaseMod;
import com.teamacronymcoders.base.registry.BlockRegistry;
import com.teamacronymcoders.base.savesystem.SaveLoader;
import com.teamacronymcoders.base.subblocksystem.blocks.BlockSubBlockHolder;
import com.teamacronymcoders.base.subblocksystem.blocks.ISubBlock;
import com.teamacronymcoders.base.subblocksystem.blocks.MissingSubBlock;
import com.teamacronymcoders.base.subblocksystem.blocks.SubBlockInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SubBlockSystem {
    private IBaseMod mod;
    private Map<String, ISubBlock> subBlocks = Maps.newHashMap();
    public static final ISubBlock MISSING_SUB_BLOCK = new MissingSubBlock();

    public SubBlockSystem(IBaseMod mod) {
        this.mod = mod;
    }

    public void registerSubBlock(ISubBlock iSubBlock) {
        this.subBlocks.put(iSubBlock.getName(), iSubBlock);
    }

    public void createBlocks() {
        SubBlockInfo subBlockInfo = SaveLoader.getSavedObject("saved_sub_blocks_" + this.mod.getID(), SubBlockInfo.class);
        Map<Integer, Map<Integer, String>> listOfBlockNames = subBlockInfo.getSavedSubBlockNames();
        HashMap<Integer, Map<Integer, ISubBlock>> listOfSubBlocks = new HashMap<Integer, Map<Integer, ISubBlock>>();
        if (listOfBlockNames.size() > 0) {
            for (Map.Entry<Integer, Map<Integer, String>> blockNames : listOfBlockNames.entrySet()) {
                HashMap<Integer, ISubBlock> subBlocksForBlock = new HashMap<Integer, ISubBlock>();
                for (Map.Entry<Integer, String> subBlockName : blockNames.getValue().entrySet()) {
                    ISubBlock subBlock = this.subBlocks.remove(subBlockName.getValue());
                    if (subBlock == null) {
                        this.mod.getLogger().error("Could not find sub-block: " + subBlockName.getValue());
                    }
                    subBlocksForBlock.put(subBlockName.getKey(), subBlock);
                }
                listOfSubBlocks.put(blockNames.getKey(), subBlocksForBlock);
            }
        }
        int blockToCheck = 0;
        int blockMetaToCheck = 0;
        ArrayList<ISubBlock> remainingSubBlocks = new ArrayList<ISubBlock>(this.subBlocks.values());
        while (remainingSubBlocks.size() > 0) {
            listOfSubBlocks.computeIfAbsent(blockToCheck, value -> new HashMap());
            ((Map)listOfSubBlocks.get(blockToCheck)).computeIfAbsent(blockMetaToCheck, value -> (ISubBlock)remainingSubBlocks.remove(0));
            if (++blockMetaToCheck <= 15) continue;
            blockMetaToCheck = 0;
            ++blockToCheck;
        }
        subBlockInfo.setSavedSubBlocks(listOfSubBlocks);
        SaveLoader.saveObject("saved_sub_blocks_" + this.mod.getID(), subBlockInfo);
        BlockRegistry blockRegistry = this.mod.getRegistryHolder().getRegistry(BlockRegistry.class, "BLOCK");
        listOfSubBlocks.forEach((id, subBlocks) -> blockRegistry.register(new BlockSubBlockHolder((int)id, (Map<Integer, ISubBlock>)subBlocks)));
    }
}

