/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.materialsystem.materialparts;

import com.teamacronymcoders.base.materialsystem.MaterialSystem;
import com.teamacronymcoders.base.materialsystem.materialparts.MaterialPartData;
import com.teamacronymcoders.base.materialsystem.materials.Material;
import com.teamacronymcoders.base.materialsystem.parts.Part;
import com.teamacronymcoders.base.materialsystem.parttype.PartType;
import com.teamacronymcoders.base.util.TextUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;

public class MaterialPart {
    private Material material;
    private Part part;
    private ResourceLocation textureLocation;
    private boolean colorized;
    private MaterialPartData data;
    private ItemStack itemStack;
    private MaterialSystem materialSystem;
    private String variant;

    public MaterialPart(MaterialSystem materialSystem, Material material, Part part) {
        this(materialSystem, material, part, null);
    }

    public MaterialPart(MaterialSystem materialSystem, Material material, Part part, String variant) {
        this.setMaterial(material);
        this.setPart(part);
        this.materialSystem = materialSystem;
        this.setTextureLocation(new ResourceLocation(materialSystem.getMod().getID(), part.getUnlocalizedName()));
        this.colorized = true;
        this.data = new MaterialPartData(part.getData());
        if (variant != null) {
            this.variant = TextUtils.toSnakeCase(variant);
        }
    }

    public String getUnlocalizedName() {
        return this.material.getUnlocalizedName() + "_" + this.part.getUnlocalizedName() + (this.variant != null ? "_" + this.variant : "");
    }

    public String getLocalizedName() {
        return String.format("%s %s", this.material.getName(), I18n.func_74838_a((String)("base.part." + this.part.getUnlocalizedName())));
    }

    public boolean hasEffect() {
        return this.getMaterial().isHasEffect();
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public Part getPart() {
        return this.part;
    }

    public void setPart(Part part) {
        this.part = part;
    }

    public ItemStack getItemStack() {
        if (this.itemStack == null) {
            this.itemStack = new ItemStack((Item)this.materialSystem.itemMaterialPart, 1, this.materialSystem.getMaterialPartId(this));
        }
        return this.itemStack;
    }

    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }

    public void setTextureLocation(ResourceLocation textureLocation) {
        this.textureLocation = textureLocation;
    }

    public int getColor() {
        return this.colorized ? this.getMaterial().getColor().getRGB() : -1;
    }

    public boolean isColorized() {
        return this.colorized;
    }

    public void setColorized(boolean colorized) {
        this.colorized = colorized;
    }

    public boolean matchesPartType(PartType partType) {
        return this.getPart().getPartType() == partType;
    }

    public String getOreDictString() {
        return this.getPart().getOreDictPrefix() + this.getMaterial().getOreDictSuffix();
    }

    public MaterialPartData getData() {
        return this.data;
    }

    public void setData(MaterialPartData data) {
        this.data = data;
    }

    public void setup() {
        this.getPart().getPartType().setup(this);
    }
}

