/*
 * Decompiled with CFR 0.152.
 */
package mod.baijson.baconators.items;

import java.util.List;
import javax.annotation.Nullable;
import mod.baijson.baconators.assets.Helpers;
import mod.baijson.baconators.client.TooltipUtil;
import mod.baijson.baconators.config.IOptions;
import mod.baijson.baconators.items.Registry;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.FoodStats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import squeek.applecore.api.food.FoodValues;
import squeek.applecore.api.food.IEdible;
import squeek.applecore.api.food.ItemFoodProxy;

@Optional.Interface(iface="squeek.applecore.api.food.IEdible", modid="AppleCore", striprefs=true)
public class Baconator
extends Item
implements IEdible {
    private IOptions itemOptions;

    public static Baconator create(ResourceLocation resource, IOptions options) {
        Baconator self = new Baconator(resource);
        self.register(options);
        return self;
    }

    protected Baconator(ResourceLocation resource) {
        this.setRegistryName(resource);
        this.func_77655_b(resource.func_110623_a());
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77637_a(CreativeTabs.field_78039_h);
    }

    protected void register(IOptions options) {
        if (options.getEnabled()) {
            this.itemOptions = options;
            GameRegistry.register((IForgeRegistryEntry)this);
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (!player.func_70093_af()) {
            if (this.getCurrentItemStack(stack) != null && this.getStorageItemCount(stack) > 0 && player.func_71024_bL().func_75121_c()) {
                player.func_184598_c(hand);
            }
        } else if (!world.field_72995_K) {
            this.setEnabled(stack, !this.getEnabled(stack));
            world.func_184133_a(null, player.func_180425_c(), Registry.toggleSound, SoundCategory.PLAYERS, 0.3f, (float)(0.5 + Math.random() * 0.5));
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean getEnabled(ItemStack stack) {
        if (this.getTagCompound(stack).func_74764_b("enabled")) {
            return this.getTagCompound(stack).func_74767_n("enabled");
        }
        return false;
    }

    public void setEnabled(ItemStack stack, boolean value) {
        this.getTagCompound(stack).func_74757_a("enabled", value);
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.getEnabled(stack);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.EAT;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    @Nullable
    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (this.getCurrentItemStack(stack) != null && this.getStorageItemCount(stack) > 0) {
            EntityPlayer player;
            EntityPlayer entityPlayer = player = entityLiving instanceof EntityPlayer ? (EntityPlayer)entityLiving : null;
            if (player != null) {
                FoodStats stats = player.func_71024_bL();
                ItemFood foodItem = (ItemFood)this.getCurrentItemStack(stack).func_77973_b();
                ItemStack foodStack = new ItemStack((Item)foodItem);
                if (stats.func_75121_c()) {
                    this.decStorageItemCount(stack, 1);
                    if (Loader.isModLoaded((String)"AppleCore")) {
                        this.onEatenCompatibility(foodStack, player);
                    } else {
                        player.func_71024_bL().func_151686_a(foodItem, foodStack);
                    }
                    if (stats.func_75116_a() >= 20) {
                        world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.3f, (float)(0.5 + Math.random() * 0.5));
                    }
                }
            }
        }
        return stack;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean holding) {
        if (!world.field_72995_K) {
            EntityPlayer player = (EntityPlayer)entity;
            if (player.func_70093_af() && holding) {
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack items = player.field_71071_by.func_70301_a(i);
                    if (items == null || !this.isItemStackAccepted(stack, items) || this.getCurrentItemStack(stack) != null && !this.getCurrentItemStack(stack).func_77969_a(items)) continue;
                    this.StoreItemStack(stack, items, player.field_71071_by, i);
                    return;
                }
            }
            if (player.func_71024_bL().func_75121_c() && this.getEnabled(stack) && this.getCurrentItemStack(stack) != null && this.getStorageItemCount(stack) > 0) {
                FoodStats stats = player.func_71024_bL();
                ItemFood foodItem = (ItemFood)this.getCurrentItemStack(stack).func_77973_b();
                ItemStack foodStack = new ItemStack((Item)foodItem);
                if (stats.func_75116_a() + foodItem.func_150905_g(stack) <= 20) {
                    this.decStorageItemCount(stack, 1);
                    if (Loader.isModLoaded((String)"AppleCore")) {
                        this.onEatenCompatibility(foodStack, player);
                    } else {
                        player.func_71024_bL().func_151686_a(foodItem, foodStack);
                    }
                    if (stats.func_75116_a() >= 20) {
                        world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.3f, (float)(0.5 + Math.random() * 0.5));
                    }
                    return;
                }
            }
        }
    }

    public boolean isItemStackAccepted(ItemStack stack, ItemStack compare) {
        if (compare.func_77973_b() instanceof ItemFood) {
            for (int i = 0; i < this.itemOptions.getAcceptedFood().length; ++i) {
                try {
                    ItemStack itemStack = Helpers.getItemStack(this.itemOptions.getAcceptedFood()[i]);
                    if (itemStack != null && itemStack.func_77969_a(compare) && itemStack.func_77973_b() instanceof ItemFood) {
                        return true;
                    }
                    continue;
                }
                catch (Exception e) {
                    FMLLog.log((Level)Level.WARN, (String)e.getMessage(), (Object[])new Object[0]);
                }
            }
        }
        return false;
    }

    public ItemStack getCurrentItemStack(ItemStack stack) {
        return this.getTagCompound(stack).func_74764_b("storage_item") ? ItemStack.func_77949_a((NBTTagCompound)this.getTagCompound(stack).func_74775_l("storage_item")) : null;
    }

    public void setCurrentItemStack(ItemStack stack, @Nullable ItemStack items) {
        if (items == null) {
            if (this.getTagCompound(stack).func_74764_b("storage_item")) {
                this.getTagCompound(stack).func_82580_o("storage_item");
            }
        } else {
            NBTTagCompound compound = new NBTTagCompound();
            items.func_77955_b(compound);
            this.getTagCompound(stack).func_74782_a("storage_item", (NBTBase)compound);
        }
    }

    public void StoreItemStack(ItemStack stack, ItemStack items, InventoryPlayer inventory, int slot) {
        if (this.getCurrentItemStack(stack) == null) {
            this.setCurrentItemStack(stack, items);
        }
        for (int i = 0; i < items.field_77994_a; ++i) {
            if (this.getStorageItemCount(stack) >= this.itemOptions.getMaxCapacity()) {
                return;
            }
            this.incStorageItemCount(stack, 1);
            inventory.func_70298_a(slot, 1);
        }
        inventory.func_70296_d();
    }

    public int incStorageItemCount(ItemStack stack, int value) {
        this.getTagCompound(stack).func_74768_a("storage_num", this.getStorageItemCount(stack) + value);
        return this.getStorageItemCount(stack);
    }

    public int decStorageItemCount(ItemStack stack, int value) {
        if (this.getStorageItemCount(stack) - value > 0) {
            this.getTagCompound(stack).func_74768_a("storage_num", this.getStorageItemCount(stack) - value);
        } else {
            this.getTagCompound(stack).func_74768_a("storage_num", 0);
            this.setCurrentItemStack(stack, null);
        }
        return this.getStorageItemCount(stack);
    }

    public int getStorageItemCount(ItemStack stack) {
        if (this.getTagCompound(stack).func_74764_b("storage_num")) {
            return this.getTagCompound(stack).func_74762_e("storage_num");
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        TooltipUtil.construct(tooltip, () -> {
            TooltipUtil.insert(tooltip, I18n.func_135052_a((String)"item.tooltip.enabled", (Object[])new Object[]{I18n.func_135052_a((String)("item.tooltip.checked." + (this.getEnabled(stack) ? "1" : "0")), (Object[])new Object[0])}));
            String _current = String.format("&8[&r%s/%s&8]&r", this.getStorageItemCount(stack), this.itemOptions.getMaxCapacity());
            TooltipUtil.insert(tooltip, I18n.func_135052_a((String)"item.tooltip.holding", (Object[])new Object[]{this.getCurrentItemStack(stack) != null ? this.getCurrentItemStack(stack).func_82833_r() + " " + _current : I18n.func_135052_a((String)"item.tooltip.nothing", (Object[])new Object[0])}));
            if (this.itemOptions.getTooltipsEnabled()) {
                TooltipUtil.insert(tooltip, "");
                TooltipUtil.insert(tooltip, I18n.func_135052_a((String)"item.tooltip.accepts", (Object[])new Object[0]));
                for (int i = 0; i < this.itemOptions.getAcceptedFood().length; ++i) {
                    try {
                        ItemStack foodStack = Helpers.getItemStack(this.itemOptions.getAcceptedFood()[i].toString());
                        if (foodStack == null) continue;
                        TooltipUtil.insert(tooltip, String.format("%s %s", I18n.func_135052_a((String)"item.tooltip.bullets", (Object[])new Object[0]), foodStack.func_82833_r()));
                        continue;
                    }
                    catch (Exception e) {
                        FMLLog.log((Level)Level.WARN, (String)e.getMessage(), (Object[])new Object[0]);
                    }
                }
            }
        });
    }

    public IOptions getOptions() {
        return this.itemOptions;
    }

    public NBTTagCompound getTagCompound(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    @Optional.Method(modid="AppleCore")
    public FoodValues getFoodValues(ItemStack stack) {
        if (this.getStorageItemCount(stack) > 0 && this.getCurrentItemStack(stack) != null) {
            ItemFood foodItem = (ItemFood)this.getCurrentItemStack(stack).func_77973_b();
            if (foodItem != null) {
                return new FoodValues(foodItem.func_150905_g(stack), foodItem.func_150906_h(stack));
            }
            return new FoodValues(0, 0.0f);
        }
        return new FoodValues(0, 0.0f);
    }

    @Optional.Method(modid="AppleCore")
    public void onEatenCompatibility(ItemStack itemStack, EntityPlayer player) {
        player.func_71024_bL().func_151686_a((ItemFood)new ItemFoodProxy((IEdible)this), itemStack);
    }
}

