/*
 * Decompiled with CFR 0.152.
 */
package apple_shields.shieldtypes;

import apple_shields.AppleShields;
import apple_shields.items.ItemAppleShield;
import apple_shields.packets.ShieldDestroyMessage;
import apple_shields.shieldtypes.ShieldTypeBasic;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ShieldTypeFeeding
extends ShieldTypeBasic {
    private int hunger;
    private float saturation;
    private int feedTime;
    private int durabilityPerHunger;

    public ShieldTypeFeeding(ItemStack shieldItem, ItemStack repairItem, SoundEvent hitSound, SoundEvent breakSound, int durability, int hunger, float saturation, int feedTime, int durabilityPerHunger) {
        super(shieldItem, repairItem, hitSound, breakSound, durability);
        this.hunger = hunger;
        this.saturation = saturation;
        this.feedTime = feedTime;
        this.durabilityPerHunger = durabilityPerHunger;
    }

    @Override
    public void addInformation(ItemAppleShield shield, ItemStack stack, EntityPlayer player, List<String> information, boolean advanced) {
        super.addInformation(shield, stack, player, information, advanced);
        if (player.func_70005_c_().equals("Darkosto")) {
            TextComponentString line1 = new TextComponentString("Happy Darkosto Appreciation Day!");
            TextComponentString line2 = new TextComponentString("Stay, have some food!");
            line2.func_150255_a(line1.func_150256_b().func_150238_a(TextFormatting.GREEN));
            information.add("");
            information.add(line1.func_150254_d());
            information.add(line2.func_150254_d());
        }
    }

    @Override
    public void onUpdate(ItemAppleShield shield, ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        super.onUpdate(shield, stack, world, entity, slot, selected);
        if (world.func_82737_E() % (long)this.feedTime == 0L && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            int foodLevel = -player.func_71024_bL().func_75116_a();
            float saturationLevel = -player.func_71024_bL().func_75115_e();
            player.func_71024_bL().func_75122_a(this.hunger, this.saturation);
            if (!((foodLevel += player.func_71024_bL().func_75116_a()) == 0 && (saturationLevel += player.func_71024_bL().func_75115_e()) == 0.0f || foodLevel == 0 && saturationLevel == 0.0f)) {
                shield.damageShield(foodLevel * this.durabilityPerHunger, stack, (EntityLivingBase)player);
                if (stack.field_77994_a <= 0) {
                    EnumHand hand = null;
                    if (player.func_184586_b(EnumHand.MAIN_HAND) == stack) {
                        hand = EnumHand.MAIN_HAND;
                    } else if (player.func_184586_b(EnumHand.OFF_HAND) == stack) {
                        hand = EnumHand.OFF_HAND;
                    }
                    if (player instanceof EntityPlayerMP) {
                        AppleShields.NETWORK_WRAPPER.sendTo((IMessage)new ShieldDestroyMessage(stack), (EntityPlayerMP)player);
                    }
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)stack, (EnumHand)hand);
                    player.field_71071_by.func_70299_a(slot, null);
                }
            }
        }
    }
}

