/*
 * Decompiled with CFR 0.152.
 */
package apple_shields.items;

import apple_shields.AppleShields;
import apple_shields.shieldtypes.IShieldType;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAppleShield
extends ItemShield {
    private IShieldType shieldType;

    public ItemAppleShield() {
        this.func_185043_a(new ResourceLocation("blocking"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return stack.func_77973_b().func_77661_b(stack) == EnumAction.BLOCK && entity != null && entity.func_184587_cr() && entity.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public void register(String unlocalizedName) {
        this.func_77655_b("apple_shields." + unlocalizedName);
        GameRegistry.register((IForgeRegistryEntry)this, (ResourceLocation)new ResourceLocation("apple_shields", unlocalizedName));
    }

    public IShieldType getShieldType() {
        return this.shieldType;
    }

    public void setShieldType(IShieldType shieldType) {
        this.shieldType = shieldType;
        this.func_77656_e(shieldType.getDurability());
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelResourceLocation shield = new ModelResourceLocation("minecraft:shield", "inventory");
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> shield);
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{shield});
    }

    public CreativeTabs func_77640_w() {
        return AppleShields.creativeTab;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (this.func_77661_b(stack) == EnumAction.BLOCK) {
            return super.func_77659_a(stack, world, player, hand);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public String func_77653_i(ItemStack stack) {
        return ("" + I18n.func_74838_a((String)(this.func_77657_g(stack) + ".name"))).trim();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> information, boolean advanced) {
        this.shieldType.addInformation(this, stack, player, information, advanced);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        this.shieldType.onUpdate(this, stack, world, entity, slot, selected);
    }

    public boolean isRepairable() {
        return this.shieldType.getRepairItem() != null;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair != null && ItemStack.func_179545_c((ItemStack)repair, (ItemStack)this.shieldType.getRepairItem());
    }

    public boolean damageShield(int toDamage, ItemStack stack, EntityLivingBase entity) {
        int damage = stack.func_77952_i() + toDamage;
        if (damage >= this.getMaxDamage(stack)) {
            --stack.field_77994_a;
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                player.func_71029_a(StatList.func_188059_c((Item)stack.func_77973_b()));
            }
            if (stack.field_77994_a < 0) {
                stack.field_77994_a = 0;
            }
        } else {
            stack.func_77964_b(damage);
        }
        return true;
    }

    public boolean repairShield(int toRepair, ItemStack stack) {
        if (stack.func_77952_i() > 0) {
            stack.func_77964_b(Math.max(0, stack.func_77952_i() - toRepair));
            return true;
        }
        return false;
    }
}

