/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.common.registry.PersistentRegistryManager;

public class RegistryBuilder<T extends IForgeRegistryEntry<T>> {
    private kn registryName;
    private Class<T> registryType;
    private kn optionalDefaultKey;
    private int minId;
    private int maxId;
    private List<IForgeRegistry.AddCallback<T>> addCallback = Lists.newArrayList();
    private List<IForgeRegistry.ClearCallback<T>> clearCallback = Lists.newArrayList();
    private List<IForgeRegistry.CreateCallback<T>> createCallback = Lists.newArrayList();
    private List<IForgeRegistry.SubstitutionCallback<T>> substitutionCallback = Lists.newArrayList();

    public RegistryBuilder<T> setName(kn name) {
        this.registryName = name;
        return this;
    }

    public RegistryBuilder<T> setType(Class<T> type) {
        this.registryType = type;
        return this;
    }

    public RegistryBuilder<T> setIDRange(int min, int max) {
        this.minId = min;
        this.maxId = max;
        return this;
    }

    public RegistryBuilder<T> addCallback(Object inst) {
        if (inst instanceof IForgeRegistry.AddCallback) {
            this.add((IForgeRegistry.AddCallback)inst);
        }
        if (inst instanceof IForgeRegistry.ClearCallback) {
            this.add((IForgeRegistry.ClearCallback)inst);
        }
        if (inst instanceof IForgeRegistry.CreateCallback) {
            this.add((IForgeRegistry.CreateCallback)inst);
        }
        if (inst instanceof IForgeRegistry.SubstitutionCallback) {
            this.add((IForgeRegistry.SubstitutionCallback)inst);
        }
        return this;
    }

    public RegistryBuilder<T> add(IForgeRegistry.AddCallback<T> add) {
        this.addCallback.add(add);
        return this;
    }

    public RegistryBuilder<T> add(IForgeRegistry.ClearCallback<T> clear) {
        this.clearCallback.add(clear);
        return this;
    }

    public RegistryBuilder<T> add(IForgeRegistry.CreateCallback<T> create) {
        this.createCallback.add(create);
        return this;
    }

    public RegistryBuilder<T> add(IForgeRegistry.SubstitutionCallback<T> sub) {
        this.substitutionCallback.add(sub);
        return this;
    }

    public IForgeRegistry<T> create() {
        return PersistentRegistryManager.createRegistry(this.registryName, this.registryType, this.optionalDefaultKey, this.minId, this.maxId, false, this.getAdd(), this.getClear(), this.getCreate(), this.getSubstitution());
    }

    private IForgeRegistry.AddCallback<T> getAdd() {
        if (this.addCallback.isEmpty()) {
            return null;
        }
        if (this.addCallback.size() == 1) {
            return this.addCallback.get(0);
        }
        return new IForgeRegistry.AddCallback<T>(){

            @Override
            public void onAdd(T obj, int id, Map<kn, ?> slaveset) {
                for (IForgeRegistry.AddCallback cb : RegistryBuilder.this.addCallback) {
                    cb.onAdd(obj, id, slaveset);
                }
            }
        };
    }

    private IForgeRegistry.ClearCallback<T> getClear() {
        if (this.clearCallback.isEmpty()) {
            return null;
        }
        if (this.clearCallback.size() == 1) {
            return this.clearCallback.get(0);
        }
        return new IForgeRegistry.ClearCallback<T>(){

            @Override
            public void onClear(IForgeRegistry<T> is, Map<kn, ?> slaveset) {
                for (IForgeRegistry.ClearCallback cb : RegistryBuilder.this.clearCallback) {
                    cb.onClear(is, slaveset);
                }
            }
        };
    }

    private IForgeRegistry.CreateCallback<T> getCreate() {
        if (this.createCallback.isEmpty()) {
            return null;
        }
        if (this.createCallback.size() == 1) {
            return this.createCallback.get(0);
        }
        return new IForgeRegistry.CreateCallback<T>(){

            @Override
            public void onCreate(Map<kn, ?> slaveset, BiMap<kn, ? extends IForgeRegistry<?>> registries) {
                for (IForgeRegistry.CreateCallback cb : RegistryBuilder.this.createCallback) {
                    cb.onCreate(slaveset, registries);
                }
            }
        };
    }

    private IForgeRegistry.SubstitutionCallback<T> getSubstitution() {
        if (this.substitutionCallback.isEmpty()) {
            return null;
        }
        if (this.substitutionCallback.size() == 1) {
            return this.substitutionCallback.get(0);
        }
        return new IForgeRegistry.SubstitutionCallback<T>(){

            @Override
            public void onSubstituteActivated(Map<kn, ?> slaveset, T original, T replacement, kn name) {
                for (IForgeRegistry.SubstitutionCallback cb : RegistryBuilder.this.substitutionCallback) {
                    cb.onSubstituteActivated(slaveset, original, replacement, name);
                }
            }
        };
    }
}

