/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.operator.vector;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.RayTraceResult;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceOperator;

public class PieceOperatorVectorRaycastAxis
extends PieceOperator {
    SpellParam origin;
    SpellParam ray;
    SpellParam max;

    public PieceOperatorVectorRaycastAxis(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.origin = new ParamVector("psi.spellparam.position", 2774482, false, false);
        this.addParam(this.origin);
        this.ray = new ParamVector("psi.spellparam.ray", 4117034, false, false);
        this.addParam(this.ray);
        this.max = new ParamNumber("psi.spellparam.max", 7678674, true, false);
        this.addParam(this.max);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 originVal = (Vector3)this.getParamValue(context, this.origin);
        Vector3 rayVal = (Vector3)this.getParamValue(context, this.ray);
        if (originVal == null || rayVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        double maxLen = 32.0;
        Double numberVal = (Double)this.getParamValue(context, this.max);
        if (numberVal != null) {
            maxLen = numberVal;
        }
        maxLen = Math.min(32.0, maxLen);
        Vector3 end = originVal.copy().add(rayVal.copy().normalize().multiply(maxLen));
        RayTraceResult pos = context.caster.field_70170_p.func_72933_a(originVal.toVec3D(), end.toVec3D());
        if (pos == null || pos.func_178782_a() == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        EnumFacing facing = pos.field_178784_b;
        return new Vector3(facing.func_82601_c(), facing.func_96559_d(), facing.func_82599_e());
    }

    @Override
    public Class<?> getEvaluationType() {
        return Vector3.class;
    }
}

