/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.item.ItemMod;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.spell.ISpellContainer;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.entity.EntitySpellCharge;
import vazkii.psi.common.entity.EntitySpellCircle;
import vazkii.psi.common.entity.EntitySpellGrenade;
import vazkii.psi.common.entity.EntitySpellMine;
import vazkii.psi.common.entity.EntitySpellProjectile;
import vazkii.psi.common.item.ItemSpellDrive;
import vazkii.psi.common.item.base.IPsiItem;
import vazkii.psi.common.spell.operator.vector.PieceOperatorVectorRaycast;

public class ItemSpellBullet
extends ItemMod
implements ISpellContainer,
IPsiItem {
    private static final String TAG_SPELL = "spell";
    public static final String[] VARIANTS = new String[]{"spellBullet", "spellBulletActive", "spellBulletProjectile", "spellBulletProjectileActive", "spellBulletLoop", "spellBulletLoopActive", "spellBulletCircle", "spellBulletCircleActive", "spellBulletGrenade", "spellBulletGrenadeActive", "spellBulletCharge", "spellBulletChargeActive", "spellBulletMine", "spellBulletMineActive"};

    public ItemSpellBullet() {
        super("spellBullet", VARIANTS);
        this.func_77625_d(1);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return this.getSpell(stack) != null;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        return itemStack.func_77946_l();
    }

    public String func_77653_i(ItemStack stack) {
        if (!this.containsSpell(stack)) {
            return super.func_77653_i(stack);
        }
        NBTTagCompound cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)TAG_SPELL, (boolean)false);
        String name = cmp.func_74779_i("spellName");
        if (name == null || name.isEmpty()) {
            return super.func_77653_i(stack);
        }
        return name;
    }

    @Override
    public void setSpell(EntityPlayer player, ItemStack stack, Spell spell) {
        ItemSpellDrive.setSpell(stack, spell);
        if (!this.containsSpell(stack)) {
            stack.func_77964_b(stack.func_77952_i() + 1);
        }
    }

    @Override
    public Spell getSpell(ItemStack stack) {
        return ItemSpellDrive.getSpell(stack);
    }

    @Override
    public boolean containsSpell(ItemStack stack) {
        return stack.func_77952_i() % 2 == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return this.containsSpell(stack) ? EnumRarity.RARE : EnumRarity.COMMON;
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (int i = 0; i < this.getVariants().length; ++i) {
            if (i % 2 != 0) continue;
            subItems.add(new ItemStack(itemIn, 1, i));
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        ItemSpellBullet.tooltipIfShift(tooltip, () -> {
            ItemSpellBullet.addToTooltip((List)tooltip, (String)"psimisc.bulletType", (Object[])new Object[]{ItemSpellBullet.local((String)("psi.bulletType" + stack.func_77952_i() / 2))});
            ItemSpellBullet.addToTooltip((List)tooltip, (String)"psimisc.bulletCost", (Object[])new Object[]{(int)(this.getCostModifier(stack) * 100.0)});
        });
    }

    @Override
    public void castSpell(ItemStack stack, SpellContext context) {
        switch (stack.func_77952_i()) {
            case 1: {
                context.cspell.safeExecute(context);
                break;
            }
            case 3: {
                if (context.caster.field_70170_p.field_72995_K) break;
                EntitySpellProjectile proj = new EntitySpellProjectile(context.caster.field_70170_p, (EntityLivingBase)context.caster);
                ItemStack cad = PsiAPI.getPlayerCAD(context.caster);
                ItemStack colorizer = ((ICAD)cad.func_77973_b()).getComponentInSlot(cad, EnumCADComponent.DYE);
                proj.setInfo(context.caster, colorizer, stack);
                proj.context = context;
                proj.field_70170_p.func_72838_d((Entity)proj);
                break;
            }
            case 5: {
                if (PlayerDataHandler.get((EntityPlayer)context.caster).loopcasting) break;
                context.cspell.safeExecute(context);
                PlayerDataHandler.get((EntityPlayer)context.caster).loopcasting = true;
                break;
            }
            case 7: {
                if (context.caster.field_70170_p.field_72995_K) break;
                try {
                    RayTraceResult pos = PieceOperatorVectorRaycast.raycast((Entity)context.caster, 32.0);
                    if (pos == null) break;
                    EntitySpellCircle circle = new EntitySpellCircle(context.caster.field_70170_p);
                    ItemStack cad = PsiAPI.getPlayerCAD(context.caster);
                    ItemStack colorizer = ((ICAD)cad.func_77973_b()).getComponentInSlot(cad, EnumCADComponent.DYE);
                    circle.setInfo(context.caster, colorizer, stack);
                    circle.func_70107_b(pos.field_72307_f.field_72450_a, pos.field_72307_f.field_72448_b, pos.field_72307_f.field_72449_c);
                    circle.field_70170_p.func_72838_d((Entity)circle);
                }
                catch (SpellRuntimeException pos) {}
                break;
            }
            case 9: {
                if (context.caster.field_70170_p.field_72995_K) break;
                EntitySpellGrenade proj = new EntitySpellGrenade(context.caster.field_70170_p, (EntityLivingBase)context.caster);
                ItemStack cad = PsiAPI.getPlayerCAD(context.caster);
                ItemStack colorizer = ((ICAD)cad.func_77973_b()).getComponentInSlot(cad, EnumCADComponent.DYE);
                proj.setInfo(context.caster, colorizer, stack);
                proj.context = context;
                proj.field_70170_p.func_72838_d((Entity)proj);
                break;
            }
            case 11: {
                if (context.caster.field_70170_p.field_72995_K) break;
                EntitySpellCharge proj = new EntitySpellCharge(context.caster.field_70170_p, (EntityLivingBase)context.caster);
                ItemStack cad = PsiAPI.getPlayerCAD(context.caster);
                ItemStack colorizer = ((ICAD)cad.func_77973_b()).getComponentInSlot(cad, EnumCADComponent.DYE);
                proj.setInfo(context.caster, colorizer, stack);
                proj.context = context;
                proj.field_70170_p.func_72838_d((Entity)proj);
                break;
            }
            case 13: {
                if (context.caster.field_70170_p.field_72995_K) break;
                EntitySpellMine proj = new EntitySpellMine(context.caster.field_70170_p, (EntityLivingBase)context.caster);
                ItemStack cad = PsiAPI.getPlayerCAD(context.caster);
                ItemStack colorizer = ((ICAD)cad.func_77973_b()).getComponentInSlot(cad, EnumCADComponent.DYE);
                proj.setInfo(context.caster, colorizer, stack);
                proj.context = context;
                proj.field_70170_p.func_72838_d((Entity)proj);
            }
        }
    }

    @Override
    public double getCostModifier(ItemStack stack) {
        switch (stack.func_77952_i()) {
            case 0: 
            case 1: {
                return 1.0;
            }
            case 2: 
            case 3: {
                return 1.02;
            }
            case 4: 
            case 5: {
                return 1.0;
            }
            case 6: 
            case 7: {
                return 15.0;
            }
            case 8: 
            case 9: {
                return 1.05;
            }
            case 10: 
            case 11: {
                return 1.151;
            }
            case 12: 
            case 13: {
                return 1.151;
            }
        }
        return 0.0;
    }

    @Override
    public boolean isCADOnlyContainer(ItemStack stack) {
        return ImmutableSet.of((Object)4, (Object)5, (Object)6, (Object)7).contains((Object)stack.func_77952_i());
    }

    @Override
    public boolean requiresSneakForSpellSet(ItemStack stack) {
        return false;
    }
}

