/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.spell;

import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.psi.api.spell.SpellGrid;

public final class Spell {
    private static final String TAG_VALID = "validSpell";
    public static final String TAG_SPELL_NAME = "spellName";
    public static final String TAG_UUID_MOST = "uuidMost";
    public static final String TAG_UUID_LEAST = "uuidLeast";
    public SpellGrid grid = new SpellGrid(this);
    public String name = "";
    public UUID uuid = UUID.randomUUID();

    @SideOnly(value=Side.CLIENT)
    public void draw() {
        this.grid.draw();
    }

    public static Spell createFromNBT(NBTTagCompound cmp) {
        if (!cmp.func_74767_n(TAG_VALID)) {
            return null;
        }
        Spell spell = new Spell();
        spell.readFromNBT(cmp);
        return spell;
    }

    public void readFromNBT(NBTTagCompound cmp) {
        this.name = cmp.func_74779_i(TAG_SPELL_NAME);
        if (cmp.func_74764_b(TAG_UUID_MOST)) {
            long uuidMost = cmp.func_74763_f(TAG_UUID_MOST);
            long uuidLeast = cmp.func_74763_f(TAG_UUID_LEAST);
            if (this.uuid.getMostSignificantBits() != uuidMost || this.uuid.getLeastSignificantBits() != uuidLeast) {
                this.uuid = new UUID(uuidMost, uuidLeast);
            }
        }
        this.grid.readFromNBT(cmp);
    }

    public void writeToNBT(NBTTagCompound cmp) {
        cmp.func_74757_a(TAG_VALID, true);
        cmp.func_74778_a(TAG_SPELL_NAME, this.name);
        cmp.func_74772_a(TAG_UUID_MOST, this.uuid.getMostSignificantBits());
        cmp.func_74772_a(TAG_UUID_LEAST, this.uuid.getLeastSignificantBits());
        this.grid.writeToNBT(cmp);
    }

    public Spell copy() {
        NBTTagCompound cmp = new NBTTagCompound();
        this.writeToNBT(cmp);
        return Spell.createFromNBT(cmp);
    }
}

