/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.helper;

import com.phylogeny.extrabitmanipulation.api.ChiselsAndBitsAPIAccess;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.reference.Configs;
import com.phylogeny.extrabitmanipulation.shape.Shape;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.IBitBag;
import mod.chiselsandbits.api.IBitBrush;
import mod.chiselsandbits.api.IChiselAndBitsAPI;
import mod.chiselsandbits.api.ItemType;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class BitInventoryHelper {
    public static Map<Integer, Integer> getInventoryBitCounts(IChiselAndBitsAPI api, EntityPlayer player) {
        HashMap<Integer, Integer> bitCounts = new HashMap<Integer, Integer>();
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!BitInventoryHelper.isBitStack(api, stack)) continue;
            try {
                int bitStateID = api.createBrush(stack).getStateID();
                if (bitCounts.containsKey(bitStateID)) continue;
                bitCounts.put(bitStateID, BitInventoryHelper.countInventoryBits(api, player, stack));
                continue;
            }
            catch (APIExceptions.InvalidBitItem invalidBitItem) {
                // empty catch block
            }
        }
        return BitInventoryHelper.getSortedLinkedHashMap(bitCounts, new Comparator<Object>(){

            @Override
            public int compare(Object object1, Object object2) {
                return ((Comparable)((Map.Entry)object2).getValue()).compareTo(((Map.Entry)object1).getValue());
            }
        });
    }

    public static LinkedHashMap getSortedLinkedHashMap(Map bitCounts, Comparator<Object> comparator) {
        LinkedList bitCountsList = new LinkedList(bitCounts.entrySet());
        Collections.sort(bitCountsList, comparator);
        LinkedHashMap bitCountsSorted = new LinkedHashMap();
        for (Map.Entry entry : bitCountsList) {
            bitCountsSorted.put(entry.getKey(), entry.getValue());
        }
        return bitCountsSorted;
    }

    public static int countInventoryBits(IChiselAndBitsAPI api, EntityPlayer player, ItemStack setBitStack) {
        int count = 0;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null) continue;
            count += BitInventoryHelper.getBitCountFromStack(api, setBitStack, stack);
            if (api.getItemType(stack) != ItemType.BIT_BAG) continue;
            IBitBag bitBag = api.getBitbag(stack);
            for (int j = 0; j < bitBag.getSlots(); ++j) {
                ItemStack bagStack = bitBag.getStackInSlot(j);
                count += BitInventoryHelper.getBitCountFromStack(api, setBitStack, bagStack);
            }
        }
        return count;
    }

    public static int countInventoryBlocks(EntityPlayer player, Block block) {
        int count = 0;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof ItemBlock) || ((ItemBlock)stack.func_77973_b()).field_150939_a != block) continue;
            count += stack.field_77994_a;
        }
        return count;
    }

    private static int getBitCountFromStack(IChiselAndBitsAPI api, ItemStack setBitStack, ItemStack stack) {
        return BitInventoryHelper.areBitStacksEqual(api, setBitStack, stack) ? stack.field_77994_a : 0;
    }

    private static boolean areBitStacksEqual(IChiselAndBitsAPI api, ItemStack bitStack, ItemStack putativeBitStack) {
        return BitInventoryHelper.isBitStack(api, putativeBitStack) && ItemStack.func_77970_a((ItemStack)putativeBitStack, (ItemStack)bitStack);
    }

    public static boolean isBitStack(IChiselAndBitsAPI api, ItemStack putativeBitStack) {
        return putativeBitStack != null && api.getItemType(putativeBitStack) == ItemType.CHISLED_BIT;
    }

    public static void removeBitsFromBlocks(IChiselAndBitsAPI api, EntityPlayer player, ItemStack bitStack, Block block, int quota) {
        if (quota <= 0) {
            return;
        }
        InventoryPlayer inventoy = player.field_71071_by;
        for (int i = 0; i < inventoy.func_70302_i_(); ++i) {
            Block block2;
            ItemStack stack = inventoy.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof ItemBlock) || (block2 = ((ItemBlock)stack.func_77973_b()).field_150939_a) != block) continue;
            int count = stack.field_77994_a;
            for (int j = 0; j < count; ++j) {
                if (quota >= 4096) {
                    --stack.field_77994_a;
                } else {
                    --stack.field_77994_a;
                    break;
                }
                if ((quota -= 4096) <= 0) break;
            }
            if (quota > 0 && quota < 4096) {
                Vec3d spawnPos = new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                quota = 4096 - quota;
                int stakCount = (int)Math.ceil((double)quota / 64.0);
                for (int j = 0; j < stakCount; ++j) {
                    ItemStack stack2 = bitStack.func_77946_l();
                    stack2.field_77994_a = Math.min(64, quota);
                    quota -= stack2.field_77994_a;
                    api.giveBitToPlayer(player, stack2, spawnPos);
                }
            }
            if (quota <= 0) break;
        }
    }

    public static int removeOrAddInventoryBits(IChiselAndBitsAPI api, EntityPlayer player, ItemStack setBitStack, int quota, boolean addBits) {
        if (quota <= 0) {
            return quota;
        }
        InventoryPlayer inventoy = player.field_71071_by;
        for (int i = 0; i < inventoy.func_70302_i_(); ++i) {
            ItemStack stack = inventoy.func_70301_a(i);
            if (!addBits) {
                quota = BitInventoryHelper.removeBitsFromStack(api, setBitStack, quota, inventoy, null, i, stack);
            }
            if (api.getItemType(stack) == ItemType.BIT_BAG) {
                IBitBag bitBag = api.getBitbag(stack);
                for (int j = 0; j < bitBag.getSlots(); ++j) {
                    ItemStack bagStack = bitBag.getStackInSlot(j);
                    int n = quota = addBits ? BitInventoryHelper.addBitsToBag(quota, bitBag, j, setBitStack) : BitInventoryHelper.removeBitsFromStack(api, setBitStack, quota, null, bitBag, j, bagStack);
                    if (quota <= 0) break;
                }
            }
            if (quota <= 0) break;
        }
        return quota;
    }

    private static int addBitsToBag(int quota, IBitBag bitBag, int index, ItemStack stack) {
        if (stack != null) {
            int size = stack.field_77994_a;
            ItemStack remainingStack = bitBag.insertItem(index, stack, false);
            int reduction = size - (remainingStack != null ? remainingStack.field_77994_a : 0);
            quota -= reduction;
            stack.field_77994_a -= reduction;
        }
        return quota;
    }

    private static int removeBitsFromStack(IChiselAndBitsAPI api, ItemStack setBitStack, int quota, InventoryPlayer inventoy, IBitBag bitBag, int index, ItemStack stack) {
        if (BitInventoryHelper.areBitStacksEqual(api, setBitStack, stack)) {
            int size = stack.field_77994_a;
            if (size > quota) {
                if (bitBag != null) {
                    bitBag.extractItem(index, quota, false);
                } else {
                    stack.field_77994_a = size - quota;
                }
                quota = 0;
            } else {
                if (bitBag != null) {
                    bitBag.extractItem(index, size, false);
                } else if (inventoy != null) {
                    inventoy.func_70299_a(index, null);
                }
                quota -= size;
            }
        }
        return quota;
    }

    public static void giveOrDropStacks(EntityPlayer player, World world, BlockPos pos, Shape shape, IChiselAndBitsAPI api, Map<IBlockState, Integer> bitTypes) {
        if (bitTypes != null) {
            Set<IBlockState> keySet = bitTypes.keySet();
            for (IBlockState state : keySet) {
                IBitBrush bit;
                ItemStack bitStack;
                try {
                    bitStack = api.getBitItem(state);
                }
                catch (APIExceptions.InvalidBitItem e) {
                    continue;
                }
                if (bitStack.func_77973_b() == null) continue;
                try {
                    bit = api.createBrush(bitStack);
                }
                catch (APIExceptions.InvalidBitItem e) {
                    continue;
                }
                int totalBits = bitTypes.get(state);
                if (Configs.dropBitsAsFullChiseledBlocks && totalBits >= 4096) {
                    IBitAccess bitAccess = api.createBitItem(null);
                    BitInventoryHelper.setAllBits(bitAccess, bit);
                    int blockCount = totalBits / 4096;
                    totalBits -= blockCount * 4096;
                    while (blockCount > 0) {
                        int stackSize = blockCount > 64 ? 64 : blockCount;
                        ItemStack stack2 = bitAccess.getBitsAsItem(null, ItemType.CHISLED_BLOCK, false);
                        if (stack2 != null) {
                            stack2.field_77994_a = stackSize;
                            BitInventoryHelper.givePlayerStackOrDropOnGround(player, world, api, pos, shape, stack2);
                        }
                        blockCount -= stackSize;
                    }
                }
                while (totalBits > 0) {
                    int quota = totalBits > 64 ? 64 : totalBits;
                    ItemStack bitStack2 = bit.getItemStack(quota);
                    BitInventoryHelper.givePlayerStackOrDropOnGround(player, world, api, pos, shape, bitStack2);
                    totalBits -= quota;
                }
            }
            bitTypes.clear();
            if (Configs.placeBitsInInventory) {
                player.field_71069_bz.func_75142_b();
            }
        }
    }

    private static void givePlayerStackOrDropOnGround(EntityPlayer player, World world, IChiselAndBitsAPI api, BlockPos pos, Shape shape, ItemStack stack) {
        if (Configs.placeBitsInInventory) {
            BitInventoryHelper.removeOrAddInventoryBits(api, player, stack, stack.field_77994_a, true);
            if (stack.field_77994_a > 0) {
                player.field_71071_by.func_70441_a(stack);
            }
        }
        if (stack.field_77994_a > 0) {
            if (Configs.dropBitsInBlockspace) {
                BitInventoryHelper.spawnStacksInShape(world, pos, shape, stack);
            } else {
                player.func_146097_a(stack, false, false);
            }
        }
    }

    private static void spawnStacksInShape(World world, BlockPos pos, Shape shape, ItemStack stack) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && !world.restoringBlockSnapshots) {
            Vec3d spawnPoint = shape.getRandomInternalPoint(world, pos);
            EntityItem entityitem = new EntityItem(world, spawnPoint.field_72450_a, spawnPoint.field_72448_b - 0.25, spawnPoint.field_72449_c, stack);
            entityitem.func_174869_p();
            world.func_72838_d((Entity)entityitem);
        }
    }

    private static void setAllBits(IBitAccess bitAccess, IBitBrush bit) {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    try {
                        bitAccess.setBitAt(i, j, k, bit);
                        continue;
                    }
                    catch (APIExceptions.SpaceOccupied spaceOccupied) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static void setHeldDesignStack(EntityPlayer player, ItemStack stackChiseledBlock) {
        ItemStack stack = player.func_184614_ca();
        ItemType itemType = ChiselsAndBitsAPIAccess.apiInstance.getItemType(stack);
        if (itemType == null || !ItemStackHelper.isDesignItemType(itemType)) {
            return;
        }
        IBitAccess bitAccess = ChiselsAndBitsAPIAccess.apiInstance.createBitItem(stackChiseledBlock);
        if (bitAccess != null) {
            ItemStack stackDesign = bitAccess.getBitsAsItem(EnumFacing.func_82600_a((int)ItemStackHelper.getNBTOrNew(stack).func_74762_e("side")), itemType, false);
            if (stackDesign == null) {
                stackDesign = new ItemStack(Item.func_111206_d((String)("chiselsandbits:" + (itemType == ItemType.POSITIVE_DESIGN ? "positiveprint" : (itemType == ItemType.NEGATIVE_DESIGN ? "negativeprint" : "mirrorprint")))));
            }
            if (stack != null && stack.func_77942_o()) {
                String mode = ItemStackHelper.getNBT(stack).func_74779_i("mode");
                if (!stackDesign.func_77942_o()) {
                    stackDesign.func_77982_d(new NBTTagCompound());
                }
                ItemStackHelper.getNBT(stackDesign).func_74778_a("mode", mode);
            }
            player.func_184611_a(EnumHand.MAIN_HAND, stackDesign);
        }
    }
}

