/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.client.gui.armor;

import com.phylogeny.extrabitmanipulation.ExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.armor.ArmorItem;
import com.phylogeny.extrabitmanipulation.armor.DataChiseledArmorPiece;
import com.phylogeny.extrabitmanipulation.armor.GlOperation;
import com.phylogeny.extrabitmanipulation.client.ClientHelper;
import com.phylogeny.extrabitmanipulation.client.GuiHelper;
import com.phylogeny.extrabitmanipulation.client.gui.armor.GuiListArmorItem;
import com.phylogeny.extrabitmanipulation.client.gui.armor.GuiListChiseledArmor;
import com.phylogeny.extrabitmanipulation.client.gui.armor.GuiListEntryArmorItem;
import com.phylogeny.extrabitmanipulation.client.gui.armor.GuiListEntryChiseledArmor;
import com.phylogeny.extrabitmanipulation.client.gui.armor.GuiListEntryGlOperation;
import com.phylogeny.extrabitmanipulation.client.gui.armor.GuiListGlOperation;
import com.phylogeny.extrabitmanipulation.client.gui.armor.GuiListGlOperationGlobal;
import com.phylogeny.extrabitmanipulation.client.gui.armor.GuiListGlOperationItem;
import com.phylogeny.extrabitmanipulation.client.gui.button.GuiButtonHelp;
import com.phylogeny.extrabitmanipulation.client.gui.button.GuiButtonSelect;
import com.phylogeny.extrabitmanipulation.client.gui.button.GuiButtonSelectTextured;
import com.phylogeny.extrabitmanipulation.client.gui.button.GuiButtonTab;
import com.phylogeny.extrabitmanipulation.helper.BitToolSettingsHelper;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.init.ItemsExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.item.ItemChiseledArmor;
import com.phylogeny.extrabitmanipulation.packet.PacketChangeArmorItemList;
import com.phylogeny.extrabitmanipulation.packet.PacketChangeGlOperationList;
import com.phylogeny.extrabitmanipulation.proxy.ProxyCommon;
import com.phylogeny.extrabitmanipulation.reference.Configs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiChiseledArmor
extends GuiContainer
implements GuiHelper.IHoveringTextRenderer {
    public static final ResourceLocation TEXTURE_GUI = new ResourceLocation("ExtraBitManipulation", "textures/guis/chiseled_armor.png");
    public static final int HELP_TEXT_BACKGROUNG_COLOR = 1694460416;
    private static final ResourceLocation TEXTURE_ROTATION = new ResourceLocation("ExtraBitManipulation", "textures/guis/rotation_large.png");
    private static final ResourceLocation TEXTURE_TRANSLATION = new ResourceLocation("ExtraBitManipulation", "textures/guis/translation_large.png");
    private static final ResourceLocation TEXTURE_SCALE = new ResourceLocation("ExtraBitManipulation", "textures/guis/scale_large.png");
    private static final ResourceLocation TEXTURE_ILLUMINATION_OFF = new ResourceLocation("ExtraBitManipulation", "textures/guis/full_illumination_off.png");
    private static final ResourceLocation TEXTURE_ILLUMINATION_ON = new ResourceLocation("ExtraBitManipulation", "textures/guis/full_illumination_on.png");
    private static final ResourceLocation TEXTURE_PLAYER_FOLLOW_CURSOR = new ResourceLocation("ExtraBitManipulation", "textures/guis/player_follow_cursor.png");
    private static final ResourceLocation TEXTURE_PLAYER_ROTATE = new ResourceLocation("ExtraBitManipulation", "textures/guis/player_rotate.png");
    private static final ResourceLocation TEXTURE_SCALE_PIXEL = new ResourceLocation("ExtraBitManipulation", "textures/guis/scale_pixel.png");
    private static final ResourceLocation TEXTURE_SCALE_METER = new ResourceLocation("ExtraBitManipulation", "textures/guis/scale_meter.png");
    private static final ResourceLocation TEXTURE_ADD = new ResourceLocation("ExtraBitManipulation", "textures/guis/add.png");
    private static final ResourceLocation TEXTURE_DELETE = new ResourceLocation("ExtraBitManipulation", "textures/guis/delete.png");
    private static final ResourceLocation TEXTURE_MOVE_UP = new ResourceLocation("ExtraBitManipulation", "textures/guis/move_up.png");
    private static final ResourceLocation TEXTURE_MOVE_DOWN = new ResourceLocation("ExtraBitManipulation", "textures/guis/move_down.png");
    private static final String[] GL_OPERATION_TITLES = new String[]{"Rotation", "Translation", "Scale"};
    private static final String[] GL_OPERATION_DATA_TITLES = new String[]{"X component", "Y component", "Z component", "Angle"};
    private static String glOperationHoverHelpText;
    private static String glOperationHoverKeysHelpText;
    private static final float PLAYER_HEIGHT_HALF = 37.25f;
    private static final float PLAYER_HEIGHT_EYES = 64.5f;
    private GuiListArmorItem[][] armorItemLists = new GuiListArmorItem[4][3];
    private List<GuiListGlOperation>[][] armorItemGlLists = new ArrayList[4][3];
    private GuiListGlOperation[] globalPreGlLists = new GuiListGlOperation[4];
    private GuiListGlOperation[] globalPostGlLists = new GuiListGlOperation[4];
    private DataChiseledArmorPiece[] armorPieces = new DataChiseledArmorPiece[4];
    private GuiButtonTab[][] tabButtons = new GuiButtonTab[4][4];
    private GuiListGlOperation emptyGlList;
    private GuiButtonSelectTextured buttonFullIlluminationOff;
    private GuiButtonSelectTextured buttonFullIlluminationOn;
    private GuiButtonSelectTextured buttonPlayerFollowCursor;
    private GuiButtonSelectTextured buttonPlayerRotate;
    private GuiButtonSelectTextured buttonScalePixel;
    private GuiButtonSelectTextured buttonScaleMeter;
    private GuiButtonSelectTextured buttonItemAdd;
    private GuiButtonSelectTextured buttonItemDelete;
    private GuiButtonSelectTextured buttonGlAdd;
    private GuiButtonSelectTextured buttonGlDelete;
    private GuiButtonSelectTextured buttonGlMoveUp;
    private GuiButtonSelectTextured buttonGlMoveDown;
    private GuiButtonSelectTextured buttonAddRotation;
    private GuiButtonSelectTextured buttonAddTranslation;
    private GuiButtonSelectTextured buttonAddScale;
    private GuiButtonSelect buttonGlItems;
    private GuiButtonSelect buttonGlPre;
    private GuiButtonSelect buttonGlPost;
    private GuiButtonSelect buttonScale;
    private GuiButtonHelp buttonHelp;
    private AxisAlignedBB boxPlayer;
    private AxisAlignedBB boxArmorItem;
    private AxisAlignedBB boxGlOperation;
    private AxisAlignedBB boxTitleItems;
    private AxisAlignedBB boxTitleGlOperations;
    private AxisAlignedBB[] boxesData = new AxisAlignedBB[4];
    private boolean playerBoxClicked;
    private boolean isMainArmorMode;
    private int selectedTabIndex;
    private int selectedSubTabIndex;
    private int mouseInitialX;
    private int mouseInitialY;
    private float playerScale;
    private Vec3d playerRotation;
    private Vec3d playerTranslation;
    private Vec3d playerTranslationInitial;
    private ItemStack copiedArmorItem;
    private NBTTagCompound copiedArmorItemGlOperations = new NBTTagCompound();
    private NBTTagCompound copiedGlOperation;
    private boolean waitingForServerResponse;

    public GuiChiseledArmor(EntityPlayer player, boolean openForMainArmor) {
        super((Container)ProxyCommon.createArmorContainer(player));
        this.isMainArmorMode = openForMainArmor;
        this.field_146999_f = 328;
        this.field_147000_g = 230;
        this.selectedSubTabIndex = 1;
        int index = BitToolSettingsHelper.getArmorTabIndex();
        this.selectedTabIndex = ItemStackHelper.isChiseledArmorStack(this.getArmorStack(index)) ? index : -1;
        this.resetRotationAndScale();
        this.playerTranslation = Vec3d.field_186680_a;
        this.playerTranslationInitial = Vec3d.field_186680_a;
    }

    public int getGuiLeft() {
        return this.field_147003_i;
    }

    private void resetRotationAndScale() {
        this.playerRotation = new Vec3d(30.0, -45.0, 0.0);
        this.playerScale = 1.0f;
    }

    public void refreshListsAndSelectEntry(int selectedEntry, boolean isArmorItem, boolean scrollToEnd, int glListRemovalIndex) {
        GuiListChiseledArmor list;
        GuiListChiseledArmor guiListChiseledArmor = list = isArmorItem ? this.getSelectedGuiListArmorItem() : this.getSelectedGuiListGlOperation();
        if (glListRemovalIndex >= 0 && glListRemovalIndex < this.getSelectedGuiListArmorItemGlOperations().size()) {
            this.getSelectedGuiListArmorItemGlOperations().remove(glListRemovalIndex);
        }
        if (selectedEntry >= 0) {
            list.selectListEntry(selectedEntry);
        }
        if (isArmorItem && scrollToEnd) {
            List<GuiListGlOperation> list2 = this.getSelectedGuiListArmorItemGlOperations();
            int index = this.getSelectedGuiListArmorItem().getSelectListEntryIndex();
            while (index >= list2.size()) {
                list2.add(this.createGuiListGlOperation(this.getSelectedGuiListArmorItem().armorPiece));
            }
        }
        this.refreshLists(true);
        if (scrollToEnd) {
            list.func_148145_f(Integer.MAX_VALUE);
        }
        this.waitingForServerResponse = false;
    }

    private void refreshLists(boolean onlySelected) {
        for (int i = 0; i < this.armorItemLists.length; ++i) {
            ItemStack stack = this.getArmorStack(i);
            if (ItemStackHelper.isChiseledArmorStack(stack)) {
                this.armorPieces[i].loadFromNBT(ItemStackHelper.getNBTOrNew(stack));
            }
            for (int j = 0; j < this.armorItemLists[0].length; ++j) {
                GuiListArmorItem armorItemList = this.armorItemLists[i][j];
                if (armorItemList == null) continue;
                armorItemList.refreshList();
                if (onlySelected && i != this.selectedTabIndex) continue;
                for (int k = 0; k < this.armorItemGlLists[i][j].size(); ++k) {
                    GuiListGlOperation armorItemGlList = this.armorItemGlLists[i][j].get(k);
                    if (armorItemGlList instanceof GuiListGlOperationItem) {
                        ((GuiListGlOperationItem)armorItemGlList).refreshList(k);
                        continue;
                    }
                    armorItemGlList.refreshList();
                }
            }
            if (this.armorPieces[i] == null || onlySelected && i != this.selectedTabIndex) continue;
            this.globalPreGlLists[i].refreshList();
            this.globalPostGlLists[i].refreshList();
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int left = this.field_147003_i + 213;
        int top = this.field_147009_r + 130;
        this.boxPlayer = new AxisAlignedBB((double)left, (double)top, -1.0, (double)(left + 85), (double)(top + 92), 1.0);
        left = this.field_147003_i + 91;
        top = this.field_147009_r + 36;
        this.boxGlOperation = new AxisAlignedBB((double)left, (double)top, -1.0, (double)(left + 212), (double)(top + 88), 1.0);
        left = this.field_147003_i + 37;
        top = this.field_147009_r + 24;
        this.boxArmorItem = new AxisAlignedBB((double)left, (double)top, -1.0, (double)(left + 41), (double)(top + 100), 1.0);
        left = this.field_147003_i + 39;
        top = this.field_147009_r + 9;
        this.boxTitleItems = new AxisAlignedBB((double)left, (double)top, -1.0, (double)(left + 33), (double)(top + 14), 1.0);
        left = this.field_147003_i + 92;
        this.boxTitleGlOperations = new AxisAlignedBB((double)left, (double)top, -1.0, (double)(left + 77), (double)(top + 14), 1.0);
        left = this.field_147003_i + 126;
        top = this.field_147009_r + 24;
        for (int i = 0; i < this.boxesData.length; ++i) {
            int left2 = left + i * 45;
            int width = 10;
            if (i == 3) {
                left2 -= 8;
                ++width;
            }
            this.boxesData[i] = new AxisAlignedBB((double)left2, (double)top, -1.0, (double)(left2 + width), (double)(top + 11), 1.0);
        }
        glOperationHoverKeysHelpText = "\n\nKey presses manipulate GL operations as follows:\n" + GuiChiseledArmor.getPointMain("Control + C") + " copy\n" + GuiChiseledArmor.getPointMain("Control + V") + " paste\n" + GuiChiseledArmor.getPointMain("Delete") + " delete\n" + GuiChiseledArmor.getPointMain("Up Arrow") + " move up\n" + GuiChiseledArmor.getPointMain("Down Arrow") + " move down";
        glOperationHoverHelpText = "Operations, like this, cause the items of armor piece's moving parts to either rotate (by the given angle), translate, or scale in the given axes." + glOperationHoverKeysHelpText;
        this.buttonGlItems = this.createButtonGl(100, 209, 11, "Items", "Performed for the selected item", "Each rendered item for each moving part of an armor piece can have a list of GL operations applied to it.\n\nIf this button is selected, and if the selected moving part of the selected armor piece (indicated by the tabs on the left of the GUI) have any items to render, then the area below will display the list of operations for the selected item in the area to the left.");
        this.buttonGlItems.setTextOffsetX(1.0f);
        this.buttonGlItems.selected = true;
        this.buttonGlPre = this.createButtonGlobalGl(100, 239, 11, "Before");
        this.buttonGlPost = this.createButtonGlobalGl(100, 278, 11, "After");
        int x = 301;
        String prefix = "The player model will ";
        this.buttonFullIlluminationOff = this.createButtonToggled(x, 140, TEXTURE_ILLUMINATION_OFF, "Standard illumination", prefix + "render with its faces darkened based on rotation, as it does in-world.");
        this.buttonFullIlluminationOn = this.createButtonToggled(x, 154, TEXTURE_ILLUMINATION_ON, "Full illumination", prefix + "render without darkening any of its faces.");
        String suffix1 = " can be interacted with as follows:\n" + GuiChiseledArmor.getPointMain("1") + " Translated by right-clicking and dragging.\n" + GuiChiseledArmor.getPointMain("2") + " Scaled by:\n" + GuiChiseledArmor.getPointSub("a") + " Scrolling the mouse wheel.\n" + GuiChiseledArmor.getPointSub("b") + " Right-clicking and dragging while holding shift.";
        String suffix2 = "\n\nAlter the player model's orientation by pressing the following keys:\n" + GuiChiseledArmor.getPointMain("C") + " centers it\n" + GuiChiseledArmor.getPointMain("R") + " resets its translation/rotation/scale";
        this.buttonPlayerFollowCursor = this.createButtonToggled(x, 186, TEXTURE_PLAYER_FOLLOW_CURSOR, "Look at cursor", prefix + "bend and twist to look at the cursor. In this mode, the model cannot be rotated, but" + suffix1 + suffix2);
        this.buttonPlayerRotate = this.createButtonToggled(x, 200, TEXTURE_PLAYER_ROTATE, "Left-click & drag to rotate", prefix + "only look forward. In this mode, the model" + suffix1 + "\n" + GuiChiseledArmor.getPointMain("3") + " Rotated by left-clicking and dragging." + suffix2);
        x = 311;
        prefix = "The x/y/z data of translation operations will display in";
        this.buttonScalePixel = this.createButtonToggled(x, 67, TEXTURE_SCALE_PIXEL, "Translation data in pixels", prefix + " 1/16 meters, i.e. pixels.\n\n" + GuiChiseledArmor.getPointExample() + " 2 = 2/16 of a meter");
        this.buttonScaleMeter = this.createButtonToggled(x, 81, TEXTURE_SCALE_METER, "Translation data in meters", prefix + " meters.\n\n" + GuiChiseledArmor.getPointExample() + " 2 = 2 meters");
        int y = 127;
        String text = " the item list of the selected moving part of the selected armor piece.";
        this.buttonItemAdd = this.createButtonListInteraction(46, y, TEXTURE_ADD, "", "Adds an empty slot to" + text + "\n\nIf the scale of the armor piece is not 1:1, a GL scale operation will be added to its GL operations list automatically.");
        this.buttonItemDelete = this.createButtonListInteraction(60, y, TEXTURE_DELETE, "Remove item", "Removes the selected slot from" + text);
        this.buttonGlAdd = this.createButtonListInteraction(97, y, TEXTURE_ADD, "", "Opens a selection screen, where the chosen GL operation is added to the list above, under the selected operation.");
        this.buttonGlDelete = this.createButtonListInteraction(111, y, TEXTURE_DELETE, "", "Removes the selected GL operation from the list above.");
        text = "Moves the selected GL operation @ in the list above. This is important, as changing the order of operations can have a significant effect.\n\n" + GuiChiseledArmor.getPointExample() + " translating in the x or z axis can result in a translation is any absolute direction, if performed after rotating in the y axis.";
        this.buttonGlMoveUp = this.createButtonListInteraction(134, y, TEXTURE_MOVE_UP, "Move GL operation up", text.replace("@", "up"));
        this.buttonGlMoveDown = this.createButtonListInteraction(148, y, TEXTURE_MOVE_DOWN, "Move GL operation down", text.replace("@", "down"));
        this.buttonGlMoveUp.setRightOffsetX(0.5f, false);
        this.buttonGlMoveDown.setRightOffsetX(0.5f, true);
        y = 50;
        this.buttonAddRotation = this.createButtonAddGlOperation(109, y, TEXTURE_ROTATION, 0);
        this.buttonAddTranslation = this.createButtonAddGlOperation(170, y, TEXTURE_TRANSLATION, 1);
        this.buttonAddScale = this.createButtonAddGlOperation(231, y, TEXTURE_SCALE, 2);
        this.buttonHelp = new GuiButtonHelp(100, this.field_146292_n, this.field_147003_i + this.field_146999_f - 17, this.field_147009_r + 5, "Show more explanatory hover text", "Exit help mode");
        this.buttonScale = new GuiButtonSelect(100, this.field_147003_i + 178, this.field_147009_r + 127, 17, 12, "", "Armor piece scale", -5111553, -5111553);
        this.buttonScale.setTextOffsetX(1.0f);
        this.buttonScale.setHoverHelpText("This is the scale of the selected armor piece. Just as all newly imported blocks are scaled by this amount when collecting them in-world, all newly added slots to any of the selected armor pieces' moving parts are likewise scaled by this amount.");
        this.field_146292_n.add(this.buttonGlItems);
        this.field_146292_n.add(this.buttonGlPre);
        this.field_146292_n.add(this.buttonGlPost);
        this.field_146292_n.add(this.buttonFullIlluminationOff);
        this.field_146292_n.add(this.buttonFullIlluminationOn);
        this.field_146292_n.add(this.buttonPlayerFollowCursor);
        this.field_146292_n.add(this.buttonPlayerRotate);
        this.field_146292_n.add(this.buttonScalePixel);
        this.field_146292_n.add(this.buttonScaleMeter);
        this.field_146292_n.add(this.buttonItemAdd);
        this.field_146292_n.add(this.buttonItemDelete);
        this.field_146292_n.add(this.buttonGlAdd);
        this.field_146292_n.add(this.buttonGlDelete);
        this.field_146292_n.add(this.buttonGlMoveUp);
        this.field_146292_n.add(this.buttonGlMoveDown);
        this.field_146292_n.add(this.buttonAddRotation);
        this.field_146292_n.add(this.buttonAddTranslation);
        this.field_146292_n.add(this.buttonAddScale);
        this.field_146292_n.add(this.buttonHelp);
        this.field_146292_n.add(this.buttonScale);
        this.emptyGlList = this.createGuiListGlOperation(null, GlOperationListType.ARMOR_ITEM);
        for (int i = 0; i < this.armorPieces.length; ++i) {
            int j;
            ItemStack stack = this.getArmorStack(i);
            if (ItemStackHelper.isChiseledArmorStack(stack)) {
                this.armorPieces[i] = new DataChiseledArmorPiece(ItemStackHelper.getNBTOrNew(stack), ItemChiseledArmor.ArmorType.values()[i]);
            }
            ItemChiseledArmor.ArmorType armorType = ItemChiseledArmor.ArmorType.values()[i];
            GuiButtonTab tab = new GuiButtonTab(i * 4, this.field_147003_i, this.field_147009_r + 23 + i * 25, 24, 25, armorType.getName(), new ItemStack(armorType == ItemChiseledArmor.ArmorType.HELMET ? ItemsExtraBitManipulation.chiseledHelmet : (armorType == ItemChiseledArmor.ArmorType.CHESTPLATE ? ItemsExtraBitManipulation.chiseledChestplate : (armorType == ItemChiseledArmor.ArmorType.LEGGINGS ? ItemsExtraBitManipulation.chiseledLeggings : ItemsExtraBitManipulation.chiseledBoots))), 0.0f, 0.0f, 0, 0, 19, 230, 512, TEXTURE_GUI);
            tab.setHoverHelpText("Armor Piece: " + tab.getHoverText() + "\n\nEach of these 4 tabs represents a worn chiseled armor piece. If a tab is disabled, the corresponding armor slot is either empty or contains a different kind of armor.");
            DataChiseledArmorPiece armorPiece = this.armorPieces[i];
            boolean bl = tab.field_146124_l = armorPiece != null;
            if (this.selectedTabIndex < 0 && tab.field_146124_l) {
                this.selectedTabIndex = i;
            }
            if (i == this.selectedTabIndex) {
                tab.selected = true;
            }
            this.tabButtons[i][0] = tab;
            this.field_146292_n.add(tab);
            if (armorPiece == null) continue;
            ItemChiseledArmor.ArmorMovingPart[] movingParts = ((ItemChiseledArmor)stack.func_77973_b()).MOVING_PARTS;
            for (j = 0; j < movingParts.length; ++j) {
                GuiButtonTab tabSub = new GuiButtonTab(i * 4 + j + 1, this.field_147003_i, this.field_147009_r + 147 + j * 25, 24, 25, movingParts[j].getName(), 0.0f, 0.0f, 0, 0, 19, 230, 512, TEXTURE_GUI, movingParts[j].getIconModels());
                tabSub.setHoverHelpText("Moving Part: " + tabSub.getHoverText() + "\n\nEach of these tabs represents a moving part of the armor piece specified by the selected armor piece tab.");
                if (j + 1 == this.selectedSubTabIndex) {
                    tabSub.selected = true;
                }
                this.tabButtons[i][j + 1] = tabSub;
                this.field_146292_n.add(tabSub);
            }
            this.globalPreGlLists[i] = this.createGuiListGlOperation(armorPiece, GlOperationListType.GLOBAL_PRE);
            this.globalPostGlLists[i] = this.createGuiListGlOperation(armorPiece, GlOperationListType.GLOBAL_POST);
            for (j = 0; j < this.armorItemLists[0].length; ++j) {
                if (this.tabButtons[i][j + 1] == null) continue;
                this.armorItemLists[i][j] = new GuiListArmorItem(this, this.field_146295_m, this.field_147009_r + 24, this.field_147009_r + 124, 20, 38, 49, armorPiece, j);
                ArrayList<GuiListGlOperation> armorItemGlList = new ArrayList<GuiListGlOperation>();
                List<ArmorItem> armorItems = armorPiece.getArmorItemsForPart(j);
                for (int k = 0; k < armorItems.size(); ++k) {
                    armorItemGlList.add(this.createGuiListGlOperation(armorPiece, GlOperationListType.ARMOR_ITEM, j, k));
                }
                this.armorItemGlLists[i][j] = armorItemGlList;
            }
        }
        this.updateButtons();
        this.refreshLists(false);
    }

    public static String getPointMain(String point) {
        return TextFormatting.AQUA + point + TextFormatting.RESET;
    }

    public static String getPointSub(String point) {
        return "    " + TextFormatting.GREEN + point + TextFormatting.RESET;
    }

    public static String getPointExample() {
        return TextFormatting.YELLOW + "Ex:" + TextFormatting.RESET;
    }

    public static String underlineText(String text) {
        return TextFormatting.UNDERLINE + text + TextFormatting.RESET;
    }

    private EntityEquipmentSlot getArmorSlot(int index) {
        return EntityEquipmentSlot.values()[5 - index];
    }

    private ItemStack getArmorStack(int index) {
        return ItemStackHelper.getChiseledArmorStack(ClientHelper.getPlayer(), this.getArmorSlot(index), this.isMainArmorMode);
    }

    private GuiListGlOperation createGuiListGlOperation(DataChiseledArmorPiece armorPiece) {
        return this.createGuiListGlOperation(armorPiece, this.buttonGlItems.selected ? GlOperationListType.ARMOR_ITEM : (this.buttonGlPre.selected ? GlOperationListType.GLOBAL_PRE : GlOperationListType.GLOBAL_POST), this.selectedSubTabIndex - 1, this.getSelectedGuiListArmorItem().getSelectListEntryIndex());
    }

    private GuiListGlOperation createGuiListGlOperation(@Nullable DataChiseledArmorPiece armorPiece, GlOperationListType type) {
        return this.createGuiListGlOperation(armorPiece, type, 0, 0);
    }

    private GuiListGlOperation createGuiListGlOperation(@Nullable DataChiseledArmorPiece armorPiece, GlOperationListType type, int partIndex, int armorItemIndex) {
        return type == GlOperationListType.ARMOR_ITEM ? new GuiListGlOperationItem(this, this.field_146295_m, this.field_147009_r + 24, this.field_147009_r + 124, 16, 91, 220, armorPiece, partIndex, armorItemIndex) : new GuiListGlOperationGlobal(this, this.field_146295_m, this.field_147009_r + 24, this.field_147009_r + 124, 16, 91, 220, armorPiece, type == GlOperationListType.GLOBAL_PRE);
    }

    private GuiButtonSelectTextured createButtonAddGlOperation(int offsetX, int offsetY, ResourceLocation texture, int titleIndex) {
        GuiButtonSelectTextured button = this.createButtonToggled(offsetX, offsetY, 52, 48, GL_OPERATION_TITLES[titleIndex], glOperationHoverHelpText, -38400, -38400, texture);
        button.field_146125_m = false;
        return button;
    }

    private GuiButtonSelectTextured createButtonListInteraction(int offsetX, int offsetY, ResourceLocation texture, String hoverText, String hoverHelpText) {
        return this.createButtonToggled(offsetX, offsetY, 12, 12, hoverText, hoverHelpText, -16739073, -16739073, texture);
    }

    private GuiButtonSelectTextured createButtonToggled(int offsetX, int offsetY, ResourceLocation texture, String hoverText, String hoverHelpText) {
        return this.createButtonToggled(offsetX, offsetY, 12, 12, hoverText, hoverText + "\n\n" + hoverHelpText, -16726016, -8882056, texture);
    }

    private GuiButtonSelectTextured createButtonToggled(int offsetX, int offsetY, int width, int height, String hoverText, String hoverHelpText, int colorSelected, int colorDeselected, ResourceLocation texture) {
        GuiButtonSelectTextured button = new GuiButtonSelectTextured(100, this.field_147003_i + offsetX, this.field_147009_r + offsetY, width, height, "", hoverText, colorSelected, colorDeselected, texture);
        button.setHoverHelpText(hoverHelpText);
        return button;
    }

    private GuiButtonSelect createButtonGlobalGl(int id, int offsetX, int offsetY, String text) {
        return this.createButtonGl(id, offsetX, offsetY, text, "Performed @ each item's GL operations".replace("@", text.toLowerCase()), "Before and after a given item's list of GL operations are performed, a global list of operations are performed. For each moving part of an armor piece, rendering occurs as follows:\n" + GuiChiseledArmor.getPointMain("1") + " Perform global pre-operations.\n" + GuiChiseledArmor.getPointMain("2") + " For each item:\n" + GuiChiseledArmor.getPointSub("a") + " Perform the item's operations.\n" + GuiChiseledArmor.getPointSub("b") + " Perform global post-operations.\n" + GuiChiseledArmor.getPointSub("c") + " Render the item.\n\nIf this button is selected, the list of global " + text.replace("Before", "pre").replace("After", "post") + "-operations will be displayed in the area below.");
    }

    private GuiButtonSelect createButtonGl(int id, int offsetX, int offsetY, String text, String hoverText, String hoverHelpText) {
        GuiButtonSelect button = new GuiButtonSelect(id, this.field_147003_i + offsetX, this.field_147009_r + offsetY, this.field_146289_q.func_78256_a(text) + 3, 12, text, hoverText, -16726016, 0);
        button.setHoverHelpText(hoverHelpText);
        return button;
    }

    private GuiListArmorItem getSelectedGuiListArmorItem() {
        return this.armorItemLists[this.selectedTabIndex][this.selectedSubTabIndex - 1];
    }

    private GuiListGlOperation getSelectedGuiListGlOperation() {
        if (!this.buttonGlItems.selected) {
            return this.buttonGlPre.selected ? this.globalPreGlLists[this.selectedTabIndex] : this.globalPostGlLists[this.selectedTabIndex];
        }
        List<GuiListGlOperation> list = this.getSelectedGuiListArmorItemGlOperations();
        int index = this.getSelectedGuiListArmorItem().getSelectListEntryIndex();
        return index < list.size() ? list.get(index) : this.emptyGlList;
    }

    private List<GuiListGlOperation> getSelectedGuiListArmorItemGlOperations() {
        return this.armorItemGlLists[this.selectedTabIndex][this.selectedSubTabIndex - 1];
    }

    public boolean scalePixel() {
        return this.buttonScalePixel.selected;
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (!this.playerBoxClicked && !this.buttonAddRotation.field_146125_m) {
            this.getSelectedGuiListArmorItem().func_178039_p();
            this.getSelectedGuiListGlOperation().func_178039_p();
        }
        Pair<Vec3d, Float> pair = GuiHelper.scaleObjectWithMouseWheel((GuiScreen)this, this.boxPlayer, this.playerTranslation, this.playerScale, 5.0f, 40.25f);
        this.playerTranslation = (Vec3d)pair.getLeft();
        this.playerScale = ((Float)pair.getRight()).floatValue();
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        if (!this.playerBoxClicked) {
            return;
        }
        float deltaX = this.mouseInitialX - mouseX;
        float deltaY = this.mouseInitialY - mouseY;
        if (clickedMouseButton == 0) {
            this.mouseInitialX = mouseX;
            this.mouseInitialY = mouseY;
        }
        Triple<Vec3d, Vec3d, Float> triple = GuiHelper.dragObject(clickedMouseButton, deltaX, deltaY, this.playerTranslationInitial, this.playerRotation, this.playerScale, 5.0f, 2.0f, 3.0f, this.buttonPlayerRotate.selected);
        this.playerTranslation = (Vec3d)triple.getLeft();
        this.playerRotation = (Vec3d)triple.getMiddle();
        this.playerScale = ((Float)triple.getRight()).floatValue();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (!this.buttonAddRotation.field_146125_m) {
            this.getSelectedGuiListArmorItem().func_148179_a(mouseX, mouseY, mouseButton);
            this.getSelectedGuiListGlOperation().func_148179_a(mouseX, mouseY, mouseButton);
        } else if (!this.buttonGlAdd.func_146115_a() && (!GuiHelper.isCursorInsideBox(this.boxGlOperation, mouseX, mouseY) || this.buttonAddRotation.func_146115_a() || this.buttonAddTranslation.func_146115_a() || this.buttonAddScale.func_146115_a())) {
            this.hideAddGlButtons();
        }
        this.playerBoxClicked = GuiHelper.isCursorInsideBox(this.boxPlayer, mouseX, mouseY);
        this.mouseInitialX = mouseX;
        this.mouseInitialY = mouseY;
        this.playerTranslationInitial = new Vec3d(this.playerTranslation.field_72450_a, this.playerTranslation.field_72448_b, 0.0);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (!this.buttonAddRotation.field_146125_m) {
            this.getSelectedGuiListArmorItem().func_148181_b(mouseX, mouseY, state);
            this.getSelectedGuiListGlOperation().func_148181_b(mouseX, mouseY, state);
        }
        this.mouseInitialX = 0;
        this.mouseInitialY = 0;
        this.playerBoxClicked = false;
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.getSelectedGuiListGlOperation().updateScreen();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int i;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.playerBoxClicked || this.buttonAddRotation.field_146125_m) {
            if (this.buttonAddRotation.field_146125_m && this.buttonHelp.selected && (this.buttonAddRotation.func_146115_a() || this.buttonAddTranslation.func_146115_a() || this.buttonAddScale.func_146115_a())) {
                this.func_146279_a(this.buttonAddRotation.getHoverText(), mouseX, mouseY);
            }
            return;
        }
        Slot slot = this.getSlotUnderMouse();
        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o() == null && slot != null && slot.func_75216_d()) {
            this.func_146285_a(slot.func_75211_c(), mouseX, mouseY);
        }
        GuiHelper.drawHoveringTextForButtons(this, this.field_146292_n, mouseX, mouseY);
        GuiListGlOperation glOperationsList = this.getSelectedGuiListGlOperation();
        if (GuiHelper.isCursorInsideBox(this.boxGlOperation, mouseX, mouseY)) {
            for (i = 0; i < glOperationsList.func_148127_b(); ++i) {
                GuiListEntryGlOperation entry = (GuiListEntryGlOperation)glOperationsList.getListEntry(i);
                if (!entry.isElementHovered(this.buttonHelp.selected)) continue;
                this.func_146279_a(entry.getElementHoverText(this.buttonHelp.selected ? glOperationHoverHelpText : null), mouseX, mouseY);
                break;
            }
        }
        if (GuiHelper.isCursorInsideBox(this.boxArmorItem, mouseX, mouseY)) {
            GuiListArmorItem armorItemsList = this.getSelectedGuiListArmorItem();
            for (int i2 = 0; i2 < armorItemsList.func_148127_b(); ++i2) {
                GuiListEntryArmorItem entry = (GuiListEntryArmorItem)armorItemsList.getListEntry(i2);
                if (!entry.isSlotHovered()) continue;
                if (this.buttonHelp.selected) {
                    this.func_146279_a(this.getArmoritemSlotHoverhelpText("These slots"), mouseX, mouseY);
                    break;
                }
                if (entry.getStack() == null) break;
                this.func_146285_a(entry.getStack(), mouseX, mouseY);
                break;
            }
        }
        if (this.buttonHelp.selected) {
            if (GuiHelper.isCursorInsideBox(this.boxTitleItems, mouseX, mouseY)) {
                this.func_146279_a(this.getArmoritemSlotHoverhelpText("The slots of the list below"), mouseX, mouseY);
            } else if (GuiHelper.isCursorInsideBox(this.boxTitleGlOperations, mouseX, mouseY)) {
                this.func_146279_a("The rendered items for the moving parts of armor pieces can have any number of GL operations applied to them. The three types are rotation, translation, and scale.\n\nGlobal pre/post-operations apply to all items of an armor piece, while item-specific operations only apply to a single item.\n\nFor more information on these three categories refer to the hover text of the corresponding buttons to the right." + glOperationHoverKeysHelpText, mouseX, mouseY);
            }
            for (i = 0; i < this.boxesData.length; ++i) {
                if (!GuiHelper.isCursorInsideBox(this.boxesData[i], mouseX, mouseY)) continue;
                this.func_146279_a(GL_OPERATION_DATA_TITLES[i] + " of the GL operations below", mouseX, mouseY);
                break;
            }
        }
    }

    private String getArmoritemSlotHoverhelpText(String prefix) {
        return prefix + " contain items of the selected moving part of the selected armor piece (currently, the " + ((ItemChiseledArmor)this.getArmorStack((int)this.selectedTabIndex).func_77973_b()).MOVING_PARTS[this.selectedSubTabIndex - 1].getName() + " of the " + ItemChiseledArmor.ArmorType.values()[this.selectedTabIndex].getName() + ")\n\nSlots can be interacted with as follows:\n" + GuiChiseledArmor.getPointMain("1") + " Click with an item on the cursor to add a copy of that item.\n" + GuiChiseledArmor.getPointMain("2") + " Shift-click to clear the copied item.\n" + GuiChiseledArmor.getPointMain("3") + " Middle mouse click in creative mode to get item.\n\nKey presses manipulate slots (along with any associated GL operations) as follows:\n" + GuiChiseledArmor.getPointMain("Control + C") + " copy\n" + GuiChiseledArmor.getPointMain("Control + V") + " paste\n" + GuiChiseledArmor.getPointMain("Delete") + " delete\n";
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b("Items", 43, 13, 0x404040);
        this.field_146289_q.func_78276_b("GL Operations", 96, 13, 0x404040);
        GuiListArmorItem armorItemsList = this.getSelectedGuiListArmorItem();
        GuiListGlOperation glOperationsList = this.getSelectedGuiListGlOperation();
        glOperationsList.setDrawEntries(!this.buttonAddRotation.field_146125_m);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(-this.field_147003_i), (float)(-this.field_147009_r), (float)0.0f);
        armorItemsList.drawScreen(mouseX, mouseY);
        glOperationsList.drawScreen(mouseX, mouseY);
        GlStateManager.func_179121_F();
        if (this.buttonAddRotation.field_146125_m) {
            int y = 103;
            this.field_146289_q.func_78276_b(GL_OPERATION_TITLES[2], 244, y, 0x404040);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)0.0);
            this.field_146289_q.func_78276_b(GL_OPERATION_TITLES[0], 116, y, 0x404040);
            this.field_146289_q.func_78276_b(GL_OPERATION_TITLES[1], 168, y, 0x404040);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(-this.field_147003_i), (float)(-this.field_147009_r), (float)0.0f);
        for (int i = 0; i < this.tabButtons.length; ++i) {
            for (int j = 0; j < this.tabButtons[0].length; ++j) {
                GuiButtonTab tab = this.tabButtons[i][j];
                if (tab == null || !tab.field_146125_m) continue;
                tab.renderIconStack();
            }
        }
        GlStateManager.func_179121_F();
        this.glScissorBox(this.boxArmorItem);
        for (int i = 0; i < armorItemsList.func_148127_b(); ++i) {
            ItemStack stack = ((GuiListEntryArmorItem)armorItemsList.getListEntry(i)).getStack();
            if (stack == null) continue;
            RenderHelper.func_74520_c();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int x = armorItemsList.field_148152_e + 6 - this.field_147003_i;
            int y = armorItemsList.field_148153_b - armorItemsList.func_148148_g() + i * armorItemsList.field_148149_f + armorItemsList.field_148160_j + 3 - this.field_147009_r;
            this.field_73735_i = 100.0f;
            this.field_146296_j.field_77023_b = 100.0f;
            GlStateManager.func_179126_j();
            this.field_146296_j.func_184391_a((EntityLivingBase)this.field_146297_k.field_71439_g, stack, x, y);
            this.field_146296_j.func_180453_a(this.field_146289_q, stack, x, y, null);
            this.field_146296_j.field_77023_b = 0.0f;
            this.field_73735_i = 0.0f;
        }
        GuiHelper.glScissorDisable();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ClientHelper.bindTexture(TEXTURE_GUI);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        GuiChiseledArmor.func_146110_a((int)(i + 24), (int)j, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (float)512.0f, (float)512.0f);
        GlStateManager.func_179094_E();
        this.glScissorBox(this.boxPlayer);
        int x = i + 256;
        int y = j + 216;
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179152_a((float)this.playerScale, (float)this.playerScale, (float)this.playerScale);
        GlStateManager.func_179137_b((double)(this.playerTranslation.field_72450_a * (double)(1.0f / this.playerScale)), (double)((float)(this.playerTranslation.field_72448_b + 3.0) * (1.0f / this.playerScale)), (double)150.0);
        if (!this.buttonPlayerFollowCursor.selected) {
            GlStateManager.func_179109_b((float)0.0f, (float)-37.25f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)(-this.playerRotation.field_72450_a)), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)this.playerRotation.field_72448_b), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)37.25f, (float)0.0f);
        }
        float lookX = 0.0f;
        float lookY = 0.0f;
        if (this.buttonPlayerFollowCursor.selected) {
            lookX = (float)(x - mouseX) + (float)this.playerTranslation.field_72450_a;
            lookY = (float)(y - mouseY) + (float)this.playerTranslation.field_72448_b - 64.5f * this.playerScale + 3.0f;
        }
        this.drawEntityOnScreen(40, lookX, lookY, (EntityLivingBase)this.field_146297_k.field_71439_g);
        GuiHelper.glScissorDisable();
        GlStateManager.func_179121_F();
        if (this.buttonHelp.selected) {
            GuiChiseledArmor.func_73734_a((int)((int)this.boxTitleItems.field_72340_a), (int)((int)this.boxTitleItems.field_72338_b), (int)((int)this.boxTitleItems.field_72336_d), (int)((int)this.boxTitleItems.field_72337_e), (int)1694460416);
            GuiChiseledArmor.func_73734_a((int)((int)this.boxTitleGlOperations.field_72340_a), (int)((int)this.boxTitleGlOperations.field_72338_b), (int)((int)this.boxTitleGlOperations.field_72336_d), (int)((int)this.boxTitleGlOperations.field_72337_e), (int)1694460416);
            for (AxisAlignedBB box : this.boxesData) {
                GuiChiseledArmor.func_73734_a((int)((int)box.field_72340_a), (int)((int)box.field_72338_b), (int)((int)box.field_72336_d), (int)((int)box.field_72337_e), (int)1694460416);
            }
        }
    }

    private void glScissorBox(AxisAlignedBB box) {
        GuiHelper.glScissor((int)box.field_72340_a, (int)box.field_72338_b, (int)(box.field_72336_d - box.field_72340_a), (int)(box.field_72337_e - box.field_72338_b));
    }

    private void drawEntityOnScreen(int scale, float lookX, float lookY, EntityLivingBase entity) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f = entity.field_70761_aq;
        float f1 = entity.field_70177_z;
        float f2 = entity.field_70125_A;
        float f3 = entity.field_70758_at;
        float f4 = entity.field_70759_as;
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        if (this.buttonFullIlluminationOn.selected) {
            GlStateManager.func_179140_f();
        }
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(-Math.atan(lookY / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        entity.field_70761_aq = (float)Math.atan(lookX / 40.0f) * 20.0f;
        entity.field_70177_z = (float)Math.atan(lookX / 40.0f) * 40.0f;
        entity.field_70125_A = (float)(-Math.atan(lookY / 40.0f)) * 20.0f;
        entity.field_70759_as = entity.field_70177_z;
        entity.field_70758_at = entity.field_70177_z;
        RenderManager rendermanager = ClientHelper.getRenderManager();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        entity.field_70761_aq = f;
        entity.field_70177_z = f1;
        entity.field_70125_A = f2;
        entity.field_70758_at = f3;
        entity.field_70759_as = f4;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        boolean cDown = Keyboard.isKeyDown((int)46);
        if (this.buttonAddRotation.field_146125_m) {
            if (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
                this.hideAddGlButtons();
            }
        } else if (!GuiChiseledArmor.func_146271_m() && (cDown || Keyboard.isKeyDown((int)19))) {
            if (!cDown) {
                this.resetRotationAndScale();
            }
            this.playerTranslation = new Vec3d(0.0, (double)(-37.25f + 37.25f * this.playerScale), 0.0);
        } else {
            int mouseY;
            ScaledResolution scaledresolution = new ScaledResolution(this.field_146297_k);
            int mouseX = Mouse.getX() * scaledresolution.func_78326_a() / this.field_146297_k.field_71443_c;
            boolean affectGlOperationsList = GuiHelper.isCursorInsideBox(this.boxGlOperation, mouseX, mouseY = scaledresolution.func_78328_b() - Mouse.getY() * scaledresolution.func_78328_b() / this.field_146297_k.field_71440_d - 1);
            if (affectGlOperationsList && this.fieldIsFocused(this.getSelectedGuiListGlOperation())) {
                this.getSelectedGuiListGlOperation().keyTyped(typedChar, keyCode);
                super.func_73869_a(typedChar, keyCode);
                return;
            }
            if (!this.waitingForServerResponse && affectGlOperationsList && (Keyboard.isKeyDown((int)200) || Keyboard.isKeyDown((int)208))) {
                this.moveGlOperationInList(Keyboard.isKeyDown((int)200));
            } else if (!this.waitingForServerResponse && (affectGlOperationsList || GuiHelper.isCursorInsideBox(this.boxArmorItem, mouseX, mouseY)) && (Keyboard.isKeyDown((int)211) || GuiChiseledArmor.func_146271_m() && (cDown || Keyboard.isKeyDown((int)47)))) {
                GuiListChiseledArmor list;
                GuiListChiseledArmor guiListChiseledArmor = list = affectGlOperationsList ? this.getSelectedGuiListGlOperation() : this.getSelectedGuiListArmorItem();
                if (cDown) {
                    if (affectGlOperationsList) {
                        GuiListEntryChiseledArmor entry = list.getSelectedListEntry();
                        if (entry != null) {
                            this.copiedGlOperation = new NBTTagCompound();
                            ((GlOperation)entry.entryObject).saveToNBT(this.copiedGlOperation);
                        }
                    } else {
                        GuiListEntryChiseledArmor entry = list.getSelectedListEntry();
                        if (entry != null && ((ArmorItem)entry.entryObject).getStack() != null) {
                            this.copiedArmorItem = ((ArmorItem)entry.entryObject).getStack().func_77946_l();
                            this.copiedArmorItemGlOperations = new NBTTagCompound();
                            GlOperation.saveListToNBT(this.copiedArmorItemGlOperations, "glOperations", ((ArmorItem)entry.entryObject).getGlOperations());
                        }
                    }
                } else if (Keyboard.isKeyDown((int)47)) {
                    if (!affectGlOperationsList) {
                        this.addOrRemoveArmorItemListData((GuiListArmorItem)list, list.func_148127_b(), true);
                    } else if (this.copiedGlOperation != null) {
                        this.addGlOperationToList(new GlOperation(this.copiedGlOperation));
                    }
                } else if (affectGlOperationsList) {
                    this.removeGlOperationFromListOrEnterAddSelection(false);
                } else {
                    GuiListEntryChiseledArmor entry = this.getSelectedGuiListArmorItem().getSelectedListEntry();
                    int index = list.getSelectListEntryIndex();
                    if (entry != null) {
                        this.addOrRemoveArmorItemListData((GuiListArmorItem)list, index != 0 && index == list.func_148127_b() - 1 ? index - 1 : -1, false);
                    }
                }
            } else {
                this.getSelectedGuiListGlOperation().keyTyped(typedChar, keyCode);
                super.func_73869_a(typedChar, keyCode);
            }
        }
    }

    private boolean fieldIsFocused(GuiListChiseledArmor list) {
        for (int i = 0; i < list.func_148127_b(); ++i) {
            if (!((GuiListEntryGlOperation)list.getListEntry(i)).fieldIsFocused()) continue;
            return true;
        }
        return false;
    }

    private boolean hideAddGlButtons() {
        this.buttonAddScale.field_146125_m = false;
        this.buttonAddTranslation.field_146125_m = false;
        this.buttonAddRotation.field_146125_m = false;
        return false;
    }

    protected void func_184098_a(Slot slot, int slotId, int mouseButton, ClickType type) {
        if (type != ClickType.PICKUP_ALL) {
            super.func_184098_a(slot, slotId, mouseButton, type);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (this.waitingForServerResponse) {
            super.func_146284_a(button);
            return;
        }
        if (this.buttonAddRotation.field_146125_m) {
            if (button == this.buttonAddRotation || button == this.buttonAddTranslation || button == this.buttonAddScale) {
                this.addGlOperationToList(button == this.buttonAddRotation ? new GlOperation(GlOperation.GlOperationType.ROTATION) : (button == this.buttonAddTranslation ? new GlOperation(GlOperation.GlOperationType.TRANSLATION) : new GlOperation(GlOperation.GlOperationType.SCALE, 1.0f, 1.0f, 1.0f)));
            }
            return;
        }
        if (button.field_146127_k < 16) {
            int indexTab = button.field_146127_k / 4;
            int indexSubTab = button.field_146127_k % 4;
            GuiButtonTab buttonTab = this.tabButtons[indexTab][indexSubTab];
            if (!buttonTab.selected) {
                this.selectedTabIndex = indexTab;
                int n = this.selectedSubTabIndex = indexSubTab == 0 ? 1 : indexSubTab;
                if (indexSubTab != 0) {
                    ItemStack stack = this.getArmorStack(indexTab);
                    BitToolSettingsHelper.setArmorMovingPart((EntityPlayer)this.field_146297_k.field_71439_g, stack, indexSubTab - 1, BitToolSettingsHelper.getArmorMovingPartConfig(((ItemChiseledArmor)stack.func_77973_b()).field_77881_a), this.getArmorSlot(indexTab), this.isMainArmorMode);
                }
            }
            this.updateButtons();
        } else if (button == this.buttonGlItems || button == this.buttonGlPre || button == this.buttonGlPost) {
            this.buttonGlItems.selected = button == this.buttonGlItems;
            this.buttonGlPre.selected = button == this.buttonGlPre;
            this.buttonGlPost.selected = button == this.buttonGlPost;
            this.updateButtons();
        } else if (button == this.buttonScalePixel || button == this.buttonScaleMeter) {
            BitToolSettingsHelper.setArmorPixelTranslation(button == this.buttonScalePixel);
            this.updateButtons();
            this.refreshLists(true);
        } else if (button == this.buttonFullIlluminationOff || button == this.buttonFullIlluminationOn) {
            BitToolSettingsHelper.setArmorFullIllumination(button == this.buttonFullIlluminationOn);
            this.updateButtons();
        } else if (button == this.buttonPlayerFollowCursor || button == this.buttonPlayerRotate) {
            BitToolSettingsHelper.setArmorLookAtCursor(button == this.buttonPlayerFollowCursor);
            this.updateButtons();
        } else if (button == this.buttonItemAdd || button == this.buttonItemDelete) {
            GuiListArmorItem list = this.getSelectedGuiListArmorItem();
            if (button == this.buttonItemAdd) {
                this.addOrRemoveArmorItemListData(list, list.func_148127_b(), button);
            } else {
                GuiListEntryChiseledArmor entry = this.getSelectedGuiListArmorItem().getSelectedListEntry();
                int index = list.getSelectListEntryIndex();
                if (entry != null) {
                    this.addOrRemoveArmorItemListData(list, index != 0 && index == list.func_148127_b() - 1 ? index - 1 : -1, button);
                }
            }
        } else if (button == this.buttonGlAdd || button == this.buttonGlDelete) {
            this.removeGlOperationFromListOrEnterAddSelection(button == this.buttonGlAdd);
        } else if (button == this.buttonGlMoveUp || button == this.buttonGlMoveDown) {
            this.moveGlOperationInList(button == this.buttonGlMoveUp);
        } else if (button == this.buttonScale) {
            BitToolSettingsHelper.setArmorScale((EntityPlayer)this.field_146297_k.field_71439_g, this.getArmorStack(this.selectedTabIndex), (Integer.parseInt(this.buttonScale.field_146126_j.substring(2)) / 2 + 1) % 3, Configs.armorScale, this.getArmorSlot(this.selectedTabIndex), this.isMainArmorMode);
            this.updateButtons();
        } else {
            super.func_146284_a(button);
        }
    }

    private void removeGlOperationFromListOrEnterAddSelection(boolean add) {
        if (!this.buttonGlItems.selected || this.getSelectedGuiListArmorItem().func_148127_b() > 0) {
            GuiListGlOperation list = this.getSelectedGuiListGlOperation();
            if (add) {
                this.buttonAddScale.field_146125_m = true;
                this.buttonAddTranslation.field_146125_m = true;
                this.buttonAddRotation.field_146125_m = true;
            } else if (list.func_148127_b() > 0) {
                int index = list.getSelectListEntryIndex();
                this.setGlOperationListData(list.removeGlOperation(index), index != 0 && index == list.func_148127_b() - 1 ? index - 1 : -1, true);
            }
        }
    }

    private void addGlOperationToList(GlOperation glOperation) {
        int index;
        Object list;
        if (((Object)((Object)this.getSelectedGuiListGlOperation())).equals((Object)this.emptyGlList)) {
            list = this.getSelectedGuiListArmorItemGlOperations();
            index = this.getSelectedGuiListArmorItem().getSelectListEntryIndex();
            while (index >= list.size()) {
                list.add(this.createGuiListGlOperation(this.getSelectedGuiListArmorItem().armorPiece));
            }
        }
        list = this.getSelectedGuiListGlOperation();
        index = ((GuiListChiseledArmor)((Object)list)).getSelectListEntryIndex();
        this.setGlOperationListData(((GuiListGlOperation)((Object)list)).addGlOperation(((GuiListChiseledArmor)((Object)list)).func_148127_b() > 0 ? ++index : index, glOperation), ((GuiListChiseledArmor)((Object)list)).func_148127_b() > 0 ? index : -1, true);
    }

    private void moveGlOperationInList(boolean moveUp) {
        GuiListGlOperation list = this.getSelectedGuiListGlOperation();
        int index = list.getSelectListEntryIndex();
        if (moveUp ? index > 0 : index < list.func_148127_b() - 1) {
            this.setGlOperationListData(list.moveGlOperation(index, list.getGlOperations().get(index), moveUp), index += moveUp ? -1 : 1, true);
        }
    }

    private int getArmorScale() {
        return BitToolSettingsHelper.getArmorScale(this.getArmorStack(this.selectedTabIndex).func_77978_p());
    }

    private void addOrRemoveArmorItemListData(GuiListArmorItem list, int selectedArmorItem, GuiButton button) {
        boolean add = button == this.buttonItemAdd;
        NBTTagCompound nbtGlOperations = new NBTTagCompound();
        int scale = this.getArmorScale();
        if (add && scale > 0) {
            float scale2 = (float)(1.0 / Math.pow(2.0, scale));
            GlOperation.saveListToNBT(nbtGlOperations, "glOperations", Collections.singletonList(GlOperation.createScale(scale2, scale2, scale2)));
        }
        this.setArmorItemListData(list, selectedArmorItem, add ? PacketChangeArmorItemList.ListOperation.ADD : PacketChangeArmorItemList.ListOperation.REMOVE, null, nbtGlOperations);
    }

    private void addOrRemoveArmorItemListData(GuiListArmorItem list, int selectedArmorItem, boolean add) {
        ItemStack stack;
        PacketChangeArmorItemList.ListOperation listOperation;
        NBTTagCompound nbtGlOperations = new NBTTagCompound();
        if (add) {
            listOperation = PacketChangeArmorItemList.ListOperation.ADD;
            stack = this.copiedArmorItem == null ? null : this.copiedArmorItem.func_77946_l();
            nbtGlOperations = this.copiedArmorItemGlOperations.func_74737_b();
        } else {
            listOperation = PacketChangeArmorItemList.ListOperation.REMOVE;
            stack = null;
            nbtGlOperations = new NBTTagCompound();
        }
        this.setArmorItemListData(list, selectedArmorItem, listOperation, stack, nbtGlOperations);
    }

    public void modifyArmorItemListData(int selectedArmorItem, ItemStack stack) {
        NBTTagCompound nbtGlOperations = new NBTTagCompound();
        this.setArmorItemListData(this.getSelectedGuiListArmorItem(), selectedArmorItem, PacketChangeArmorItemList.ListOperation.MODIFY, stack, nbtGlOperations);
    }

    private void setArmorItemListData(GuiListArmorItem list, int selectedArmorItem, PacketChangeArmorItemList.ListOperation listOperation, ItemStack stack, NBTTagCompound nbtGlOperations) {
        ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketChangeArmorItemList(this.getArmorSlot(this.selectedTabIndex), this.isMainArmorMode, this.selectedSubTabIndex - 1, list.getSelectListEntryIndex(), selectedArmorItem, listOperation, stack, nbtGlOperations, true));
        this.waitingForServerResponse = true;
    }

    public void setGlOperationListData(int selectedGlOperation, boolean refreshLists) {
        this.setGlOperationListData(this.getSelectedGuiListGlOperation().getGlOperations(), selectedGlOperation, refreshLists);
        this.waitingForServerResponse = false;
    }

    private void setGlOperationListData(List<GlOperation> glOperations, int selectedGlOperation, boolean refreshLists) {
        String key = this.buttonGlItems.selected ? "glOperations" : (this.buttonGlPre.selected ? "glOperationsPre" : "glOperationsPost");
        NBTTagCompound nbt = new NBTTagCompound();
        GlOperation.saveListToNBT(nbt, key, glOperations);
        ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketChangeGlOperationList(nbt, key, this.getArmorSlot(this.selectedTabIndex), this.isMainArmorMode, this.selectedSubTabIndex - 1, this.getSelectedGuiListArmorItem().getSelectListEntryIndex(), selectedGlOperation, refreshLists));
        this.waitingForServerResponse = true;
    }

    private void updateButtons() {
        boolean on;
        boolean followCursor;
        boolean preSelected;
        for (int i = 0; i < this.tabButtons.length; ++i) {
            boolean bl = this.tabButtons[i][0].selected = i == this.selectedTabIndex;
            if (i == this.selectedTabIndex) {
                this.selectedSubTabIndex = BitToolSettingsHelper.getArmorMovingPart(ItemStackHelper.getNBTOrNew(this.getArmorStack(i)), (ItemChiseledArmor)this.getArmorStack(i).func_77973_b()).getPartIndex() + 1;
            }
            for (int j = 1; j < this.tabButtons[i].length; ++j) {
                GuiButtonTab tab = this.tabButtons[i][j];
                if (tab == null) continue;
                this.tabButtons[i][j].selected = j == this.selectedSubTabIndex;
                this.tabButtons[i][j].field_146125_m = i == this.selectedTabIndex;
            }
        }
        BitToolSettingsHelper.setArmorTabIndex(this.selectedTabIndex);
        this.buttonScalePixel.selected = preSelected = BitToolSettingsHelper.getArmorPixelTranslation();
        this.buttonScaleMeter.selected = !preSelected;
        this.buttonPlayerFollowCursor.selected = followCursor = BitToolSettingsHelper.getArmorLookAtCursor();
        this.buttonPlayerRotate.selected = !followCursor;
        this.buttonFullIlluminationOn.selected = on = BitToolSettingsHelper.getArmorFullIllumination();
        boolean bl = this.buttonFullIlluminationOff.selected = !on;
        String suffix = this.buttonGlItems.selected ? "the selected item" : "the global " + (this.buttonGlPre.selected ? "pre" : "post") + "-operations list";
        this.buttonGlAdd.setHoverText("Add Gl operation to " + suffix);
        this.buttonGlDelete.setHoverText("Remove GL operation from " + suffix);
        this.buttonScale.field_146126_j = ItemChiseledArmor.SCALE_TITLES[this.getArmorScale()];
        String text = "Add item";
        if (!this.buttonScale.field_146126_j.equals("1:1")) {
            text = text + " at " + this.buttonScale.field_146126_j + " scale";
        }
        this.buttonItemAdd.setHoverText(text);
    }

    @Override
    public void render(String text, int mouseX, int mouseY) {
        this.func_146279_a(text, mouseX, mouseY);
    }

    private static enum GlOperationListType {
        ARMOR_ITEM,
        GLOBAL_PRE,
        GLOBAL_POST;

    }
}

