/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.client.gui;

import com.google.common.collect.Lists;
import com.phylogeny.extrabitmanipulation.client.ClientHelper;
import com.phylogeny.extrabitmanipulation.client.gui.GuiBitMapping;
import com.phylogeny.extrabitmanipulation.client.gui.GuiListBitMappingEntry;
import com.phylogeny.extrabitmanipulation.item.ItemModelingTool;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mod.chiselsandbits.api.IBitBrush;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;

public class GuiListBitMapping
extends GuiListExtended {
    private final GuiBitMapping guiBitMapping;
    private final List<GuiListBitMappingEntry> entries = Lists.newArrayList();
    private boolean designMode;

    public GuiListBitMapping(GuiBitMapping guiModelingTool, int width, int height, int top, int bottom, int slotHeight, boolean designMode) {
        super(guiModelingTool.field_146297_k, width, height, top, bottom, slotHeight);
        this.guiBitMapping = guiModelingTool;
        ++this.field_148160_j;
        this.field_148152_e = guiModelingTool.getGuiLeft() + 18;
        this.field_148151_d = guiModelingTool.getGuiLeft() + 93;
        this.designMode = designMode;
    }

    public int func_148124_c(int posX, int posY) {
        int i = this.field_148152_e;
        int j = this.field_148152_e + this.field_148155_a / 2 + this.func_148139_c() / 2;
        int k = posY - this.field_148153_b - this.field_148160_j + (int)this.field_148169_q - 4;
        int l = k / this.field_148149_f;
        return posX < this.func_148137_d() && posX >= i && posX <= j && l >= 0 && k >= 0 && l < this.func_148127_b() ? l : -1;
    }

    public void refreshList(Map<IBlockState, IBitBrush> stateToBitMap, Map<IBlockState, IBitBrush> stateToBitMapPermanent, Map<IBlockState, ArrayList<ItemModelingTool.BitCount>> stateToBitCountArray, String searchText, boolean stateMode) {
        block3: {
            block2: {
                searchText = searchText.toLowerCase();
                this.entries.clear();
                if (this.designMode || stateToBitCountArray == null) break block2;
                for (Map.Entry<IBlockState, ArrayList<ItemModelingTool.BitCount>> entry : stateToBitCountArray.entrySet()) {
                    IBlockState state = entry.getKey();
                    if (this.searchTextMismatch(searchText, stateMode, state)) continue;
                    this.entries.add(new GuiListBitMappingEntry(this, state, entry.getValue(), stateToBitMapPermanent.containsKey(state), false));
                }
                break block3;
            }
            if (stateToBitMap == null) break block3;
            for (Map.Entry<IBlockState, IBitBrush> entry : stateToBitMap.entrySet()) {
                IBlockState state = entry.getKey();
                if (this.searchTextMismatch(searchText, stateMode, state)) continue;
                ArrayList<ItemModelingTool.BitCount> bitCountArray = new ArrayList<ItemModelingTool.BitCount>();
                bitCountArray.add(new ItemModelingTool.BitCount(entry.getValue(), this.designMode ? stateToBitCountArray.get(state).get(0).getCount() : 0));
                this.entries.add(new GuiListBitMappingEntry(this, state, bitCountArray, stateToBitMapPermanent.containsKey(state), true));
            }
        }
    }

    private boolean searchTextMismatch(String text, boolean stateMode, IBlockState state) {
        return !text.isEmpty() && (stateMode ? state : Block.field_149771_c.func_177774_c((Object)state.func_177230_c())).toString().toLowerCase().indexOf(text) < 0;
    }

    public void func_148128_a(int mouseXIn, int mouseYIn, float partialTicks) {
        if (!this.field_178041_q) {
            return;
        }
        this.field_148150_g = mouseXIn;
        this.field_148162_h = mouseYIn;
        this.func_148123_a();
        int i = this.func_148137_d();
        int j = i + 6;
        this.func_148121_k();
        GlStateManager.func_179140_f();
        GlStateManager.func_179106_n();
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        int k = this.field_148152_e + this.field_148155_a / 2 - this.func_148139_c() / 2 + 2;
        int l = this.field_148153_b + 4 - (int)this.field_148169_q;
        if (this.field_148165_u) {
            this.func_148129_a(k, l, tessellator);
        }
        this.func_148120_b(k, l, mouseXIn, mouseYIn);
        GlStateManager.func_179097_i();
        this.drawOverlays();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179118_c();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179090_x();
        int j1 = this.func_148135_f();
        if (j1 > 0) {
            int k1 = (this.field_148154_c - this.field_148153_b) * (this.field_148154_c - this.field_148153_b) / this.func_148138_e();
            int l1 = (int)this.field_148169_q * (this.field_148154_c - this.field_148153_b - (k1 = MathHelper.func_76125_a((int)k1, (int)32, (int)(this.field_148154_c - this.field_148153_b - 8)))) / j1 + this.field_148153_b;
            if (l1 < this.field_148153_b) {
                l1 = this.field_148153_b;
            }
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b((double)i, (double)(this.field_148154_c + 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buffer.func_181662_b((double)j, (double)(this.field_148154_c + 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buffer.func_181662_b((double)j, (double)(this.field_148153_b - 1), 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buffer.func_181662_b((double)i, (double)(this.field_148153_b - 1), 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            tessellator.func_78381_a();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b((double)(i + 1), (double)(l1 + k1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(139, 139, 139, 255).func_181675_d();
            buffer.func_181662_b((double)(j - 1), (double)(l1 + k1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(139, 139, 139, 255).func_181675_d();
            buffer.func_181662_b((double)(j - 1), (double)l1, 0.0).func_187315_a(1.0, 0.0).func_181669_b(139, 139, 139, 255).func_181675_d();
            buffer.func_181662_b((double)(i + 1), (double)l1, 0.0).func_187315_a(0.0, 0.0).func_181669_b(139, 139, 139, 255).func_181675_d();
            tessellator.func_78381_a();
        }
        this.func_148142_b(mouseXIn, mouseYIn);
        GlStateManager.func_179098_w();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179141_d();
        GlStateManager.func_179084_k();
    }

    protected void drawOverlays() {
        ClientHelper.bindTexture(GuiBitMapping.GUI_TEXTURE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int left = this.guiBitMapping.getGuiLeft() - 24;
        int top = this.guiBitMapping.getGuiTop();
        this.guiBitMapping.func_73729_b(left, top, 0, 0, 254, 21);
        int offsetY = 121;
        if (this.designMode) {
            this.guiBitMapping.func_73729_b(left + 24, top + offsetY, 24, offsetY, 230, 219 - offsetY);
        } else {
            this.guiBitMapping.func_73729_b(left, top + offsetY, 0, offsetY, 254, 219 - offsetY);
        }
    }

    public GuiListBitMappingEntry getListEntry(int index) {
        return this.entries.get(index);
    }

    protected int func_148127_b() {
        return this.entries.size();
    }

    protected int func_148137_d() {
        return this.guiBitMapping.getGuiLeft() + 85;
    }

    protected int func_148138_e() {
        return super.func_148138_e() - 25;
    }

    public int func_148139_c() {
        return 66;
    }

    protected boolean func_148131_a(int slotIndex) {
        return false;
    }

    public GuiBitMapping getGuiModelingTool() {
        return this.guiBitMapping;
    }
}

