/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.client.config;

import com.phylogeny.extrabitmanipulation.config.ConfigHandlerExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.config.ConfigNamed;
import com.phylogeny.extrabitmanipulation.config.ConfigShapeRender;
import com.phylogeny.extrabitmanipulation.reference.Configs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.config.DummyConfigElement;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.IConfigElement;

public class GuiConfigExtraBitManipulation
extends GuiConfig {
    public GuiConfigExtraBitManipulation(GuiScreen parentScreen) {
        super(parentScreen, GuiConfigExtraBitManipulation.getConfigElements(), "ExtraBitManipulation", false, false, GuiConfigExtraBitManipulation.getAbridgedConfigPath());
    }

    private static String getAbridgedConfigPath() {
        String path = GuiConfig.getAbridgedConfigPath((String)ConfigHandlerExtraBitManipulation.configFileClient.toString());
        return path.substring(0, path.lastIndexOf("/") + 1);
    }

    private static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> configElements = new ArrayList<IConfigElement>();
        ArrayList<IConfigElement> configElementsClient = new ArrayList<IConfigElement>();
        ArrayList<IConfigElement> configElementsServer = new ArrayList<IConfigElement>();
        ArrayList<IConfigElement> configElementsCommon = new ArrayList<IConfigElement>();
        GuiConfigExtraBitManipulation.addToolSettingsDummyElements(ConfigHandlerExtraBitManipulation.configFileClient, configElementsClient);
        GuiConfigExtraBitManipulation.addToolSettingsDummyElements(ConfigHandlerExtraBitManipulation.configFileServer, configElementsServer);
        GuiConfigExtraBitManipulation.addChildElementsToDummyElement(ConfigHandlerExtraBitManipulation.configFileServer, "Thrown Bit Properties", "Configures the damage amount, disabling of damage, entity burn time (for lava bits), velocity, and inaccuracy of thrown bits", configElementsServer, ServerEntry.class);
        ArrayList<IConfigElement> configElementsToolData = new ArrayList<IConfigElement>();
        String hoverText = "Configures @@@ data storage/access, default values, and chat notifications upon change. (applies to all tools -- see 'Item Properties' menu for item-specific settings)";
        GuiConfigExtraBitManipulation.addToolDataDummyElements(ConfigHandlerExtraBitManipulation.configFileClient, configElementsToolData, "Chiseled Armor", hoverText);
        GuiConfigExtraBitManipulation.addToolDataDummyElements(ConfigHandlerExtraBitManipulation.configFileClient, configElementsToolData, "Modeling Tool", hoverText);
        GuiConfigExtraBitManipulation.addToolDataDummyElements(ConfigHandlerExtraBitManipulation.configFileClient, configElementsToolData, "Sculpting Tool", hoverText);
        GuiConfigExtraBitManipulation.addElementsToDummyElement("Tool Data Settings", hoverText.replace("@@@", "Modeling Tool".toLowerCase() + " and " + "Sculpting Tool".toLowerCase()), configElementsClient, configElementsToolData, ClientEntry.class);
        GuiConfigExtraBitManipulation.addChildElementsToDummyElement(ConfigHandlerExtraBitManipulation.configFileCommon, "Thrown Bit Properties", "Configures the disabling of igniting/extinguishing entities/blocks when hit with thrown lava/water bits", configElementsCommon, CommonEntry.class);
        GuiConfigExtraBitManipulation.addDummyElementsOfProcessedChildElementSetsToDummyElement(ConfigHandlerExtraBitManipulation.configFileCommon, configElementsCommon, Configs.itemPropertyMap, "Item Properties", "Configures the damage characteristics and default data of the Bit Tools", CommonEntry.class);
        GuiConfigExtraBitManipulation.addDummyElementsOfProcessedChildElementSetsToDummyElement(ConfigHandlerExtraBitManipulation.configFileCommon, configElementsCommon, Configs.itemRecipeMap, "Recipes", "Configures the recipe for the Bit Tools and the disabling of diamond nugget recipes / Ore Dictionary registration", RecipeEntry.class);
        GuiConfigExtraBitManipulation.addDummyElementsOfProcessedChildElementSetsToDummyElement(ConfigHandlerExtraBitManipulation.configFileClient, configElementsClient, Configs.itemShapes, ClientEntry.class, "Bit Wrench Overlays", "Configures the way the Bit Wrench overlays are rendered", "Sculpting Tool Shapes", "Configures the Sculpting Tools' bit removal/addition shapes/boxes", "Rendering", "Configures the rendering of the Bit Wrench's overlays and the Sculpting Tools' bit removal/addition shapes/boxes");
        GuiConfigExtraBitManipulation.addElementsToDummyElement("Client", "Contains configs only accessed by the client", configElements, configElementsClient, null);
        GuiConfigExtraBitManipulation.addElementsToDummyElement("Server", "Contains configs only accessed by the server", configElements, configElementsServer, null);
        GuiConfigExtraBitManipulation.addElementsToDummyElement("Common", "Contains configs accessed by both the server and the client (problems will occur if these are not the same on both client and server)", configElements, configElementsCommon, null);
        return configElements;
    }

    private static void addToolSettingsDummyElements(Configuration configFile, List<IConfigElement> configElements) {
        Class configClass;
        ArrayList<IConfigElement> configElementsToolSettings = new ArrayList<IConfigElement>();
        boolean isClient = configFile.equals(ConfigHandlerExtraBitManipulation.configFileClient);
        Class clazz = configClass = isClient ? ClientEntry.class : ServerEntry.class;
        if (isClient) {
            GuiConfigExtraBitManipulation.addChildElementsToDummyElement(configFile, "Chiseled Armor Settings", "Configures the z-fighting buffer scale amount for Chiseled Armor pieces", configElementsToolSettings, configClass);
            ArrayList<IConfigElement> configElementsModelingTool = new ArrayList<IConfigElement>();
            String textStorage = "the the way block states are stored, and ";
            String textReplacementBits = "Configures" + textStorage + "the procedures for finding replacement bits ";
            String textUnchiselable = "when a blockstate is unchiselable";
            String textInsufficient = "when the player has insufficient bits for a chiselable blockstate";
            configElementsModelingTool.addAll(GuiConfigExtraBitManipulation.getChildElements(ConfigHandlerExtraBitManipulation.configFileClient, "Modeling Tool Settings"));
            GuiConfigExtraBitManipulation.addChildElementsToDummyElement(ConfigHandlerExtraBitManipulation.configFileClient, "Unchiselable Block States", textReplacementBits.replace(textStorage, " ") + textUnchiselable, configElementsModelingTool, ClientEntry.class);
            GuiConfigExtraBitManipulation.addChildElementsToDummyElement(ConfigHandlerExtraBitManipulation.configFileClient, "Insufficient Bits", textReplacementBits.replace(textStorage, " ") + textInsufficient, configElementsModelingTool, ClientEntry.class);
            GuiConfigExtraBitManipulation.addElementsToDummyElement("Modeling Tool Settings", textReplacementBits + textUnchiselable + " or " + textInsufficient, configElementsToolSettings, configElementsModelingTool, ClientEntry.class);
        }
        GuiConfigExtraBitManipulation.addChildElementsToDummyElement(configFile, "Sculpting & Wrech Settings", "Configures sculpting dimensions, wrench inversion mode, the way bits are handled when removed from the world, and the way bit removal/addition areas are displayed. (applies to all sculpting tools -- see 'Item Properties' menu for item-specific settings)", configElementsToolSettings, configClass);
        GuiConfigExtraBitManipulation.addElementsToDummyElement("Tool Settings", "Configures sculpting dimensions, wrench inversion mode, the way bits are handled when removed from the world, and the way bit removal/addition areas are displayed. (applies to all sculpting tools -- see 'Item Properties' menu for item-specific settings)" + (isClient ? ", as well as the way the Modeling Tool stores block states and finds replacement bits" : ""), configElements, configElementsToolSettings, configClass);
    }

    private static void addToolDataDummyElements(Configuration configFile, List<IConfigElement> configElementsToolData, String dataCatagory, String hoverText) {
        String dataCatagoryLower = dataCatagory.toLowerCase();
        ArrayList<IConfigElement> childElements = new ArrayList<IConfigElement>();
        String defaults = "Default Values";
        String storageLoc = "Per Tool or Per Client";
        String inChat = "Display In Chat";
        GuiConfigExtraBitManipulation.addChildElementsToDummyElement(configFile, defaults, defaults + " " + dataCatagory, "Configures " + dataCatagoryLower + " data default values.", childElements, ClientEntry.class);
        GuiConfigExtraBitManipulation.addChildElementsToDummyElement(configFile, storageLoc, storageLoc + " " + dataCatagory, "Configures whether " + dataCatagoryLower + " data is stored/assessed on/from individual tools or on/from the modeling data client config file.", childElements, ClientEntry.class);
        GuiConfigExtraBitManipulation.addChildElementsToDummyElement(configFile, inChat, inChat + " " + dataCatagory, "Configures whether changes to " + dataCatagoryLower + " data are displayed in chat.", childElements, ClientEntry.class);
        GuiConfigExtraBitManipulation.addElementsToDummyElement(dataCatagory + " Data Settings", hoverText.replace("@@@", dataCatagoryLower), configElementsToolData, childElements, ClientEntry.class);
    }

    private static void addDummyElementsOfProcessedChildElementSetsToDummyElement(Configuration configFile, List<IConfigElement> configElements, ConfigShapeRender[] config, Class configClass, String ... names) {
        ArrayList<IConfigElement> childElements = new ArrayList<IConfigElement>();
        int startLen = names.length;
        for (int i = 0; i < startLen - 4; i += 2) {
            GuiConfigExtraBitManipulation.addChildElementsToDummyElement(configFile, names[i], names[i + 1], childElements, configClass);
        }
        int endLen = config.length * 2 + 2;
        String[] processedNames = new String[endLen];
        for (int i = 0; i < endLen - 2; ++i) {
            int shapeIndex = i / 2;
            processedNames[i] = i % 2 == 0 ? config[shapeIndex].getTitle() : "Configures the color/alpha/line-width of the " + GuiConfigExtraBitManipulation.getInsertText(shapeIndex) + (shapeIndex < 2 ? " and the bounding box around the " + GuiConfigExtraBitManipulation.getInsertText(shapeIndex + 2) : "") + ", as well as which portions of it are rendered";
        }
        processedNames[endLen - 2] = names[startLen - 4];
        processedNames[endLen - 1] = names[startLen - 3];
        GuiConfigExtraBitManipulation.addDummyElementsOfChildElementSetsToDummyElement(configFile, childElements, configClass, processedNames);
        GuiConfigExtraBitManipulation.addElementsToDummyElement(names[startLen - 2], names[startLen - 1], configElements, childElements, configClass);
    }

    private static String getInsertText(int shapeIndex) {
        boolean removeBits = shapeIndex % 2 == 0;
        return (shapeIndex == 0 ? "Straight" : (shapeIndex == 1 ? "Flat" : "Curved")) + " Sculpting " + (removeBits ? "Wire's " : "Spade's ") + (shapeIndex > 1 ? "spherical/ellipsoidal" : "cubic/cuboidal") + " bit " + (removeBits ? "removal" : "addition") + " area";
    }

    private static void addDummyElementsOfProcessedChildElementSetsToDummyElement(Configuration configFile, List<IConfigElement> configElements, Map<Item, ConfigNamed> configs, String name, String toolTip, Class configClass) {
        boolean isRecipe;
        int len = configs.size();
        boolean bl = isRecipe = configClass == RecipeEntry.class;
        if (!isRecipe) {
            len *= 2;
        }
        String[] processedNames = new String[len += 2];
        int i = 0;
        for (Item item : configs.keySet()) {
            ConfigNamed config = configs.get(item);
            String itemTitle = config.getTitle();
            processedNames[i++] = itemTitle + (isRecipe ? " Recipe" : " Properties");
            if (isRecipe) continue;
            processedNames[i++] = "Configures the damage characteristics of the " + itemTitle;
        }
        processedNames[len - 2] = name;
        processedNames[len - 1] = toolTip;
        GuiConfigExtraBitManipulation.addDummyElementsOfChildElementSetsToDummyElement(configFile, configElements, configClass, processedNames);
    }

    private static void addDummyElementsOfChildElementSetsToDummyElement(Configuration configFile, List<IConfigElement> configElements, Class configClass, String ... names) {
        boolean isRecipe;
        ArrayList<IConfigElement> childElements = new ArrayList<IConfigElement>();
        int len = names.length;
        if (len < 2) {
            return;
        }
        boolean bl = isRecipe = configClass == RecipeEntry.class;
        if (isRecipe) {
            childElements.addAll(GuiConfigExtraBitManipulation.getChildElements(configFile, "Recipe Disable"));
        }
        int inc = isRecipe ? 1 : 2;
        for (int i = 0; i < names.length - 2; i += inc) {
            if (isRecipe) {
                GuiConfigExtraBitManipulation.addChildElementsToDummyElement(ConfigHandlerExtraBitManipulation.configFileCommon, names[i], "Configures the recipe type and configuration for the " + names[i], childElements, configClass);
                continue;
            }
            GuiConfigExtraBitManipulation.addChildElementsToDummyElement(configFile, names[i], names[i + 1], childElements, configClass);
        }
        GuiConfigExtraBitManipulation.addElementsToDummyElement(names[len - 2], names[len - 1], configElements, childElements, configClass);
    }

    private static void addElementsToDummyElement(String text, String toolTip, List<IConfigElement> configElements, List<IConfigElement> childElements, Class configClass) {
        DummyConfigElement.DummyCategoryElement dummyElement;
        if (configClass == null) {
            dummyElement = new DummyConfigElement.DummyCategoryElement(text, toolTip, childElements);
        } else {
            dummyElement = new DummyConfigElement.DummyCategoryElement(text, toolTip, childElements, configClass);
            if (configClass == RecipeEntry.class) {
                dummyElement.setRequiresMcRestart(true);
            }
        }
        configElements.add((IConfigElement)dummyElement);
    }

    private static void addChildElementsToDummyElement(Configuration configFile, String text, String toolTip, List<IConfigElement> configElements, Class configClass) {
        GuiConfigExtraBitManipulation.addChildElementsToDummyElement(configFile, text, text.toLowerCase(), toolTip, configElements, configClass);
    }

    private static void addChildElementsToDummyElement(Configuration configFile, String text, String catagory, String toolTip, List<IConfigElement> configElements, Class configClass) {
        GuiConfigExtraBitManipulation.addElementsToDummyElement(text, toolTip, configElements, GuiConfigExtraBitManipulation.getChildElements(configFile, catagory), configClass);
    }

    private static List<IConfigElement> getChildElements(Configuration configFile, String key) {
        return new ConfigElement(configFile.getCategory(key.toLowerCase())).getChildElements();
    }

    public static class RecipeEntry
    extends CommonEntry {
        public RecipeEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement prop) {
            super(owningScreen, owningEntryList, prop);
        }
    }

    public static class CommonEntry
    extends FileEntry {
        public CommonEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement prop) {
            super(owningScreen, owningEntryList, prop);
        }

        @Override
        protected String getFileName() {
            return "common";
        }
    }

    public static class ServerEntry
    extends FileEntry {
        public ServerEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement prop) {
            super(owningScreen, owningEntryList, prop);
        }

        @Override
        protected String getFileName() {
            return "server";
        }
    }

    public static class ClientEntry
    extends FileEntry {
        public ClientEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement prop) {
            super(owningScreen, owningEntryList, prop);
        }

        @Override
        protected String getFileName() {
            return "client";
        }
    }

    public static class FileEntry
    extends GuiConfigEntries.CategoryEntry {
        public FileEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement prop) {
            super(owningScreen, owningEntryList, prop);
        }

        protected String getFileName() {
            return "";
        }

        protected GuiScreen buildChildScreen() {
            if (this.owningScreen.title.endsWith("/")) {
                this.owningScreen.title = this.owningScreen.title + this.getFileName() + ".cfg";
            }
            return super.buildChildScreen();
        }
    }
}

