/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.armor;

import com.phylogeny.extrabitmanipulation.armor.ArmorItem;
import com.phylogeny.extrabitmanipulation.armor.GlOperation;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.item.ItemChiseledArmor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class DataChiseledArmorPiece {
    private List<GlOperation> globalGlOperationsPre = new ArrayList<GlOperation>();
    private List<GlOperation> globalGlOperationsPost = new ArrayList<GlOperation>();
    private List<ArmorItem>[] partItemLists;
    private ItemChiseledArmor.ArmorType armorType;

    public DataChiseledArmorPiece(ItemChiseledArmor.ArmorType armorType) {
        this.armorType = armorType;
        this.partItemLists = new ArrayList[armorType.getMovingpartCount()];
        for (int i = 0; i < this.partItemLists.length; ++i) {
            this.partItemLists[i] = new ArrayList<ArmorItem>();
        }
    }

    public DataChiseledArmorPiece(NBTTagCompound nbt, ItemChiseledArmor.ArmorType armorType) {
        this(armorType);
        this.loadFromNBT(nbt);
    }

    private List<GlOperation> getGlobalGlOperationsInternal(boolean isPre) {
        return isPre ? this.globalGlOperationsPre : this.globalGlOperationsPost;
    }

    public List<GlOperation> getGlobalGlOperations(boolean isPre) {
        ArrayList<GlOperation> glOperations = new ArrayList<GlOperation>();
        glOperations.addAll(this.getGlobalGlOperationsInternal(isPre));
        return glOperations;
    }

    public void addGlobalGlOperation(GlOperation glOperation, boolean isPre) {
        this.getGlobalGlOperationsInternal(isPre).add(glOperation);
    }

    public void addGlobalGlOperation(int index, GlOperation glOperation, boolean isPre) {
        this.getGlobalGlOperationsInternal(isPre).add(index, glOperation);
    }

    public void removeGlobalGlOperation(int index, boolean isPre) {
        this.getGlobalGlOperationsInternal(isPre).remove(index);
    }

    public void addItemToPart(int partIndex, ArmorItem armorItem) {
        if (this.outOfPartRange(partIndex)) {
            return;
        }
        this.partItemLists[partIndex].add(armorItem);
    }

    public void addItemToPart(int partIndex, int armorItemIndex, ArmorItem armorItem) {
        if (this.outOfPartRange(partIndex)) {
            return;
        }
        this.partItemLists[partIndex].add(armorItemIndex, armorItem);
    }

    public void removeItemFromPart(int partIndex, int armorItemIndex) {
        if (this.outOfPartRange(partIndex)) {
            return;
        }
        this.partItemLists[partIndex].remove(armorItemIndex);
    }

    public List<ArmorItem> getArmorItemsForPart(int partIndex) {
        ArrayList<ArmorItem> armorItems = new ArrayList<ArmorItem>();
        if (this.outOfPartRange(partIndex)) {
            return armorItems;
        }
        armorItems.addAll(this.partItemLists[partIndex]);
        return armorItems;
    }

    public ArmorItem getArmorItemForPart(int partIndex, int armorItemIndex) {
        return this.outOfPartRange(partIndex) ? new ArmorItem() : this.partItemLists[partIndex].get(armorItemIndex);
    }

    public int generateDisplayList(int partIndex, EntityLivingBase entity, float scale) {
        GlStateManager.func_179094_E();
        int displayList = GLAllocation.func_74526_a((int)1);
        GlStateManager.func_187423_f((int)displayList, (int)4864);
        GlOperation.executeList(this.globalGlOperationsPre);
        for (ArmorItem armorItem : this.partItemLists[partIndex]) {
            if (armorItem.isEmpty()) continue;
            GlStateManager.func_179094_E();
            armorItem.executeGlOperations();
            GlOperation.executeList(this.globalGlOperationsPost);
            armorItem.render(entity, scale, this.armorType == ItemChiseledArmor.ArmorType.BOOTS && partIndex == 0 || this.armorType == ItemChiseledArmor.ArmorType.LEGGINGS && partIndex == 1);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_187415_K();
        GlStateManager.func_179121_F();
        return displayList;
    }

    private boolean outOfPartRange(int partIndex) {
        return partIndex < 0 || partIndex >= this.partItemLists.length;
    }

    public void saveToNBT(NBTTagCompound nbt) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("type", this.armorType.ordinal());
        NBTTagList movingParts = new NBTTagList();
        boolean empty = true;
        for (List<ArmorItem> partItemList : this.partItemLists) {
            NBTTagList itemList = new NBTTagList();
            for (ArmorItem armorItem : partItemList) {
                NBTTagCompound armorItemNbt = new NBTTagCompound();
                armorItem.saveToNBT(armorItemNbt);
                itemList.func_74742_a((NBTBase)armorItemNbt);
                if (armorItem.getStack() == null) continue;
                empty = false;
            }
            movingParts.func_74742_a((NBTBase)itemList);
        }
        data.func_74782_a("partData", (NBTBase)movingParts);
        data.func_74757_a("notEmpty", !empty);
        GlOperation.saveListToNBT(data, "glOperationsPre", this.globalGlOperationsPre);
        GlOperation.saveListToNBT(data, "glOperationsPost", this.globalGlOperationsPost);
        nbt.func_74782_a("data", (NBTBase)data);
    }

    public void loadFromNBT(NBTTagCompound nbt) {
        NBTTagCompound data = ItemStackHelper.getArmorData(nbt);
        NBTTagList movingParts = data.func_150295_c("partData", 9);
        for (int i = 0; i < movingParts.func_74745_c(); ++i) {
            NBTBase nbtBase = movingParts.func_179238_g(i);
            if (nbtBase.func_74732_a() != 9) continue;
            this.partItemLists[i].clear();
            NBTTagList itemList = (NBTTagList)nbtBase;
            for (int j = 0; j < itemList.func_74745_c(); ++j) {
                this.partItemLists[i].add(new ArmorItem(itemList.func_150305_b(j)));
            }
        }
        GlOperation.loadListFromNBT(data, "glOperationsPre", this.globalGlOperationsPre);
        GlOperation.loadListFromNBT(data, "glOperationsPost", this.globalGlOperationsPost);
    }

    public static void setPartData(NBTTagCompound data, NBTTagList movingParts) {
        data.func_74782_a("partData", (NBTBase)movingParts);
        boolean empty = true;
        for (int i = 0; i < movingParts.func_74745_c(); ++i) {
            NBTBase nbtBase = movingParts.func_179238_g(i);
            if (nbtBase.func_74732_a() != 9) continue;
            NBTTagList itemList = (NBTTagList)nbtBase;
            for (int j = 0; j < itemList.func_74745_c(); ++j) {
                if (ItemStackHelper.loadStackFromNBT(itemList.func_150305_b(j), "armorItem") == null) continue;
                empty = false;
                break;
            }
            if (!empty) break;
        }
        data.func_74757_a("notEmpty", !empty);
    }
}

