/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.googlyeyes.common.helper;

import java.util.HashMap;
import java.util.Random;
import javax.annotation.Nullable;
import me.ichun.mods.googlyeyes.common.GooglyEyes;
import me.ichun.mods.googlyeyes.common.helper.HelperBat;
import me.ichun.mods.googlyeyes.common.helper.HelperBiped;
import me.ichun.mods.googlyeyes.common.helper.HelperDragon;
import me.ichun.mods.googlyeyes.common.helper.HelperEnderman;
import me.ichun.mods.googlyeyes.common.helper.HelperEndermite;
import me.ichun.mods.googlyeyes.common.helper.HelperGhast;
import me.ichun.mods.googlyeyes.common.helper.HelperGuardian;
import me.ichun.mods.googlyeyes.common.helper.HelperHorse;
import me.ichun.mods.googlyeyes.common.helper.HelperMagmaCube;
import me.ichun.mods.googlyeyes.common.helper.HelperOcelot;
import me.ichun.mods.googlyeyes.common.helper.HelperPigZombie;
import me.ichun.mods.googlyeyes.common.helper.HelperPlayer;
import me.ichun.mods.googlyeyes.common.helper.HelperRabbit;
import me.ichun.mods.googlyeyes.common.helper.HelperSheep;
import me.ichun.mods.googlyeyes.common.helper.HelperShulker;
import me.ichun.mods.googlyeyes.common.helper.HelperSilverfish;
import me.ichun.mods.googlyeyes.common.helper.HelperSlime;
import me.ichun.mods.googlyeyes.common.helper.HelperSpider;
import me.ichun.mods.googlyeyes.common.helper.HelperSquid;
import me.ichun.mods.googlyeyes.common.helper.HelperWither;
import me.ichun.mods.googlyeyes.common.helper.HelperWolf;
import me.ichun.mods.googlyeyes.common.helper.HelperZombie;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;

public class HelperBase<E extends EntityLivingBase> {
    public float[] headJoint = new float[3];
    public float[] eyeOffset = new float[]{0.0f, 0.25f, 0.25f};
    public float[] irisColour = new float[]{0.9f, 0.9f, 0.9f};
    public float[] pupilColour = new float[]{0.0f, 0.0f, 0.0f};
    public float halfInterpupillaryDistance = 0.125f;
    public float eyeScale = 0.75f;
    public Random livingRand = new Random();
    public int[] acidTime;
    public static HashMap<Class<? extends EntityLivingBase>, HelperBase> modelOffsetHelpers = new HashMap<Class<? extends EntityLivingBase>, HelperBase>(){
        {
            this.put(EntityPlayer.class, new HelperPlayer());
            this.put(EntityBat.class, new HelperBat());
            this.put(EntityBlaze.class, new HelperBase().setEyeOffset(0.0f, 0.0f, 0.25f));
            this.put(EntityChicken.class, new HelperBase().setHeadJoint(0.0f, -0.9375f, 0.25f).setEyeOffset(0.0f, 0.28125f, 0.125f).setHalfInterpupillaryDistance(0.09375f).setEyeScale(0.375f));
            this.put(EntityCow.class, new HelperBase().setHeadJoint(0.0f, -0.25f, 0.5f).setEyeOffset(0.0f, 0.0625f, 0.375f).setHalfInterpupillaryDistance(0.1875f));
            this.put(EntityCreeper.class, new HelperBase().setHeadJoint(0.0f, -0.375f, 0.0f).setEyeOffset(0.0f, 0.3125f, 0.25f));
            this.put(EntityDragon.class, new HelperDragon());
            this.put(EntityEnderman.class, new HelperEnderman());
            this.put(EntityEndermite.class, new HelperEndermite());
            this.put(EntityGhast.class, new HelperGhast());
            this.put(EntityGuardian.class, new HelperGuardian());
            this.put(EntityHorse.class, new HelperHorse());
            this.put(EntityIronGolem.class, new HelperBase().setHeadJoint(0.0f, 0.4375f, 0.125f).setEyeOffset(0.0f, 0.375f, 0.34375f));
            this.put(EntityMagmaCube.class, new HelperMagmaCube());
            this.put(EntityMooshroom.class, new HelperBase().setHeadJoint(0.0f, -0.25f, 0.5f).setEyeOffset(0.0f, 0.0625f, 0.375f).setHalfInterpupillaryDistance(0.1875f));
            this.put(EntityOcelot.class, new HelperOcelot());
            this.put(EntityPig.class, new HelperBase().setHeadJoint(0.0f, -0.75f, 0.375f).setEyeOffset(0.0f, 0.03125f, 0.5f).setHalfInterpupillaryDistance(0.1875f));
            this.put(EntityPigZombie.class, new HelperPigZombie());
            this.put(EntityPolarBear.class, new HelperBase().setHeadJoint(0.0f, -0.625f, 1.0f).setEyeOffset(0.0f, -0.03125f, 0.1875f).setEyeScale(0.4f));
            this.put(EntityRabbit.class, new HelperRabbit());
            this.put(EntitySheep.class, new HelperSheep());
            this.put(EntityShulker.class, new HelperShulker());
            this.put(EntitySilverfish.class, new HelperSilverfish());
            this.put(EntitySkeleton.class, new HelperBiped());
            this.put(EntitySlime.class, new HelperSlime());
            this.put(EntitySnowman.class, new HelperBase().setHeadJoint(0.0f, -0.25f, 0.0f).setEyeOffset(0.0f, 0.46875f, 0.3125f).setHalfInterpupillaryDistance(0.09375f).setEyeScale(1.0f));
            this.put(EntitySpider.class, new HelperSpider());
            this.put(EntitySquid.class, new HelperSquid());
            this.put(EntityVillager.class, new HelperBase().setEyeOffset(0.0f, 0.2f, 0.25f).setHalfInterpupillaryDistance(0.11875f).setEyeScale(0.7f));
            this.put(EntityWitch.class, new HelperBase().setEyeOffset(0.0f, 0.2f, 0.25f).setHalfInterpupillaryDistance(0.11875f).setEyeScale(0.7f));
            this.put(EntityWither.class, new HelperWither());
            this.put(EntityWolf.class, new HelperWolf());
            this.put(EntityZombie.class, new HelperZombie());
        }
    };

    public HelperBase setHeadJoint(float jointX, float jointY, float jointZ) {
        this.headJoint = new float[]{jointX, jointY, jointZ};
        return this;
    }

    public HelperBase setEyeOffset(float offsetX, float offsetY, float offsetZ) {
        this.eyeOffset = new float[]{offsetX, offsetY, offsetZ};
        return this;
    }

    public HelperBase setHalfInterpupillaryDistance(float dist) {
        this.halfInterpupillaryDistance = dist;
        return this;
    }

    public HelperBase setEyeScale(float scale) {
        this.eyeScale = scale;
        return this;
    }

    public float[] getHeadJointOffset(E living, float partialTick, int eye) {
        return this.headJoint;
    }

    public float[] getEyeOffsetFromJoint(E living, float partialTick, int eye) {
        return this.eyeOffset;
    }

    public int getEyeCount(E living) {
        return 2;
    }

    public float maxEyeSizeGrowth(E living, int eye) {
        return 0.0f;
    }

    public float getEyeSideOffset(E living, float partialTick, int eye) {
        return eye == 0 ? this.halfInterpupillaryDistance : -this.halfInterpupillaryDistance;
    }

    public float getEyeScale(E living, float partialTick, int eye) {
        return this.eyeScale;
    }

    public float getEyeRotation(E living, float partialTick, int eye) {
        return 0.0f;
    }

    public float getPupilScale(E living, float partialTick, int eye) {
        if (GooglyEyes.config.acidTripEyes == 1 || !living.func_70651_bq().isEmpty()) {
            this.livingRand.setSeed(Math.abs(living.hashCode()) * 1000);
            int eyeCount = this.getEyeCount(living);
            if (this.acidTime == null || this.acidTime.length < eyeCount) {
                this.acidTime = new int[eyeCount];
            }
            for (int i = 0; i < eyeCount; ++i) {
                this.acidTime[i] = 20 + this.livingRand.nextInt(20);
            }
            return 0.3f + ((float)Math.sin(Math.toRadians(((float)((EntityLivingBase)living).field_70173_aa + partialTick) / (float)this.acidTime[eye] * 360.0f)) + 1.0f) / 2.0f;
        }
        return 1.0f;
    }

    public float[] getIrisColours(E living, float partialTick, int eye) {
        return this.irisColour;
    }

    public float[] getPupilColours(E living, float partialTick, int eye) {
        return this.pupilColour;
    }

    public float getHeadYaw(E living, float partialTick, int eye) {
        return this.interpolateRotation(((EntityLivingBase)living).field_70758_at, ((EntityLivingBase)living).field_70759_as, partialTick) - this.interpolateRotation(((EntityLivingBase)living).field_70760_ar, ((EntityLivingBase)living).field_70761_aq, partialTick);
    }

    public float getHeadPitch(E living, float partialTick, int eye) {
        return this.interpolateRotation(((EntityLivingBase)living).field_70127_C, ((EntityLivingBase)living).field_70125_A, partialTick);
    }

    public float getHeadRoll(E living, float partialTick, int eye) {
        return 0.0f;
    }

    public boolean affectedByInvisibility(E living, int eye) {
        return true;
    }

    public boolean doesEyeGlow(E living, int eye) {
        return false;
    }

    public float getHeadYawForTracker(E living, int eye) {
        return this.getHeadYawForTracker(living);
    }

    public float getHeadPitchForTracker(E living, int eye) {
        return this.getHeadPitchForTracker(living);
    }

    public float getHeadYawForTracker(E living) {
        return ((EntityLivingBase)living).field_70759_as;
    }

    public float getHeadPitchForTracker(E living) {
        return ((EntityLivingBase)living).field_70125_A;
    }

    @Nullable
    public static HelperBase getHelperBase(Class<? extends EntityLivingBase> clz) {
        HelperBase helper = modelOffsetHelpers.get(clz);
        for (Class<? extends EntityLivingBase> clzz = clz.getSuperclass(); helper == null && clzz != EntityLivingBase.class; clzz = clzz.getSuperclass()) {
            helper = HelperBase.getHelperBase(clzz);
            if (helper == null) continue;
            modelOffsetHelpers.put(clzz, helper);
            break;
        }
        return helper;
    }

    public float interpolateRotation(float prevAngle, float nextAngle, float partialTick) {
        float f;
        for (f = nextAngle - prevAngle; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return prevAngle + partialTick * f;
    }
}

