/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.network;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import sonar.core.SonarCore;
import sonar.core.helpers.NBTHelper;
import sonar.flux.FluxNetworks;
import sonar.flux.api.network.IFluxCommon;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.connection.BasicFluxNetwork;
import sonar.flux.network.ClientNetworkCache;

public class PacketFluxNetworkList
implements IMessage {
    public ArrayList<? extends IFluxNetwork> networks;
    public boolean update;

    public PacketFluxNetworkList() {
    }

    public PacketFluxNetworkList(ArrayList<? extends IFluxNetwork> toSend, boolean update) {
        this.networks = toSend;
        this.update = update;
    }

    public void fromBytes(ByteBuf buf) {
        this.update = buf.readBoolean();
        NBTTagCompound compound = ByteBufUtils.readTag((ByteBuf)buf);
        NBTTagList list = compound.func_150295_c("nets", 10);
        ArrayList networks = Lists.newArrayList();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            BasicFluxNetwork net = (BasicFluxNetwork)NBTHelper.instanceNBTSyncable(BasicFluxNetwork.class, (NBTTagCompound)list.func_150305_b(i));
            UUID name = net.getOwnerUUID();
            if (name == null) continue;
            networks.add(net);
        }
        this.networks = networks;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.update);
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (IFluxCommon iFluxCommon : this.networks) {
            if (iFluxCommon == null || iFluxCommon.isFakeNetwork() || iFluxCommon.getNetworkID() == -1) continue;
            list.func_74742_a((NBTBase)iFluxCommon.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE));
        }
        tag.func_74782_a("nets", (NBTBase)list);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class Handler
    implements IMessageHandler<PacketFluxNetworkList, IMessage> {
        public IMessage onMessage(final PacketFluxNetworkList message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                SonarCore.proxy.getThreadListener(ctx).func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        ClientNetworkCache cache = FluxNetworks.getClientCache();
                        ConcurrentHashMap newNetworks = new ConcurrentHashMap();
                        message.networks.forEach((Consumer<? extends IFluxNetwork>)((Consumer<IFluxNetwork>)network -> {
                            if (network.getOwnerUUID() != null) {
                                newNetworks.putIfAbsent(network.getOwnerUUID(), Lists.newArrayList());
                                IFluxNetwork target = cache.getNetwork(network.getNetworkID());
                                if (target != null && target.getOwnerUUID() != null && target.getOwnerUUID().equals(network.getOwnerUUID())) {
                                    ((ArrayList)newNetworks.get(network.getOwnerUUID())).add(target.updateNetworkFrom((IFluxNetwork)network));
                                } else {
                                    ((ArrayList)newNetworks.get(network.getOwnerUUID())).add(network);
                                }
                            }
                        }));
                        if (!message.update) {
                            cache.networks = newNetworks;
                        }
                    }
                });
            }
            return null;
        }
    }
}

