/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.network;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.core.SonarCore;
import sonar.core.helpers.SonarHelper;
import sonar.core.network.PacketCoords;
import sonar.core.utils.CustomColour;
import sonar.flux.FluxNetworks;
import sonar.flux.api.FluxError;
import sonar.flux.api.network.IFluxCommon;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.api.network.PlayerAccess;
import sonar.flux.client.GuiTypeMessage;
import sonar.flux.common.ContainerFlux;
import sonar.flux.common.tileentity.TileEntityFlux;
import sonar.flux.connection.FluxHelper;
import sonar.flux.network.PacketFluxError;

public class PacketFluxButton
extends PacketCoords {
    public Type type;
    public Object[] objects;
    public int dimension;

    public PacketFluxButton() {
    }

    public PacketFluxButton(Type type, BlockPos pos, Object ... obj) {
        super(pos);
        this.type = type;
        this.objects = obj;
    }

    public PacketFluxButton(int dimension, Type type, BlockPos pos, Object ... obj) {
        super(pos);
        this.dimension = dimension;
        this.type = type;
        this.objects = obj;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.type = Type.getTypeFromID(buf.readInt());
        if (!this.type.local) {
            this.dimension = buf.readInt();
        }
        this.objects = this.type.fromBuf(buf);
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.type.id);
        if (!this.type.local) {
            buf.writeInt(this.dimension);
        }
        this.type.toBuf(buf, this.objects);
    }

    public static class Handler
    implements IMessageHandler<PacketFluxButton, IMessage> {
        public IMessage onMessage(final PacketFluxButton message, final MessageContext ctx) {
            SonarCore.proxy.getThreadListener(ctx).func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityPlayer player = SonarCore.proxy.getPlayerEntity(ctx);
                    if (player != null && player.func_130014_f_() != null) {
                        TileEntity te;
                        World world = player.func_130014_f_();
                        if (!message.type.local) {
                            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                            world = server.func_71218_a(message.dimension);
                        }
                        if ((te = world.func_175625_s(message.pos)) instanceof TileEntityFlux && message.objects != null) {
                            TileEntityFlux flux = (TileEntityFlux)te;
                            message.type.process(flux, player, message.objects);
                        }
                    }
                }
            });
            return null;
        }
    }

    public static enum Type {
        SET_NETWORK(0, true){

            @Override
            public void process(TileEntityFlux flux, EntityPlayer player, Object[] objs) {
                int networkID = (Integer)objs[0];
                if (flux.getNetwork().getNetworkID() == networkID) {
                    return;
                }
                IFluxNetwork network = FluxNetworks.getServerCache().getNetwork(networkID);
                if (!network.isFakeNetwork()) {
                    if (network.getPlayerAccess(player).canConnect()) {
                        flux.getNetwork().removeConnection(flux);
                        network.addConnection(flux);
                    } else {
                        FluxNetworks.network.sendTo((IMessage)new PacketFluxError(flux.func_174877_v(), FluxError.ACCESS_DENIED), (EntityPlayerMP)player);
                    }
                }
            }
        }
        ,
        CREATE_NETWORK(1, true){

            @Override
            public void process(TileEntityFlux flux, EntityPlayer player, Object[] objs) {
                String newName = (String)objs[0];
                CustomColour colour = (CustomColour)objs[1];
                IFluxCommon.AccessType access = (IFluxCommon.AccessType)((Object)objs[2]);
                if (flux.getNetwork().isFakeNetwork()) {
                    IFluxNetwork network = FluxNetworks.getServerCache().createNetwork(player, newName, colour, access);
                    flux.getNetwork().removeConnection(flux);
                    network.addConnection(flux);
                }
            }
        }
        ,
        EDIT_NETWORK(2, true){

            @Override
            public void process(TileEntityFlux flux, EntityPlayer player, Object[] objs) {
                int networkID = (Integer)objs[0];
                String newName = (String)objs[1];
                CustomColour colour = (CustomColour)objs[2];
                IFluxCommon.AccessType access = (IFluxCommon.AccessType)((Object)objs[3]);
                IFluxNetwork common = FluxNetworks.getServerCache().getNetwork(networkID);
                if (!common.isFakeNetwork()) {
                    if (common.getPlayerAccess(player).canEdit()) {
                        common.setNetworkName(newName);
                        common.setAccessType(access);
                        common.setCustomColour(colour);
                        common.markDirty();
                    } else {
                        FluxNetworks.network.sendTo((IMessage)new PacketFluxError(flux.func_174877_v(), FluxError.EDIT_NETWORK), (EntityPlayerMP)player);
                    }
                }
            }
        }
        ,
        DELETE_NETWORK(3, true){

            @Override
            public void process(TileEntityFlux flux, EntityPlayer player, Object[] objs) {
                int networkID = (Integer)objs[0];
                IFluxNetwork toDelete = FluxNetworks.getServerCache().getNetwork(networkID);
                if (!toDelete.isFakeNetwork() && toDelete instanceof IFluxNetwork) {
                    if (toDelete.getPlayerAccess(player).canDelete()) {
                        FluxNetworks.getServerCache().onPlayerRemoveNetwork(FluxHelper.getOwnerUUID(player), toDelete);
                    } else {
                        FluxNetworks.network.sendTo((IMessage)new PacketFluxError(flux.func_174877_v(), FluxError.NOT_OWNER), (EntityPlayerMP)player);
                    }
                }
            }
        }
        ,
        SET_PRIORITY(4, true){

            @Override
            public void process(TileEntityFlux flux, EntityPlayer player, Object[] objs) {
                int priority = (Integer)objs[0];
                flux.priority.setObject((Object)priority);
            }
        }
        ,
        SET_LIMIT(5, true){

            @Override
            public void process(TileEntityFlux flux, EntityPlayer player, Object[] objs) {
                long priority = ((Integer)objs[0]).intValue();
                flux.limit.setObject((Object)priority);
            }
        }
        ,
        CAN_CREATE(6, true){

            @Override
            public void process(TileEntityFlux flux, EntityPlayer player, Object[] objs) {
                ArrayList<IFluxNetwork> common = FluxNetworks.getServerCache().getAllNetworks();
                if (common != null) {
                    for (IFluxCommon iFluxCommon : common) {
                        if (!iFluxCommon.getNetworkName().equals((String)objs[0])) continue;
                    }
                }
            }
        }
        ,
        ADD_PLAYER(7, true){

            @Override
            public void process(TileEntityFlux flux, EntityPlayer player, Object[] objs) {
                int networkID = (Integer)objs[0];
                GameProfile profile = SonarHelper.getGameProfileForUsername((String)((String)objs[1]));
                if (profile == null || profile.getId() == null) {
                    FluxNetworks.network.sendTo((IMessage)new PacketFluxError(flux.func_174877_v(), FluxError.INVALID_USER), (EntityPlayerMP)player);
                    return;
                }
                UUID newPlayer = profile.getId();
                PlayerAccess access = (PlayerAccess)((Object)objs[2]);
                IFluxNetwork common = FluxNetworks.getServerCache().getNetwork(networkID);
                if (!common.isFakeNetwork() && common instanceof IFluxNetwork) {
                    if (common.getPlayerAccess(player).canEdit()) {
                        IFluxNetwork network = common;
                        network.addPlayerAccess(newPlayer, access);
                        network.markDirty();
                    } else {
                        FluxNetworks.network.sendTo((IMessage)new PacketFluxError(flux.func_174877_v(), FluxError.EDIT_NETWORK), (EntityPlayerMP)player);
                    }
                }
            }
        }
        ,
        REMOVE_PLAYER(8, true){

            @Override
            public void process(TileEntityFlux flux, EntityPlayer player, Object[] objs) {
                int networkID = (Integer)objs[0];
                UUID newPlayer = (UUID)objs[1];
                PlayerAccess access = (PlayerAccess)((Object)objs[2]);
                IFluxNetwork common = FluxNetworks.getServerCache().getNetwork(networkID);
                if (!common.isFakeNetwork() && common instanceof IFluxNetwork) {
                    if (common.getPlayerAccess(player).canEdit()) {
                        IFluxNetwork network = common;
                        network.removePlayerAccess(newPlayer, access);
                        network.markDirty();
                    } else {
                        FluxNetworks.network.sendTo((IMessage)new PacketFluxError(flux.func_174877_v(), FluxError.EDIT_NETWORK), (EntityPlayerMP)player);
                    }
                }
            }
        }
        ,
        CHANGE_PLAYER(9, true){

            @Override
            public void process(TileEntityFlux flux, EntityPlayer player, Object[] objs) {
                int networkID = (Integer)objs[0];
                UUID newPlayer = (UUID)objs[1];
                if (newPlayer != null) {
                    PlayerAccess access = (PlayerAccess)((Object)objs[2]);
                    IFluxNetwork common = FluxNetworks.getServerCache().getNetwork(networkID);
                    if (!common.isFakeNetwork() && common instanceof IFluxNetwork) {
                        if (common.getPlayerAccess(player).canEdit()) {
                            if (!FluxHelper.getOwnerUUID(player).equals(newPlayer)) {
                                IFluxNetwork network = common;
                                network.addPlayerAccess(newPlayer, access);
                                network.markDirty();
                            }
                        } else {
                            FluxNetworks.network.sendTo((IMessage)new PacketFluxError(flux.func_174877_v(), FluxError.EDIT_NETWORK), (EntityPlayerMP)player);
                        }
                    }
                } else {
                    FluxNetworks.network.sendTo((IMessage)new PacketFluxError(flux.func_174877_v(), FluxError.INVALID_USER), (EntityPlayerMP)player);
                }
            }
        }
        ,
        REMOVE_CONNECTION(10, true){

            @Override
            public void process(TileEntityFlux flux, EntityPlayer player, Object[] objs) {
                IFluxNetwork network = flux.getNetwork();
                if (((Integer)objs[0]).intValue() == network.getNetworkID() && network.getPlayerAccess(player).canConnect() && flux.playerUUID.getUUID().equals(FluxHelper.getOwnerUUID(player))) {
                    network.removeConnection(flux);
                }
            }
        }
        ,
        STATE_CHANGE(-1, true){

            @Override
            public void process(TileEntityFlux flux, EntityPlayer player, Object[] objs) {
                GuiTypeMessage state = (GuiTypeMessage)((Object)objs[0]);
                Container container = player.field_71070_bA;
                if (container != null && container instanceof ContainerFlux) {
                    ((ContainerFlux)container).switchState(state);
                }
            }
        };

        public int id;
        public boolean local;

        private Type(int id, boolean local) {
            this.id = id;
            this.local = local;
        }

        public static Type getTypeFromID(int id) {
            for (Type type : Type.values()) {
                if (type.id != id) continue;
                return type;
            }
            return null;
        }

        public Object[] fromBuf(ByteBuf buf) {
            Object[] objs = null;
            switch (this) {
                case SET_NETWORK: 
                case REMOVE_CONNECTION: 
                case DELETE_NETWORK: 
                case SET_PRIORITY: {
                    objs = new Object[]{buf.readInt()};
                    break;
                }
                case CREATE_NETWORK: {
                    objs = new Object[]{ByteBufUtils.readUTF8String((ByteBuf)buf), CustomColour.readFromBuf((ByteBuf)buf), IFluxCommon.AccessType.values()[buf.readInt()]};
                    break;
                }
                case EDIT_NETWORK: {
                    objs = new Object[]{buf.readInt(), ByteBufUtils.readUTF8String((ByteBuf)buf), CustomColour.readFromBuf((ByteBuf)buf), IFluxCommon.AccessType.values()[buf.readInt()]};
                    break;
                }
                case SET_LIMIT: {
                    objs = new Object[]{buf.readLong()};
                    break;
                }
                case STATE_CHANGE: {
                    objs = new Object[]{GuiTypeMessage.values()[buf.readInt()]};
                    break;
                }
                case ADD_PLAYER: {
                    objs = new Object[]{buf.readInt(), ByteBufUtils.readUTF8String((ByteBuf)buf), PlayerAccess.values()[buf.readByte()]};
                    break;
                }
                case REMOVE_PLAYER: 
                case CHANGE_PLAYER: {
                    objs = new Object[]{buf.readInt(), UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf)), PlayerAccess.values()[buf.readByte()]};
                    break;
                }
                default: {
                    objs = null;
                }
            }
            return objs;
        }

        public Object[] toBuf(ByteBuf buf, Object[] objs) {
            switch (this) {
                case SET_NETWORK: 
                case REMOVE_CONNECTION: 
                case DELETE_NETWORK: 
                case SET_PRIORITY: {
                    buf.writeInt(((Integer)objs[0]).intValue());
                    break;
                }
                case CREATE_NETWORK: {
                    ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((String)objs[0]));
                    CustomColour.writeToBuf((CustomColour)((CustomColour)objs[1]), (ByteBuf)buf);
                    buf.writeInt(((IFluxCommon.AccessType)((Object)objs[2])).ordinal());
                    break;
                }
                case EDIT_NETWORK: {
                    buf.writeInt(((Integer)objs[0]).intValue());
                    ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((String)objs[1]));
                    CustomColour.writeToBuf((CustomColour)((CustomColour)objs[2]), (ByteBuf)buf);
                    buf.writeInt(((IFluxCommon.AccessType)((Object)objs[3])).ordinal());
                    break;
                }
                case SET_LIMIT: {
                    buf.writeLong(((Long)objs[0]).longValue());
                    break;
                }
                case STATE_CHANGE: {
                    buf.writeInt(((GuiTypeMessage)((Object)objs[0])).ordinal());
                    break;
                }
                case ADD_PLAYER: {
                    buf.writeInt(((Integer)objs[0]).intValue());
                    ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((String)objs[1]));
                    buf.writeByte(((PlayerAccess)((Object)objs[2])).ordinal());
                    break;
                }
                case REMOVE_PLAYER: 
                case CHANGE_PLAYER: {
                    buf.writeInt(((Integer)objs[0]).intValue());
                    ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((UUID)objs[1]).toString());
                    buf.writeByte(((PlayerAccess)((Object)objs[2])).ordinal());
                    break;
                }
                default: {
                    objs = null;
                }
            }
            return objs;
        }

        public abstract void process(TileEntityFlux var1, EntityPlayer var2, Object[] var3);
    }
}

