/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.network;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.helpers.FunctionHelper;
import sonar.core.listener.ISonarListenable;
import sonar.core.listener.ListenableList;
import sonar.core.listener.ListenerTally;
import sonar.core.listener.PlayerListener;
import sonar.core.utils.CustomColour;
import sonar.flux.FluxEvents;
import sonar.flux.FluxNetworks;
import sonar.flux.api.FluxListener;
import sonar.flux.api.network.IFluxCommon;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.api.network.IFluxNetworkCache;
import sonar.flux.connection.BasicFluxNetwork;
import sonar.flux.connection.EmptyFluxNetwork;
import sonar.flux.connection.FluxHelper;
import sonar.flux.network.PacketFluxNetworkList;

public class FluxNetworkCache
implements IFluxNetworkCache,
ISonarListenable<PlayerListener> {
    public ListenableList<PlayerListener> listeners = new ListenableList((ISonarListenable)this, FluxListener.values().length);
    public ConcurrentHashMap<UUID, ArrayList<IFluxNetwork>> networks = new ConcurrentHashMap();
    public int uniqueID = 1;

    public static FluxNetworkCache instance() {
        return FluxNetworks.getServerCache();
    }

    public void clearNetworks() {
        this.networks.clear();
    }

    public int createNewUniqueID() {
        int id = this.uniqueID++;
        return id;
    }

    public IFluxNetwork forEachNetwork(Predicate<IFluxNetwork> found) {
        for (Map.Entry<UUID, ArrayList<IFluxNetwork>> entry : this.networks.entrySet()) {
            for (IFluxNetwork common : entry.getValue()) {
                if (!found.test(common)) continue;
                return common;
            }
        }
        return EmptyFluxNetwork.INSTANCE;
    }

    @Override
    public IFluxNetwork getNetwork(int iD) {
        return this.forEachNetwork(n -> !n.isFakeNetwork() && iD == n.getNetworkID());
    }

    @Override
    public ArrayList<IFluxNetwork> getAllNetworks() {
        ArrayList available = Lists.newArrayList();
        this.networks.values().forEach(l -> l.forEach(n -> available.add(n)));
        return available;
    }

    @Override
    public ArrayList<IFluxNetwork> getAllowedNetworks(EntityPlayer player, boolean admin) {
        ArrayList available = Lists.newArrayList();
        this.forEachNetwork(network -> {
            if (network.getPlayerAccess(player).canConnect()) {
                available.add(network);
            }
            return false;
        });
        return available;
    }

    public void addNetwork(IFluxNetwork network) {
        if (network.getOwnerUUID() != null) {
            this.networks.computeIfAbsent(network.getOwnerUUID(), FunctionHelper.ARRAY).add(network);
            this.updateNetworkList();
        }
    }

    public void removeNetwork(IFluxNetwork common) {
        if (common.getOwnerUUID() != null && this.networks.get(common.getOwnerUUID()) != null) {
            common.onRemoved();
            this.networks.get(common.getOwnerUUID()).remove(common);
            this.updateNetworkList();
        }
    }

    public IFluxNetwork createNetwork(EntityPlayer player, String name, CustomColour colour, IFluxCommon.AccessType access) {
        IFluxNetwork network2;
        UUID playerUUID = FluxHelper.getOwnerUUID(player);
        this.networks.putIfAbsent(playerUUID, Lists.newArrayList());
        for (IFluxNetwork network2 : (ArrayList)this.networks.get(playerUUID).clone()) {
            if (!network2.getNetworkName().equals(name)) continue;
            return network2;
        }
        int iD = this.createNewUniqueID();
        network2 = new BasicFluxNetwork(iD, playerUUID, name, colour, access);
        ((BasicFluxNetwork)network2).cachedOwnerName.setObject((Object)player.getDisplayNameString());
        this.addNetwork(network2);
        FluxEvents.logNewNetwork(network2);
        return network2;
    }

    public void onPlayerRemoveNetwork(UUID uuid, IFluxNetwork remove) {
        if (this.networks.get(uuid) != null) {
            this.removeNetwork(remove);
            FluxEvents.logRemoveNetwork(remove);
        }
    }

    public void updateNetworkList() {
        List players = this.listeners.getListeners(new Enum[]{FluxListener.SYNC_NETWORK});
        players.forEach(listener -> {
            ArrayList<IFluxNetwork> toSend = FluxNetworkCache.instance().getAllowedNetworks((EntityPlayer)listener.player, false);
            FluxNetworks.network.sendTo((IMessage)new PacketFluxNetworkList(toSend, false), listener.player);
        });
    }

    public boolean isValid() {
        return true;
    }

    public ListenableList<PlayerListener> getListenerList() {
        return this.listeners;
    }

    public void onListenerAdded(ListenerTally<PlayerListener> tally) {
    }

    public void onListenerRemoved(ListenerTally<PlayerListener> tally) {
    }

    public void onSubListenableAdded(ISonarListenable<PlayerListener> listen) {
    }

    public void onSubListenableRemoved(ISonarListenable<PlayerListener> listen) {
    }
}

