/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.common.tileentity;

import cofh.api.energy.IEnergyProvider;
import mekanism.api.energy.IStrictEnergyOutputter;
import net.darkhax.tesla.api.ITeslaProducer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;
import sonar.core.integration.SonarLoader;
import sonar.core.utils.IGuiTile;
import sonar.flux.api.tiles.IFlux;
import sonar.flux.api.tiles.IFluxPoint;
import sonar.flux.client.GuiFlux;
import sonar.flux.common.ContainerFlux;
import sonar.flux.common.tileentity.TileEntityFlux;

@Optional.InterfaceList(value={@Optional.Interface(iface="net.darkhax.tesla.api.ITeslaProducer", modid="tesla"), @Optional.Interface(iface="mekanism.api.energy.IStrictEnergyOutputter", modid="Mekanism")})
public class TileEntityPoint
extends TileEntityFlux
implements IGuiTile,
IEnergyProvider,
ITeslaProducer,
IStrictEnergyOutputter,
IEnergyStorage,
IFluxPoint {
    public TileEntityPoint() {
        super(IFlux.ConnectionType.POINT);
        this.customName.setDefault((Object)"Flux Point");
    }

    public Object getGuiContainer(EntityPlayer player) {
        return new ContainerFlux(player, this, false);
    }

    public Object getGuiScreen(EntityPlayer player) {
        return new GuiFlux((Container)this.getGuiContainer(player), this, player);
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return 0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (CapabilityEnergy.ENERGY == capability) {
            return true;
        }
        if (SonarLoader.teslaLoaded && capability == TeslaCapabilities.CAPABILITY_PRODUCER) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (CapabilityEnergy.ENERGY == capability) {
            return (T)this;
        }
        if (SonarLoader.teslaLoaded && capability == TeslaCapabilities.CAPABILITY_PRODUCER) {
            return (T)this;
        }
        return (T)super.getCapability(capability, facing);
    }

    public long takePower(long power, boolean simulated) {
        return this.extractEnergy(null, (int)Math.min(power, Integer.MAX_VALUE), simulated);
    }

    public double pullEnergy(EnumFacing side, double amount, boolean simulate) {
        return this.extractEnergy(side, (int)Math.min(amount, 2.147483647E9), simulate);
    }

    public boolean canOutputEnergy(EnumFacing dir) {
        return true;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.extractEnergy(null, Math.min(maxExtract, Integer.MAX_VALUE), simulate);
    }

    public int getEnergyStored() {
        return Integer.MAX_VALUE;
    }

    public int getMaxEnergyStored() {
        return Integer.MAX_VALUE;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }
}

