/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.client.states;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.text.TextFormatting;
import sonar.core.client.gui.SonarTextField;
import sonar.core.helpers.FontHelper;
import sonar.flux.api.network.EnergyStats;
import sonar.flux.api.network.INetworkStatistics;
import sonar.flux.api.tiles.IFlux;
import sonar.flux.client.GUI;
import sonar.flux.client.GuiFlux;
import sonar.flux.client.GuiState;
import sonar.flux.client.GuiTypeMessage;

public class GuiStateNetworkStats
extends GuiState {
    public GuiStateNetworkStats() {
        super(GuiTypeMessage.NETWORK_STATS, 176, 166, 192, "network.nav.statistics");
    }

    @Override
    public void draw(GuiFlux flux, int x, int y) {
        if (flux.disabledState) {
            flux.renderNavigationPrompt("No Statistics Available", "Network Selection");
            return;
        }
        flux.renderNetwork(flux.common.getNetworkName(), flux.common.getAccessType(), flux.common.getNetworkColour().getRGB(), true, 11, 8);
        int rgb = flux.common.getNetworkColour().getRGB();
        INetworkStatistics stats = flux.common.getStatistics();
        FontHelper.text((String)(TextFormatting.DARK_GRAY + GUI.PLUGS.toString() + TextFormatting.DARK_GRAY + ": " + TextFormatting.RESET + stats.getConnectionCount(IFlux.ConnectionType.PLUG)), (int)12, (int)26, (int)rgb);
        FontHelper.text((String)(TextFormatting.DARK_GRAY + GUI.POINTS.toString() + TextFormatting.DARK_GRAY + ": " + TextFormatting.RESET + stats.getConnectionCount(IFlux.ConnectionType.POINT)), (int)12, (int)38, (int)rgb);
        FontHelper.text((String)(TextFormatting.DARK_GRAY + GUI.STORAGE.toString() + TextFormatting.DARK_GRAY + ": " + TextFormatting.RESET + stats.getConnectionCount(IFlux.ConnectionType.STORAGE)), (int)12, (int)50, (int)rgb);
        EnergyStats energyStats = stats.getLatestStats();
        FontHelper.text((String)(TextFormatting.DARK_GRAY + GUI.MAX_SENT.toString() + TextFormatting.DARK_GRAY + ": " + TextFormatting.RESET + FontHelper.formatOutput((long)energyStats.maxSent)), (int)12, (int)62, (int)rgb);
        FontHelper.text((String)(TextFormatting.DARK_GRAY + GUI.MAX_RECEIVE.toString() + TextFormatting.DARK_GRAY + ": " + TextFormatting.RESET + FontHelper.formatOutput((long)energyStats.maxReceived)), (int)12, (int)74, (int)rgb);
        FontHelper.text((String)(TextFormatting.DARK_GRAY + GUI.TRANSFER.toString() + TextFormatting.DARK_GRAY + ": " + TextFormatting.RESET + FontHelper.formatOutput((long)energyStats.transfer)), (int)12, (int)86, (int)rgb);
        flux.renderEnergyBar(14, 120, flux.common.getEnergyAvailable(), flux.common.getMaxEnergyStored(), rgb, rgb);
        FontHelper.text((String)"Network Buffer ", (int)14, (int)110, (int)rgb);
    }

    @Override
    public void init(GuiFlux flux) {
        if (flux.common.isFakeNetwork()) {
            flux.disabledState = true;
        }
    }

    @Override
    public void button(GuiFlux flux, GuiButton button) {
    }

    @Override
    public void click(GuiFlux flux, int x, int y, int mouseButton) {
    }

    @Override
    public SonarTextField[] getFields(GuiFlux flux) {
        return new SonarTextField[0];
    }

    @Override
    public int getSelectionSize(GuiFlux flux) {
        return 0;
    }
}

