/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.overrides;

import net.minecraft.item.ItemStack;
import oreexcavation.core.ExcavationSettings;
import oreexcavation.groups.ItemEntry;

public class ToolOverride {
    public static final ToolOverride DEFAULT = ToolOverride.readFromString("*");
    private ItemEntry itemType;
    private int speed = 64;
    private int limit = 128;
    private int range = 16;
    private float exaustion = 0.1f;
    private int experience = 0;

    private ToolOverride(ItemEntry itemType) {
        this.itemType = itemType;
        this.speed = ExcavationSettings.mineSpeed;
        this.limit = ExcavationSettings.mineLimit;
        this.range = ExcavationSettings.mineRange;
        this.exaustion = ExcavationSettings.exaustion;
        this.experience = ExcavationSettings.experience;
    }

    public boolean isApplicable(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return this.itemType.checkMatch(stack);
    }

    public void setSpeed(int value) {
        this.speed = value;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setLimit(int value) {
        this.limit = value;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setRange(int value) {
        this.range = value;
    }

    public int getRange() {
        return this.range;
    }

    public void setExaustion(float value) {
        this.exaustion = value;
    }

    public float getExaustion() {
        return this.exaustion;
    }

    public void setExperience(int value) {
        this.experience = value;
    }

    public int getExperience() {
        return this.experience;
    }

    public static ToolOverride readFromString(String s) {
        ItemEntry entry = ItemEntry.readFromString(s);
        if (entry == null) {
            return null;
        }
        return new ToolOverride(entry);
    }
}

