/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WeakIdentityHashMap<K, V>
implements Map<K, V> {
    private final ReferenceQueue<K> queue = new ReferenceQueue();
    private final Map<IdentityWeakReference, V> delegate;

    public WeakIdentityHashMap(int expectedMaxSize, float loadFactor) {
        this.delegate = new HashMap<IdentityWeakReference, V>(expectedMaxSize, loadFactor);
    }

    public WeakIdentityHashMap(int expectedMaxSize) {
        this.delegate = new HashMap<IdentityWeakReference, V>(expectedMaxSize);
    }

    public WeakIdentityHashMap() {
        this.delegate = new HashMap<IdentityWeakReference, V>();
    }

    @Override
    public int size() {
        this.reap();
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        this.reap();
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.reap();
        return this.delegate.containsKey(new IdentityWeakReference(key));
    }

    @Override
    public boolean containsValue(Object value) {
        this.reap();
        return this.delegate.containsValue(value);
    }

    @Override
    public V get(Object key) {
        this.reap();
        return this.delegate.get(new IdentityWeakReference(key));
    }

    @Override
    public V put(K key, V value) {
        return this.delegate.put(new IdentityWeakReference(key), value);
    }

    @Override
    public V remove(Object key) {
        this.reap();
        return this.delegate.remove(new IdentityWeakReference(key));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.delegate.clear();
        this.reap();
    }

    @Override
    public Set<K> keySet() {
        this.reap();
        return new AbstractSet<K>(){

            @Override
            public int size() {
                WeakIdentityHashMap.this.reap();
                return WeakIdentityHashMap.this.delegate.size();
            }

            @Override
            public Iterator<K> iterator() {
                WeakIdentityHashMap.this.reap();
                final Iterator iter = WeakIdentityHashMap.this.delegate.keySet().iterator();
                return new Iterator<K>(){

                    @Override
                    public boolean hasNext() {
                        return iter.hasNext();
                    }

                    @Override
                    public K next() {
                        return ((IdentityWeakReference)iter.next()).get();
                    }

                    @Override
                    public void remove() {
                        iter.remove();
                    }
                };
            }

            @Override
            public void clear() {
                WeakIdentityHashMap.this.delegate.clear();
                WeakIdentityHashMap.this.reap();
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public int size() {
                WeakIdentityHashMap.this.reap();
                return WeakIdentityHashMap.this.delegate.size();
            }

            @Override
            public boolean contains(Object o) {
                WeakIdentityHashMap.this.reap();
                return WeakIdentityHashMap.this.containsValue(o);
            }

            @Override
            public Iterator<V> iterator() {
                WeakIdentityHashMap.this.reap();
                return WeakIdentityHashMap.this.delegate.values().iterator();
            }

            @Override
            public void clear() {
                WeakIdentityHashMap.this.delegate.clear();
                WeakIdentityHashMap.this.reap();
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.reap();
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public int size() {
                WeakIdentityHashMap.this.reap();
                return WeakIdentityHashMap.this.delegate.size();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                WeakIdentityHashMap.this.reap();
                final Iterator iter = WeakIdentityHashMap.this.delegate.entrySet().iterator();
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return iter.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        final Map.Entry entry = (Map.Entry)iter.next();
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return ((IdentityWeakReference)entry.getKey()).get();
                            }

                            @Override
                            public V getValue() {
                                return entry.getValue();
                            }

                            @Override
                            public V setValue(V value) {
                                return WeakIdentityHashMap.this.delegate.put(entry.getKey(), value);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        iter.remove();
                    }
                };
            }

            @Override
            public void clear() {
                WeakIdentityHashMap.this.delegate.clear();
                WeakIdentityHashMap.this.reap();
            }
        };
    }

    public String toString() {
        this.reap();
        return this.delegate.toString();
    }

    private synchronized void reap() {
        Reference<K> zombie;
        while ((zombie = this.queue.poll()) != null) {
            this.delegate.remove(zombie);
        }
    }

    private class IdentityWeakReference
    extends WeakReference<K> {
        private final int hash;

        public IdentityWeakReference(K obj) {
            super(obj, WeakIdentityHashMap.this.queue);
            this.hash = System.identityHashCode(obj);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof IdentityWeakReference && ((IdentityWeakReference)obj).get() == this.get();
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }
}

