/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server.jingle;

import com.google.common.collect.Sets;
import com.pau101.fairylights.server.fastener.connection.type.hanginglights.Light;
import com.pau101.fairylights.server.jingle.Jingle;
import com.pau101.fairylights.server.jingle.JingleLibrary;
import com.pau101.fairylights.server.sound.FLSounds;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public final class JinglePlayer {
    private static final Set<String> WITH_LOVE = Sets.newHashSet((Object[])new String[]{"my_anthem", "im_fine_thank_you"});
    @Nullable
    private JingleLibrary library;
    @Nullable
    private Jingle jingle;
    @Nullable
    private List<Jingle.PlayTick> playTicks;
    private int length;
    private int lightOffset;
    private boolean isPlaying;
    private int currentTickIndex;
    private int rest;
    private int timePassed;
    private EnumParticleTypes[] noteParticle;

    @Nullable
    public Jingle getJingle() {
        return this.jingle;
    }

    public void start(JingleLibrary library, Jingle jingle, int lightOffset) {
        this.library = library;
        this.jingle = jingle;
        this.lightOffset = lightOffset;
        this.isPlaying = true;
        this.currentTickIndex = 0;
        this.rest = 0;
        this.timePassed = 0;
        this.init();
    }

    private void init() {
        this.playTicks = this.jingle.getPlayTicks();
        this.length = 0;
        for (Jingle.PlayTick playTick : this.playTicks) {
            this.length += playTick.getLength();
        }
        this.noteParticle = "playing_with_fire".equals(this.jingle.getId()) ? new EnumParticleTypes[]{EnumParticleTypes.NOTE, EnumParticleTypes.LAVA} : (WITH_LOVE.contains(this.jingle.getId()) ? new EnumParticleTypes[]{EnumParticleTypes.NOTE, EnumParticleTypes.HEART} : new EnumParticleTypes[]{EnumParticleTypes.NOTE});
    }

    private void stop() {
        this.library = null;
        this.jingle = null;
        this.lightOffset = 0;
        this.playTicks = null;
        this.length = 0;
        this.isPlaying = false;
        this.currentTickIndex = 0;
        this.rest = 0;
        this.timePassed = 0;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public float getProgress() {
        return this.isPlaying ? (float)this.timePassed / (float)this.length : 0.0f;
    }

    public void tick(World world, Vec3d origin, Light[] lights, boolean isClient) {
        ++this.timePassed;
        if (this.rest <= 0) {
            if (this.currentTickIndex >= this.playTicks.size()) {
                this.stop();
            } else {
                Jingle.PlayTick playTick = this.playTicks.get(this.currentTickIndex++);
                this.rest = playTick.getLength() - 1;
                if (isClient) {
                    this.play(world, origin, lights, playTick);
                }
            }
        } else {
            --this.rest;
        }
    }

    private void play(World world, Vec3d origin, Light[] lights, Jingle.PlayTick playTick) {
        for (int note : playTick.getNotes()) {
            int idx = note - this.jingle.getLowestNote() + this.lightOffset;
            if (idx < 0 || idx >= lights.length) continue;
            lights[idx].jingle(world, origin, note, FLSounds.JINGLE_BELL, this.noteParticle);
        }
    }

    public NBTTagCompound serialize() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.jingle != null) {
            compound.func_74768_a("library", this.library.getId());
            compound.func_74778_a("jingle", this.jingle.getId());
            compound.func_74768_a("lightOffset", this.lightOffset);
            compound.func_74757_a("isPlaying", this.isPlaying);
            compound.func_74768_a("currentTickIndex", this.currentTickIndex);
            compound.func_74768_a("rest", this.rest);
            compound.func_74768_a("timePassed", this.timePassed);
        }
        return compound;
    }

    public void deserialize(NBTTagCompound compound) {
        this.stop();
        boolean isPlaying = compound.func_74767_n("isPlaying");
        if (!isPlaying) {
            return;
        }
        JingleLibrary library = JingleLibrary.fromId(compound.func_74762_e("library"));
        if (library == null) {
            return;
        }
        Jingle jingle = library.get(compound.func_74779_i("jingle"));
        if (jingle == null) {
            return;
        }
        this.library = library;
        this.jingle = jingle;
        this.isPlaying = isPlaying;
        this.lightOffset = compound.func_74762_e("lightOffset");
        this.currentTickIndex = compound.func_74762_e("currentTickIndex");
        this.rest = compound.func_74762_e("rest");
        this.timePassed = compound.func_74762_e("timePassed");
        this.init();
    }
}

