/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.client.model.connection;

import com.pau101.fairylights.client.ClientProxy;
import com.pau101.fairylights.client.model.AdvancedModelRenderer;
import com.pau101.fairylights.client.model.connection.ModelConnection;
import com.pau101.fairylights.client.renderer.FastenerRenderer;
import com.pau101.fairylights.server.fastener.Fastener;
import com.pau101.fairylights.server.fastener.connection.type.letter.ConnectionLetterBunting;
import com.pau101.fairylights.server.fastener.connection.type.letter.Letter;
import com.pau101.fairylights.util.Mth;
import com.pau101.fairylights.util.styledstring.StyledString;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ModelConnectionLetterBunting
extends ModelConnection<ConnectionLetterBunting> {
    private static final ResourceLocation LETTERS = new ResourceLocation("fairylights", "textures/entity/letters.png");
    private AdvancedModelRenderer cordModel = new AdvancedModelRenderer(this, 0, 17);

    public ModelConnectionLetterBunting() {
        this.cordModel.addBox(-0.5f, -0.5f, 0.0f, 1, 1, 1);
        this.cordModel.scaleX = 0.9f;
        this.cordModel.scaleY = 0.9f;
    }

    @Override
    public boolean hasTexturedRender() {
        return true;
    }

    @Override
    public void renderTexturePass(Fastener<?> fastener, ConnectionLetterBunting letterBunting, World world, int skylight, int moonlight, float delta) {
        Letter[] letters = letterBunting.getLetters();
        Letter[] prevLetters = letterBunting.getPrevLetters();
        GlStateManager.func_179129_p();
        GlStateManager.func_179108_z();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(LETTERS);
        int count = Math.min(letters.length, prevLetters.length);
        for (int i = 0; i < count; ++i) {
            Letter letter = letters[i];
            if (Character.isWhitespace(letter.getLetter())) continue;
            Vec3d point = Mth.lerp(prevLetters[i].getPoint(), letter.getPoint(), delta);
            Vec3d rotation = letter.getRotation(delta);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(point.field_72450_a / 16.0), (double)(point.field_72448_b / 16.0), (double)(point.field_72449_c / 16.0));
            GlStateManager.func_179114_b((float)((float)rotation.field_72450_a * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)rotation.field_72448_b * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)rotation.field_72449_c * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
            int rgb = StyledString.getColor(ClientProxy.recoloredFont, letterBunting.getText().colorAt(i));
            GlStateManager.func_179124_c((float)((float)(rgb >> 16 & 0xFF) / 255.0f), (float)((float)(rgb >> 8 & 0xFF) / 255.0f), (float)((float)(rgb & 0xFF) / 255.0f));
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.2f);
            GlStateManager.func_179137_b((double)(-letter.getWidth() / 2.0), (double)((float)(-letter.getSymbolHeight()) / 16.0f + 0.03125f), (double)0.03125);
            FastenerRenderer.render3DTexture(letter.getSymbolWidth(), letter.getSymbolHeight(), letter.getU(), letter.getV(), 64, 64);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179089_o();
        GlStateManager.func_179133_A();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    protected void renderSegment(ConnectionLetterBunting connection, int index, double angleX, double angleY, double length, double x, double y, double z, float delta) {
        this.cordModel.field_78795_f = (float)angleX;
        this.cordModel.field_78796_g = (float)angleY;
        this.cordModel.scaleZ = (float)length;
        this.cordModel.setRotationPoint(x, y, z);
        this.cordModel.func_78785_a(0.0625f);
    }
}

