/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.tileentities;

import com.pam.harvestcraft.blocks.BlockRegistry;
import com.pam.harvestcraft.item.ItemRegistry;
import java.util.Random;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class TileEntityGroundTrap
extends TileEntity
implements IInventory,
ITickable {
    private ItemStack[] inventory = new ItemStack[19];
    public int runTime = 0;
    public int currentBeeRunTime = 0;
    public int produceTime = 0;

    public String func_70005_c_() {
        return "GroundTrap";
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList tagList = compound.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound stackTag = tagList.func_150305_b(i);
            byte slot = stackTag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)stackTag);
        }
        this.runTime = compound.func_74765_d("RunTime");
        this.produceTime = compound.func_74765_d("ProduceTime");
        this.currentBeeRunTime = this.getRunTime(this.inventory[1]);
    }

    @MethodsReturnNonnullByDefault
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74777_a("RunTime", (short)this.runTime);
        compound.func_74777_a("ProduceTime", (short)this.produceTime);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(stackTag);
            tagList.func_74742_a((NBTBase)stackTag);
        }
        compound.func_74782_a("Items", (NBTBase)tagList);
        return compound;
    }

    public int countFlowers() {
        int radius = 2;
        int count = 0;
        World world = this.field_145850_b;
        int varX = this.field_174879_c.func_177958_n();
        int varY = this.field_174879_c.func_177956_o();
        int varZ = this.field_174879_c.func_177952_p();
        for (int offsetX = -radius; offsetX <= radius; ++offsetX) {
            for (int offsetZ = -radius; offsetZ <= radius; ++offsetZ) {
                Block blockAtCoords;
                if (offsetX * offsetX + offsetZ * offsetZ > radius * radius || offsetX == -(radius - 1) && offsetZ == -(radius - 1) || offsetX == radius - 1 && offsetZ == radius - 1 || offsetX == radius - 1 && offsetZ == -(radius - 1) || offsetX == -(radius - 1) && offsetZ == radius - 1 || !((blockAtCoords = world.func_180495_p(new BlockPos(varX + offsetX, varY, varZ + offsetZ)).func_177230_c()) instanceof BlockDirt) && !(blockAtCoords instanceof BlockGrass)) continue;
                ++count;
            }
        }
        return count;
    }

    public void func_73660_a() {
        boolean isRunning = this.runTime > 0;
        boolean needsUpdate = false;
        if (isRunning) {
            --this.runTime;
        }
        ItemStack queenBee = this.inventory[18];
        if (!this.field_145850_b.field_72995_K) {
            if (this.runTime == 0 && this.canRun()) {
                this.currentBeeRunTime = this.runTime = this.getRunTime(queenBee);
                if (this.runTime > 0) {
                    needsUpdate = true;
                    if (queenBee != null) {
                        if (queenBee.func_77973_b().func_77668_q() != null) {
                            queenBee = new ItemStack(queenBee.func_77973_b().func_77664_n());
                        } else if (queenBee.field_77994_a > 0) {
                            queenBee.field_77994_a -= 0;
                        }
                        if (queenBee.field_77994_a == 0) {
                            queenBee = null;
                        }
                    }
                }
            }
            if (this.canRun()) {
                ++this.produceTime;
                if ((double)this.produceTime >= Math.floor(this.getRunTime())) {
                    this.produceTime = 0;
                    this.run();
                    needsUpdate = true;
                }
            } else {
                this.produceTime = 0;
            }
            if (isRunning != this.runTime > 0) {
                needsUpdate = true;
            }
        }
        if (needsUpdate) {
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.func_174877_v()), this.field_145850_b.func_180495_p(this.func_174877_v()), 3);
        }
    }

    private boolean canRun() {
        if (this.inventory[18] != null) {
            return (this.inventory[18].func_77973_b() == ItemRegistry.grainbaitItem || this.inventory[18].func_77973_b() == ItemRegistry.fruitbaitItem || this.inventory[18].func_77973_b() == ItemRegistry.veggiebaitItem) && this.countFlowers() >= 5;
        }
        return false;
    }

    public void run() {
        ItemStack itemProduced = this.getComb();
        for (int i = 0; i < 18; ++i) {
            if (this.inventory[i] != null) continue;
            this.func_70298_a(18, 1);
            this.inventory[i] = itemProduced.func_77946_l();
            break;
        }
    }

    public ItemStack getComb() {
        Random rnd = new Random();
        if (this.inventory[18] != null) {
            int rndnum;
            if (this.inventory[18].func_77973_b() == ItemRegistry.grainbaitItem) {
                rndnum = rnd.nextInt(11);
                switch (rndnum) {
                    case 0: {
                        return new ItemStack(ItemRegistry.turkeyrawItem, 1, 0);
                    }
                    case 1: {
                        return new ItemStack(Items.field_151082_bd, 1, 0);
                    }
                    case 2: {
                        return new ItemStack(Items.field_151076_bf, 1, 0);
                    }
                    case 3: {
                        return new ItemStack(Items.field_151116_aA, 1, 0);
                    }
                    case 4: {
                        return new ItemStack(Items.field_151008_G, 1, 0);
                    }
                    case 5: {
                        return new ItemStack(Items.field_151110_aK, 1, 0);
                    }
                    case 6: {
                        return new ItemStack(Items.field_151103_aS, 1, 0);
                    }
                    case 7: {
                        return new ItemStack(Items.field_151076_bf, 1, 0);
                    }
                    case 8: {
                        return new ItemStack(Items.field_151076_bf, 1, 0);
                    }
                    case 9: {
                        return new ItemStack(ItemRegistry.turkeyrawItem, 1, 0);
                    }
                    case 10: {
                        return new ItemStack(Items.field_151008_G, 1, 0);
                    }
                }
            }
            if (this.inventory[18].func_77973_b() == ItemRegistry.fruitbaitItem) {
                rndnum = rnd.nextInt(11);
                switch (rndnum) {
                    case 0: {
                        return new ItemStack(Items.field_179558_bo, 1, 0);
                    }
                    case 1: {
                        return new ItemStack(Items.field_151116_aA, 1, 0);
                    }
                    case 2: {
                        return new ItemStack(Items.field_151008_G, 1, 0);
                    }
                    case 3: {
                        return new ItemStack(Items.field_151110_aK, 1, 0);
                    }
                    case 4: {
                        return new ItemStack(Items.field_151103_aS, 1, 0);
                    }
                    case 5: {
                        return new ItemStack(Items.field_179556_br, 1, 0);
                    }
                    case 6: {
                        return new ItemStack(Items.field_179555_bs, 1, 0);
                    }
                    case 7: {
                        return new ItemStack(Items.field_151076_bf, 1, 0);
                    }
                    case 8: {
                        return new ItemStack(Items.field_151076_bf, 1, 0);
                    }
                    case 9: {
                        return new ItemStack(Items.field_151076_bf, 1, 0);
                    }
                    case 10: {
                        return new ItemStack(Items.field_151008_G, 1, 0);
                    }
                }
            }
            if (this.inventory[18].func_77973_b() == ItemRegistry.veggiebaitItem) {
                rndnum = rnd.nextInt(11);
                switch (rndnum) {
                    case 0: {
                        return new ItemStack(ItemRegistry.venisonrawItem, 1, 0);
                    }
                    case 1: {
                        return new ItemStack(Items.field_179561_bm, 1, 0);
                    }
                    case 2: {
                        return new ItemStack(Items.field_151147_al, 1, 0);
                    }
                    case 3: {
                        return new ItemStack(Items.field_151116_aA, 1, 0);
                    }
                    case 4: {
                        return new ItemStack(Items.field_151008_G, 1, 0);
                    }
                    case 5: {
                        return new ItemStack(Items.field_151110_aK, 1, 0);
                    }
                    case 6: {
                        return new ItemStack(Items.field_151103_aS, 1, 0);
                    }
                    case 7: {
                        return new ItemStack(Items.field_151076_bf, 1, 0);
                    }
                    case 8: {
                        return new ItemStack(Items.field_151076_bf, 1, 0);
                    }
                    case 9: {
                        return new ItemStack(Items.field_151076_bf, 1, 0);
                    }
                    case 10: {
                        return new ItemStack(Items.field_151008_G, 1, 0);
                    }
                }
            }
        }
        return null;
    }

    int getRunTime(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        if (stack.func_77973_b() == ItemRegistry.grainbaitItem || stack.func_77973_b() == ItemRegistry.fruitbaitItem || stack.func_77973_b() == ItemRegistry.veggiebaitItem) {
            return 3200;
        }
        return 0;
    }

    private int getRunTime() {
        int radius = 2;
        World world = this.field_145850_b;
        int varX = this.field_174879_c.func_177958_n();
        int varY = this.field_174879_c.func_177956_o();
        int varZ = this.field_174879_c.func_177952_p();
        int speed = 3500;
        for (int offsetX = -2; offsetX <= 2; ++offsetX) {
            for (int offsetZ = -2; offsetZ <= 2; ++offsetZ) {
                if (offsetX * offsetX + offsetZ * offsetZ > 4 || offsetX == -3 && offsetZ == -3 || offsetX == 1 && offsetZ == 1 || offsetX == 1 && offsetZ == -3 || offsetX == -3 && offsetZ == 1) continue;
                Block blockAtCoords = world.func_180495_p(new BlockPos(varX + offsetX, varY, varZ + offsetZ)).func_177230_c();
                if (blockAtCoords instanceof BlockDirt || blockAtCoords instanceof BlockGrass) {
                    speed = (int)((double)speed * 0.95);
                }
                if (blockAtCoords != BlockRegistry.groundtrap) continue;
                speed = (int)((double)speed / 0.85);
            }
        }
        return speed;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.inventory[index] == null) {
            this.func_70299_a(index, null);
            return null;
        }
        if (this.inventory[index].field_77994_a <= count) {
            ItemStack stack = this.inventory[index];
            this.func_70299_a(index, null);
            return stack;
        }
        ItemStack stack = this.inventory[index].func_77979_a(count);
        if (this.inventory[index].field_77994_a <= 0) {
            this.func_70299_a(index, null);
        }
        this.func_70296_d();
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.func_174877_v()) != this) {
            return false;
        }
        return player.func_174818_b(this.func_174877_v()) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }
}

