/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockBucketWheel;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBucketWheel
extends TileEntityMultiblockPart<TileEntityBucketWheel>
implements IEBlockInterfaces.IHasObjProperty,
IEBlockInterfaces.IDynamicTexture {
    public float rotation = 0.0f;
    public ItemStack[] digStacks = new ItemStack[8];
    public boolean active = false;
    public ItemStack particleStack;
    private static final int[] size = new int[]{7, 1, 7};
    static ArrayList<String> emptyDisplayList = new ArrayList();
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;

    public TileEntityBucketWheel() {
        super(size);
    }

    @Override
    public ItemStack getOriginalBlock() {
        if (this.field_174879_c < 0) {
            return null;
        }
        ItemStack s = this.field_174879_c < 0 ? null : MultiblockBucketWheel.instance.getStructureManual()[this.field_174879_c / 7][this.field_174879_c % 7][0];
        return s != null ? s.func_77946_l() : null;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        float nbtRot = nbt.func_74760_g("rotation");
        this.rotation = (double)Math.abs(nbtRot - this.rotation) > 5.0 * Config.IEConfig.Machines.excavator_speed ? nbtRot : this.rotation;
        this.digStacks = Utils.readInventory(nbt.func_150295_c("digStacks", 10), 8);
        this.active = nbt.func_74767_n("active");
        this.particleStack = nbt.func_74764_b("particleStack") ? ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("particleStack")) : null;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74776_a("rotation", this.rotation);
        nbt.func_74782_a("digStacks", (NBTBase)Utils.writeInventory(this.digStacks));
        nbt.func_74757_a("active", this.active);
        if (this.particleStack != null) {
            nbt.func_74782_a("particleStack", (NBTBase)this.particleStack.func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        return new IFluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resources) {
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return false;
    }

    public void func_73660_a() {
        if (!this.formed || this.field_174879_c != 24) {
            return;
        }
        if (this.active) {
            this.rotation = (float)((double)this.rotation + Config.IEConfig.Machines.excavator_speed);
            this.rotation %= 360.0f;
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.particleStack != null) {
                ImmersiveEngineering.proxy.spawnBucketWheelFX(this, this.particleStack);
                this.particleStack = null;
            }
        } else if (this.active && this.field_145850_b.func_82737_E() % 20L == 0L) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74776_a("rotation", this.rotation);
            MessageTileSync sync = new MessageTileSync(this, nbt);
            ImmersiveEngineering.packetHandler.sendToAllAround((IMessage)sync, new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 100.0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SideOnly(value=Side.CLIENT)
    public HashMap<String, String> getTextureReplacements() {
        ItemStack[] itemStackArray = this.digStacks;
        synchronized (this.digStacks) {
            HashMap<String, String> texMap = new HashMap<String, String>();
            for (int i = 0; i < this.digStacks.length; ++i) {
                if (this.digStacks[i] == null) continue;
                Block b = Block.func_149634_a((Item)this.digStacks[i].func_77973_b());
                IBlockState state = b != null ? b.func_176203_a(this.digStacks[i].func_77960_j()) : Blocks.field_150348_b.func_176223_P();
                IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
                if (model == null || model.func_177554_e() == null) continue;
                texMap.put("dig" + i, model.func_177554_e().func_94215_i());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return texMap;
        }
    }

    @Override
    public ArrayList<String> compileDisplayList() {
        return emptyDisplayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveMessageFromServer(NBTTagCompound message) {
        ItemStack[] itemStackArray = this.digStacks;
        synchronized (this.digStacks) {
            int packetRotation;
            if (message.func_74764_b("fill")) {
                this.digStacks[message.func_74762_e((String)"fill")] = ItemStack.func_77949_a((NBTTagCompound)message.func_74775_l("fillStack"));
            }
            if (message.func_74764_b("empty")) {
                this.digStacks[message.func_74762_e((String)"empty")] = null;
            }
            if (message.func_74764_b("rotation") && (double)Math.abs((float)(packetRotation = message.func_74762_e("rotation")) - this.rotation) > 5.0 * Config.IEConfig.Machines.excavator_speed) {
                this.rotation = packetRotation;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.active = arg == 1;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = new AxisAlignedBB(this.func_174877_v().func_177982_a(-(this.facing.func_176740_k() == EnumFacing.Axis.Z ? 3 : 0), -3, -(this.facing.func_176740_k() == EnumFacing.Axis.X ? 3 : 0)), this.func_174877_v().func_177982_a(this.facing.func_176740_k() == EnumFacing.Axis.Z ? 4 : 1, 4, this.facing.func_176740_k() == EnumFacing.Axis.X ? 4 : 1));
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return super.func_145833_n() * Config.IEConfig.increasedTileRenderdistance;
    }

    @Override
    public float[] getBlockBounds() {
        if (this.field_174879_c == 3 || this.field_174879_c == 9 || this.field_174879_c == 11) {
            return new float[]{0.0f, 0.25f, 0.0f, 1.0f, 1.0f, 1.0f};
        }
        if (this.field_174879_c == 45 || this.field_174879_c == 37 || this.field_174879_c == 39) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f};
        }
        if (this.field_174879_c == 21) {
            return new float[]{this.facing == EnumFacing.NORTH ? 0.25f : 0.0f, 0.0f, this.facing == EnumFacing.WEST ? 0.25f : 0.0f, this.facing == EnumFacing.SOUTH ? 0.75f : 1.0f, 1.0f, this.facing == EnumFacing.EAST ? 0.75f : 1.0f};
        }
        if (this.field_174879_c == 27) {
            return new float[]{this.facing == EnumFacing.SOUTH ? 0.25f : 0.0f, 0.0f, this.facing == EnumFacing.EAST ? 0.25f : 0.0f, this.facing == EnumFacing.NORTH ? 0.75f : 1.0f, 1.0f, this.facing == EnumFacing.WEST ? 0.75f : 1.0f};
        }
        if (this.field_174879_c == 15 || this.field_174879_c == 29) {
            return new float[]{this.facing == EnumFacing.NORTH ? 0.25f : 0.0f, 0.0f, this.facing == EnumFacing.WEST ? 0.25f : 0.0f, this.facing == EnumFacing.SOUTH ? 0.75f : 1.0f, 1.0f, this.facing == EnumFacing.EAST ? 0.75f : 1.0f};
        }
        if (this.field_174879_c == 19 || this.field_174879_c == 33) {
            return new float[]{this.facing == EnumFacing.SOUTH ? 0.25f : 0.0f, 0.0f, this.facing == EnumFacing.EAST ? 0.25f : 0.0f, this.facing == EnumFacing.NORTH ? 0.75f : 1.0f, 1.0f, this.facing == EnumFacing.WEST ? 0.75f : 1.0f};
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }
}

