/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.client.models.SmartLightingQuad;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.util.IEFluid;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import blusunrize.immersiveengineering.common.util.sound.IETileSound;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.vecmath.Quat4d;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockSign;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Timer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public class ClientUtils {
    public static final AxisAlignedBB standardBlockAABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    static HashMap<String, ResourceLocation> resourceMap = new HashMap();
    public static TextureAtlasSprite[] destroyBlockIcons = new TextureAtlasSprite[10];
    static int[] chatColours = new int[]{0, 170, 43520, 43690, 0xAA0000, 0xAA00AA, 0xFFAA00, 0xAAAAAA, 0x555555, 0x5555FF, 0x55FF55, 0x55FFFF, 0xFF5555, 0xFF55FF, 0xFFFF55, 0xFFFFFF};
    private static final Vector3f fadingOffset = new Vector3f(1.0E-4f, 1.0E-4f, 1.0E-4f);
    private static float[] alphaFirst2Fading = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
    private static float[] alphaNoFading = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private static final float[][] quadCoords = new float[4][3];
    private static final Vector3f side1 = new Vector3f();
    private static final Vector3f side2 = new Vector3f();
    private static final Vector3f normal = new Vector3f();
    private static final int[][] neighbourBrightness = new int[2][6];
    private static final float[][] normalizationFactors = new float[2][8];

    public static void tessellateConnection(ImmersiveNetHandler.Connection connection, IImmersiveConnectable start, IImmersiveConnectable end, TextureAtlasSprite sprite) {
        if (connection == null || start == null || end == null) {
            return;
        }
        int col = connection.cableType.getColour(connection);
        double r = connection.cableType.getRenderDiameter() / 2.0;
        int[] rgba = new int[]{col >> 16 & 0xFF, col >> 8 & 0xFF, col & 0xFF, 255};
        ClientUtils.tessellateConnection(connection, start, end, rgba, r, sprite);
    }

    public static void tessellateConnection(ImmersiveNetHandler.Connection connection, IImmersiveConnectable start, IImmersiveConnectable end, int[] rgba, double radius, TextureAtlasSprite sprite) {
        if (connection == null || start == null || end == null || connection.end == null || connection.start == null) {
            return;
        }
        Vec3d startOffset = start.getConnectionOffset(connection);
        Vec3d endOffset = end.getConnectionOffset(connection);
        if (startOffset == null) {
            startOffset = new Vec3d(0.5, 0.5, 0.5);
        }
        if (endOffset == null) {
            endOffset = new Vec3d(0.5, 0.5, 0.5);
        }
        double dx = (double)connection.end.func_177958_n() + endOffset.field_72450_a - ((double)connection.start.func_177958_n() + startOffset.field_72450_a);
        double dy = (double)connection.end.func_177956_o() + endOffset.field_72448_b - ((double)connection.start.func_177956_o() + startOffset.field_72448_b);
        double dz = (double)connection.end.func_177952_p() + endOffset.field_72449_c - ((double)connection.start.func_177952_p() + startOffset.field_72449_c);
        double dw = Math.sqrt(dx * dx + dz * dz);
        double d = Math.sqrt(dx * dx + dy * dy + dz * dz);
        World world = ((TileEntity)start).func_145831_w();
        Tessellator tes = ClientUtils.tes();
        double rmodx = dz / dw;
        double rmodz = dx / dw;
        Vec3d[] vertex = connection.getSubVertices(world);
        Vec3d initPos = new Vec3d(startOffset.field_72450_a, startOffset.field_72448_b, startOffset.field_72449_c);
        double uMin = sprite.func_94209_e();
        double uMax = sprite.func_94212_f();
        double vMin = sprite.func_94206_g();
        double vMax = sprite.func_94210_h();
        double uD = uMax - uMin;
        boolean vertical = connection.end.func_177958_n() == connection.start.func_177958_n() && connection.end.func_177952_p() == connection.start.func_177952_p();
        boolean b = dx < 0.0 && dz <= 0.0 || dz < 0.0 && dx <= 0.0 || dz < 0.0 && dx > 0.0;
        VertexBuffer worldrenderer = tes.func_178180_c();
        if (vertical) {
            worldrenderer.func_178969_c(initPos.field_72450_a, initPos.field_72448_b, initPos.field_72449_c);
            worldrenderer.func_181662_b(0.0 - radius, 0.0, 0.0).func_187315_a(uMin, vMin).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
            worldrenderer.func_181662_b(dx - radius, dy, dz).func_187315_a(uMax, vMin).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
            worldrenderer.func_181662_b(dx + radius, dy, dz).func_187315_a(uMax, vMax).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
            worldrenderer.func_181662_b(0.0 + radius, 0.0, 0.0).func_187315_a(uMin, vMax).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
            worldrenderer.func_181662_b(dx - radius, dy, dz).func_187315_a(uMax, vMin).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
            worldrenderer.func_181662_b(0.0 - radius, 0.0, 0.0).func_187315_a(uMin, vMin).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
            worldrenderer.func_181662_b(0.0 + radius, 0.0, 0.0).func_187315_a(uMin, vMax).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
            worldrenderer.func_181662_b(dx + radius, dy, dz).func_187315_a(uMax, vMax).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
            worldrenderer.func_181662_b(0.0, 0.0, 0.0 - radius).func_187315_a(uMin, vMin).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
            worldrenderer.func_181662_b(dx, dy, dz - radius).func_187315_a(uMax, vMin).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
            worldrenderer.func_181662_b(dx, dy, dz + radius).func_187315_a(uMax, vMax).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
            worldrenderer.func_181662_b(0.0, 0.0, 0.0 + radius).func_187315_a(uMin, vMax).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
            worldrenderer.func_181662_b(dx, dy, dz - radius).func_187315_a(uMax, vMin).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
            worldrenderer.func_181662_b(0.0, 0.0, 0.0 - radius).func_187315_a(uMin, vMin).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
            worldrenderer.func_181662_b(0.0, 0.0, 0.0 + radius).func_187315_a(uMin, vMax).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
            worldrenderer.func_181662_b(dx, dy, dz + radius).func_187315_a(uMax, vMax).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
            worldrenderer.func_178969_c(0.0, 0.0, 0.0);
        } else {
            int i;
            double u0 = uMin;
            double u1 = uMin;
            int n = i = b ? vertex.length - 1 : 0;
            while (b ? i >= 0 : i < vertex.length) {
                Vec3d v0 = i > 0 ? vertex[i - 1].func_178786_a((double)connection.start.func_177958_n(), (double)connection.start.func_177956_o(), (double)connection.start.func_177952_p()) : initPos;
                Vec3d v1 = vertex[i].func_178786_a((double)connection.start.func_177958_n(), (double)connection.start.func_177956_o(), (double)connection.start.func_177952_p());
                u0 = u1;
                u1 = u0 + v0.func_72438_d(v1) / d * uD;
                if (dx < 0.0 && dz <= 0.0 || dz < 0.0 && dx <= 0.0 || dz < 0.0 && dx > 0.0) {
                    u1 = uMin;
                    u0 = uMax;
                }
                worldrenderer.func_181662_b(v0.field_72450_a, v0.field_72448_b + radius, v0.field_72449_c).func_187315_a(u0, vMax).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
                worldrenderer.func_181662_b(v1.field_72450_a, v1.field_72448_b + radius, v1.field_72449_c).func_187315_a(u1, vMax).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
                worldrenderer.func_181662_b(v1.field_72450_a, v1.field_72448_b - radius, v1.field_72449_c).func_187315_a(u1, vMin).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
                worldrenderer.func_181662_b(v0.field_72450_a, v0.field_72448_b - radius, v0.field_72449_c).func_187315_a(u0, vMin).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
                worldrenderer.func_181662_b(v1.field_72450_a, v1.field_72448_b + radius, v1.field_72449_c).func_187315_a(u1, vMax).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
                worldrenderer.func_181662_b(v0.field_72450_a, v0.field_72448_b + radius, v0.field_72449_c).func_187315_a(u0, vMax).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
                worldrenderer.func_181662_b(v0.field_72450_a, v0.field_72448_b - radius, v0.field_72449_c).func_187315_a(u0, vMin).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
                worldrenderer.func_181662_b(v1.field_72450_a, v1.field_72448_b - radius, v1.field_72449_c).func_187315_a(u1, vMin).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
                worldrenderer.func_181662_b(v0.field_72450_a - radius * rmodx, v0.field_72448_b, v0.field_72449_c + radius * rmodz).func_187315_a(u0, vMax).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
                worldrenderer.func_181662_b(v1.field_72450_a - radius * rmodx, v1.field_72448_b, v1.field_72449_c + radius * rmodz).func_187315_a(u1, vMax).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
                worldrenderer.func_181662_b(v1.field_72450_a + radius * rmodx, v1.field_72448_b, v1.field_72449_c - radius * rmodz).func_187315_a(u1, vMin).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
                worldrenderer.func_181662_b(v0.field_72450_a + radius * rmodx, v0.field_72448_b, v0.field_72449_c - radius * rmodz).func_187315_a(u0, vMin).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
                worldrenderer.func_181662_b(v1.field_72450_a - radius * rmodx, v1.field_72448_b, v1.field_72449_c + radius * rmodz).func_187315_a(u1, vMax).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
                worldrenderer.func_181662_b(v0.field_72450_a - radius * rmodx, v0.field_72448_b, v0.field_72449_c + radius * rmodz).func_187315_a(u0, vMax).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
                worldrenderer.func_181662_b(v0.field_72450_a + radius * rmodx, v0.field_72448_b, v0.field_72449_c - radius * rmodz).func_187315_a(u0, vMin).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
                worldrenderer.func_181662_b(v1.field_72450_a + radius * rmodx, v1.field_72448_b, v1.field_72449_c - radius * rmodz).func_187315_a(u1, vMin).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_181675_d();
                i += b ? -1 : 1;
            }
        }
    }

    public static Tessellator tes() {
        return Tessellator.func_178181_a();
    }

    public static Minecraft mc() {
        return Minecraft.func_71410_x();
    }

    public static void bindTexture(String path) {
        ClientUtils.mc().func_110434_K().func_110577_a(ClientUtils.getResource(path));
    }

    public static void bindAtlas() {
        ClientUtils.mc().func_110434_K().func_110577_a(TextureMap.field_110575_b);
    }

    public static ResourceLocation getResource(String path) {
        ResourceLocation rl;
        ResourceLocation resourceLocation = rl = resourceMap.containsKey(path) ? resourceMap.get(path) : new ResourceLocation(path);
        if (!resourceMap.containsKey(path)) {
            resourceMap.put(path, rl);
        }
        return rl;
    }

    public static TextureAtlasSprite getSprite(ResourceLocation rl) {
        return ClientUtils.mc().func_147117_R().func_110572_b(rl.toString());
    }

    public static FontRenderer font() {
        return ClientUtils.mc().field_71466_p;
    }

    public static Timer timer() {
        return ClientUtils.mc().field_71428_T;
    }

    public static String fomatTimestamp(long timestamp, TimestampFormat format) {
        String s = "";
        for (TimestampFormat core : TimestampFormat.coreValues) {
            if (!format.containsFormat(core) || timestamp < core.getTickCut()) continue;
            s = s + I18n.func_135052_a((String)("desc.immersiveengineering.info." + core.getLocalKey()), (Object[])new Object[]{Long.toString(timestamp / core.getTickCut())});
            timestamp %= core.getTickCut();
        }
        if (s.isEmpty()) {
            for (int i = TimestampFormat.coreValues.length - 1; i >= 0; --i) {
                if (!format.containsFormat(TimestampFormat.coreValues[i])) continue;
                s = I18n.func_135052_a((String)("desc.immersiveengineering.info." + TimestampFormat.coreValues[i].getLocalKey()), (Object[])new Object[]{0});
                break;
            }
        }
        return s;
    }

    public static int getFormattingColour(TextFormatting rarityColor) {
        return rarityColor.ordinal() < 16 ? chatColours[rarityColor.ordinal()] : 0;
    }

    public static int getDarkenedTextColour(int colour) {
        int r = (colour >> 16 & 0xFF) / 4;
        int g = (colour >> 8 & 0xFF) / 4;
        int b = (colour & 0xFF) / 4;
        return r << 16 | g << 8 | b;
    }

    public static IETileSound generatePositionedIESound(SoundEvent soundEvent, float volume, float pitch, boolean repeat, int delay, BlockPos pos) {
        IETileSound sound = new IETileSound(soundEvent, volume, pitch, repeat, delay, pos, ISound.AttenuationType.LINEAR, SoundCategory.BLOCKS);
        ClientUtils.mc().func_147118_V().func_147682_a((ISound)sound);
        return sound;
    }

    public static ModelRenderer[] copyModelRenderers(ModelBase model, ModelRenderer ... oldRenderers) {
        ModelRenderer[] newRenderers = new ModelRenderer[oldRenderers.length];
        for (int i = 0; i < newRenderers.length; ++i) {
            if (oldRenderers[i] == null) continue;
            newRenderers[i] = new ModelRenderer(model, oldRenderers[i].field_78802_n);
            int toX = oldRenderers[i].field_78803_o;
            int toY = oldRenderers[i].field_78813_p;
            newRenderers[i].func_78784_a(toX, toY);
            newRenderers[i].field_78809_i = oldRenderers[i].field_78809_i;
            ArrayList<ModelBox> newCubes = new ArrayList<ModelBox>();
            for (ModelBox cube : oldRenderers[i].field_78804_l) {
                newCubes.add(new ModelBox(newRenderers[i], toX, toY, cube.field_78252_a, cube.field_78250_b, cube.field_78251_c, (int)(cube.field_78248_d - cube.field_78252_a), (int)(cube.field_78249_e - cube.field_78250_b), (int)(cube.field_78246_f - cube.field_78251_c), 0.0f));
            }
            newRenderers[i].field_78804_l = newCubes;
            newRenderers[i].func_78793_a(oldRenderers[i].field_78800_c, oldRenderers[i].field_78797_d, oldRenderers[i].field_78798_e);
            newRenderers[i].field_78795_f = oldRenderers[i].field_78795_f;
            newRenderers[i].field_78796_g = oldRenderers[i].field_78796_g;
            newRenderers[i].field_78808_h = oldRenderers[i].field_78808_h;
            newRenderers[i].field_82906_o = oldRenderers[i].field_82906_o;
            newRenderers[i].field_82908_p = oldRenderers[i].field_82908_p;
            newRenderers[i].field_82907_q = oldRenderers[i].field_82907_q;
        }
        return newRenderers;
    }

    public static void drawBlockDamageTexture(Tessellator tessellatorIn, VertexBuffer worldRendererIn, Entity entityIn, float partialTicks, World world, Collection<BlockPos> blocks) {
        double d0 = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        double d1 = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        double d2 = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        TextureManager renderEngine = Minecraft.func_71410_x().field_71446_o;
        int progress = (int)(Minecraft.func_71410_x().field_71442_b.field_78770_f * 10.0f) - 1;
        if (progress < 0) {
            return;
        }
        renderEngine.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179120_a((int)774, (int)768, (int)1, (int)0);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GlStateManager.func_179136_a((float)-3.0f, (float)-3.0f);
        GlStateManager.func_179088_q();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179141_d();
        GlStateManager.func_179094_E();
        worldRendererIn.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        worldRendererIn.func_178969_c(-d0, -d1, -d2);
        for (BlockPos blockpos : blocks) {
            IBlockState iblockstate;
            boolean hasBreak;
            double d3 = (double)blockpos.func_177958_n() - d0;
            double d4 = (double)blockpos.func_177956_o() - d1;
            double d5 = (double)blockpos.func_177952_p() - d2;
            Block block = world.func_180495_p(blockpos).func_177230_c();
            TileEntity te = world.func_175625_s(blockpos);
            boolean bl = hasBreak = block instanceof BlockChest || block instanceof BlockEnderChest || block instanceof BlockSign || block instanceof BlockSkull;
            if (!hasBreak) {
                boolean bl2 = hasBreak = te != null && te.canRenderBreaking();
            }
            if (hasBreak || (iblockstate = world.func_180495_p(blockpos)).func_185904_a() == Material.field_151579_a) continue;
            TextureAtlasSprite textureatlassprite = destroyBlockIcons[progress];
            BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
            blockrendererdispatcher.func_175020_a(iblockstate, blockpos, textureatlassprite, (IBlockAccess)world);
        }
        tessellatorIn.func_78381_a();
        worldRendererIn.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179118_c();
        GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
        GlStateManager.func_179113_r();
        GlStateManager.func_179141_d();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    public static void drawColouredRect(int x, int y, int w, int h, int colour) {
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        worldrenderer.func_181662_b((double)x, (double)(y + h), 0.0).func_181669_b(colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF, colour >> 24 & 0xFF).func_181675_d();
        worldrenderer.func_181662_b((double)(x + w), (double)(y + h), 0.0).func_181669_b(colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF, colour >> 24 & 0xFF).func_181675_d();
        worldrenderer.func_181662_b((double)(x + w), (double)y, 0.0).func_181669_b(colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF, colour >> 24 & 0xFF).func_181675_d();
        worldrenderer.func_181662_b((double)x, (double)y, 0.0).func_181669_b(colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF, colour >> 24 & 0xFF).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawGradientRect(int x0, int y0, int x1, int y1, int colour0, int colour1) {
        float f = (float)(colour0 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(colour0 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(colour0 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(colour0 & 0xFF) / 255.0f;
        float f4 = (float)(colour1 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(colour1 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(colour1 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(colour1 & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        worldrenderer.func_181662_b((double)x1, (double)y0, 0.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        worldrenderer.func_181662_b((double)x0, (double)y0, 0.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        worldrenderer.func_181662_b((double)x0, (double)y1, 0.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        worldrenderer.func_181662_b((double)x1, (double)y1, 0.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawTexturedRect(float x, float y, float w, float h, double ... uv) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)x, (double)(y + h), 0.0).func_187315_a(uv[0], uv[3]).func_181675_d();
        worldrenderer.func_181662_b((double)(x + w), (double)(y + h), 0.0).func_187315_a(uv[1], uv[3]).func_181675_d();
        worldrenderer.func_181662_b((double)(x + w), (double)y, 0.0).func_187315_a(uv[1], uv[2]).func_181675_d();
        worldrenderer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(uv[0], uv[2]).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexturedRect(int x, int y, int w, int h, float picSize, int ... uv) {
        double[] d_uv = new double[]{(float)uv[0] / picSize, (float)uv[1] / picSize, (float)uv[2] / picSize, (float)uv[3] / picSize};
        ClientUtils.drawTexturedRect((float)x, (float)y, (float)w, (float)h, d_uv);
    }

    public static void drawRepeatedFluidSprite(FluidStack fluid, float x, float y, float w, float h) {
        ClientUtils.bindTexture(TextureMap.field_110575_b.toString());
        TextureAtlasSprite sprite = ClientUtils.mc().func_147117_R().func_110572_b(fluid.getFluid().getStill(fluid).toString());
        if (sprite != null) {
            int col = fluid.getFluid().getColor(fluid);
            GlStateManager.func_179131_c((float)((float)(col >> 16 & 0xFF) / 255.0f), (float)((float)(col >> 8 & 0xFF) / 255.0f), (float)((float)(col & 0xFF) / 255.0f), (float)1.0f);
            int iW = sprite.func_94211_a();
            int iH = sprite.func_94216_b();
            if (iW > 0 && iH > 0) {
                ClientUtils.drawRepeatedSprite(x, y, w, h, iW, iH, sprite.func_94209_e(), sprite.func_94212_f(), sprite.func_94206_g(), sprite.func_94210_h());
            }
        }
    }

    public static void drawRepeatedSprite(float x, float y, float w, float h, int iconWidth, int iconHeight, float uMin, float uMax, float vMin, float vMax) {
        int iterMaxW = (int)(w / (float)iconWidth);
        int iterMaxH = (int)(h / (float)iconHeight);
        float leftoverW = w % (float)iconWidth;
        float leftoverH = h % (float)iconHeight;
        float leftoverWf = leftoverW / (float)iconWidth;
        float leftoverHf = leftoverH / (float)iconHeight;
        float iconUDif = uMax - uMin;
        float iconVDif = vMax - vMin;
        for (int ww = 0; ww < iterMaxW; ++ww) {
            for (int hh = 0; hh < iterMaxH; ++hh) {
                ClientUtils.drawTexturedRect(x + (float)(ww * iconWidth), y + (float)(hh * iconHeight), (float)iconWidth, (float)iconHeight, uMin, uMax, vMin, vMax);
            }
            ClientUtils.drawTexturedRect(x + (float)(ww * iconWidth), y + (float)(iterMaxH * iconHeight), (float)iconWidth, leftoverH, uMin, uMax, vMin, vMin + iconVDif * leftoverHf);
        }
        if (leftoverW > 0.0f) {
            for (int hh = 0; hh < iterMaxH; ++hh) {
                ClientUtils.drawTexturedRect(x + (float)(iterMaxW * iconWidth), y + (float)(hh * iconHeight), leftoverW, (float)iconHeight, uMin, uMin + iconUDif * leftoverWf, vMin, vMax);
            }
            ClientUtils.drawTexturedRect(x + (float)(iterMaxW * iconWidth), y + (float)(iterMaxH * iconHeight), leftoverW, leftoverH, uMin, uMin + iconUDif * leftoverWf, vMin, vMin + iconVDif * leftoverHf);
        }
    }

    public static void drawSlot(int x, int y, int w, int h) {
        ClientUtils.drawSlot(x, y, w, h, 255);
    }

    public static void drawSlot(int x, int y, int w, int h, int alpha) {
        ClientUtils.drawColouredRect(x + 8 - w / 2, y + 8 - h / 2 - 1, w, 1, (alpha << 24) + 0x373737);
        ClientUtils.drawColouredRect(x + 8 - w / 2 - 1, y + 8 - h / 2 - 1, 1, h + 1, (alpha << 24) + 0x373737);
        ClientUtils.drawColouredRect(x + 8 - w / 2, y + 8 - h / 2, w, h, (alpha << 24) + 0x8B8B8B);
        ClientUtils.drawColouredRect(x + 8 - w / 2, y + 8 + h / 2, w + 1, 1, (alpha << 24) + 0xFFFFFF);
        ClientUtils.drawColouredRect(x + 8 + w / 2, y + 8 - h / 2, 1, h, (alpha << 24) + 0xFFFFFF);
    }

    public static void drawDarkSlot(int x, int y, int w, int h) {
        ClientUtils.drawColouredRect(x + 8 - w / 2, y + 8 - h / 2 - 1, w, 1, 0x77222222);
        ClientUtils.drawColouredRect(x + 8 - w / 2 - 1, y + 8 - h / 2 - 1, 1, h + 1, 0x77222222);
        ClientUtils.drawColouredRect(x + 8 - w / 2, y + 8 - h / 2, w, h, 0x77111111);
        ClientUtils.drawColouredRect(x + 8 - w / 2, y + 8 + h / 2, w + 1, 1, 0x77999999);
        ClientUtils.drawColouredRect(x + 8 + w / 2, y + 8 - h / 2, 1, h, 0x77999999);
    }

    public static void renderToolTip(ItemStack stack, int x, int y) {
        List list = stack.func_82840_a((EntityPlayer)ClientUtils.mc().field_71439_g, ClientUtils.mc().field_71474_y.field_82882_x);
        for (int k = 0; k < list.size(); ++k) {
            if (k == 0) {
                list.set(k, stack.func_77953_t().field_77937_e + (String)list.get(k));
                continue;
            }
            list.set(k, TextFormatting.GRAY + (String)list.get(k));
        }
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        ClientUtils.drawHoveringText(list, x, y, font == null ? ClientUtils.font() : font);
    }

    public static void drawHoveringText(List<String> list, int x, int y, FontRenderer font) {
        ClientUtils.drawHoveringText(list, x, y, font, -1, -1);
    }

    public static void drawHoveringText(List<String> list, int x, int y, FontRenderer font, int xSize, int ySize) {
        if (!list.isEmpty()) {
            boolean uni = ClientUtils.font().func_82883_a();
            ClientUtils.font().func_78264_a(false);
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int k = 0;
            for (String s : list) {
                int l = font.func_78256_a(s);
                if (l <= k) continue;
                k = l;
            }
            int j2 = x + 12;
            int k2 = y - 12;
            int i1 = 8;
            boolean shift = false;
            if (xSize > 0 && j2 + k > xSize) {
                j2 -= 28 + k;
                shift = true;
            }
            if (ySize > 0 && k2 + i1 + 6 > ySize) {
                k2 = ySize - i1 - 6;
                shift = true;
            }
            if (!shift && ClientUtils.mc().field_71462_r != null) {
                if (j2 + k > ClientUtils.mc().field_71462_r.field_146294_l) {
                    j2 -= 28 + k;
                }
                if (k2 + i1 + 6 > ClientUtils.mc().field_71462_r.field_146295_m) {
                    k2 = ClientUtils.mc().field_71462_r.field_146295_m - i1 - 6;
                }
            }
            if (list.size() > 1) {
                i1 += 2 + (list.size() - 1) * 10;
            }
            GL11.glTranslated((double)0.0, (double)0.0, (double)300.0);
            int j1 = -267386864;
            ClientUtils.drawGradientRect(j2 - 3, k2 - 4, j2 + k + 3, k2 - 3, j1, j1);
            ClientUtils.drawGradientRect(j2 - 3, k2 + i1 + 3, j2 + k + 3, k2 + i1 + 4, j1, j1);
            ClientUtils.drawGradientRect(j2 - 3, k2 - 3, j2 + k + 3, k2 + i1 + 3, j1, j1);
            ClientUtils.drawGradientRect(j2 - 4, k2 - 3, j2 - 3, k2 + i1 + 3, j1, j1);
            ClientUtils.drawGradientRect(j2 + k + 3, k2 - 3, j2 + k + 4, k2 + i1 + 3, j1, j1);
            int k1 = 0x505000FF;
            int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
            ClientUtils.drawGradientRect(j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + i1 + 3 - 1, k1, l1);
            ClientUtils.drawGradientRect(j2 + k + 2, k2 - 3 + 1, j2 + k + 3, k2 + i1 + 3 - 1, k1, l1);
            ClientUtils.drawGradientRect(j2 - 3, k2 - 3, j2 + k + 3, k2 - 3 + 1, k1, k1);
            ClientUtils.drawGradientRect(j2 - 3, k2 + i1 + 2, j2 + k + 3, k2 + i1 + 3, l1, l1);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-300.0);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String s1 = list.get(i2);
                font.func_175063_a(s1, (float)j2, (float)k2, -1);
                if (i2 == 0) {
                    k2 += 2;
                }
                k2 += 10;
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
            ClientUtils.font().func_78264_a(uni);
        }
    }

    public static void handleGuiTank(IFluidTank tank, int x, int y, int w, int h, int oX, int oY, int oW, int oH, int mX, int mY, String originalTexture, ArrayList<String> tooltip) {
        ClientUtils.handleGuiTank(tank.getFluid(), tank.getCapacity(), x, y, w, h, oX, oY, oW, oH, mX, mY, originalTexture, tooltip);
    }

    public static void handleGuiTank(FluidStack fluid, int capacity, int x, int y, int w, int h, int oX, int oY, int oW, int oH, int mX, int mY, String originalTexture, ArrayList<String> tooltip) {
        if (tooltip == null) {
            if (fluid != null && fluid.getFluid() != null) {
                int fluidHeight = (int)((float)h * ((float)fluid.amount / (float)capacity));
                ClientUtils.drawRepeatedFluidSprite(fluid, x, y + h - fluidHeight, w, fluidHeight);
                ClientUtils.bindTexture(originalTexture);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            int xOff = (w - oW) / 2;
            int yOff = (h - oH) / 2;
            ClientUtils.drawTexturedRect(x + xOff, y + yOff, oW, oH, 256.0f, oX, oX + oW, oY, oY + oH);
        } else if (mX >= x && mX < x + w && mY >= y && mY < y + h) {
            ClientUtils.addFluidTooltip(fluid, tooltip, capacity);
        }
    }

    public static void addFluidTooltip(FluidStack fluid, List<String> tooltip, int tankCapacity) {
        if (fluid != null && fluid.getFluid() != null) {
            tooltip.add(fluid.getFluid().getRarity((FluidStack)fluid).field_77937_e + fluid.getLocalizedName());
        } else {
            tooltip.add(I18n.func_135052_a((String)"gui.immersiveengineering.empty", (Object[])new Object[0]));
        }
        if (fluid != null && fluid.getFluid() instanceof IEFluid) {
            ((IEFluid)fluid.getFluid()).addTooltipInfo(fluid, null, tooltip);
        }
        if (ClientUtils.mc().field_71474_y.field_82882_x && fluid != null) {
            if (!GuiScreen.func_146272_n()) {
                tooltip.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.holdShiftForInfo", (Object[])new Object[0]));
            } else {
                tooltip.add(TextFormatting.DARK_GRAY + "Fluid Registry: " + FluidRegistry.getFluidName((FluidStack)fluid));
                tooltip.add(TextFormatting.DARK_GRAY + "Density: " + fluid.getFluid().getDensity(fluid));
                tooltip.add(TextFormatting.DARK_GRAY + "Temperature: " + fluid.getFluid().getTemperature(fluid));
                tooltip.add(TextFormatting.DARK_GRAY + "Viscosity: " + fluid.getFluid().getViscosity(fluid));
                tooltip.add(TextFormatting.DARK_GRAY + "NBT Data: " + fluid.tag);
            }
        }
        if (tankCapacity > 0) {
            tooltip.add(TextFormatting.GRAY.toString() + (fluid != null ? fluid.amount : 0) + "/" + tankCapacity + "mB");
        } else {
            tooltip.add(TextFormatting.GRAY.toString() + (fluid != null ? fluid.amount : 0) + "mB");
        }
    }

    public static Quat4d degreeToQuaterion(double x, double y, double z) {
        x = Math.toRadians(x);
        y = Math.toRadians(y);
        z = Math.toRadians(z);
        Quat4d qYaw = new Quat4d(0.0, Math.sin(y / 2.0), 0.0, Math.cos(y / 2.0));
        Quat4d qPitch = new Quat4d(Math.sin(x / 2.0), 0.0, 0.0, Math.cos(x / 2.0));
        Quat4d qRoll = new Quat4d(0.0, 0.0, Math.sin(z / 2.0), Math.cos(z / 2.0));
        Quat4d quat = qYaw;
        quat.mul(qRoll);
        quat.mul(qPitch);
        return quat;
    }

    public static List<BakedQuad>[] convertConnectionFromBlockstate(IExtendedBlockState s, TextureAtlasSprite t) {
        List[] ret = new List[]{new ArrayList(), new ArrayList()};
        Set conns = (Set)s.getValue((IUnlistedProperty)IEProperties.CONNECTIONS);
        if (conns == null) {
            return ret;
        }
        Vector3f dir = new Vector3f();
        Vector3f cross = new Vector3f();
        Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
        BlockPos pos = null;
        for (ImmersiveNetHandler.Connection conn : conns) {
            boolean greater;
            Vec3d[] f;
            if (pos == null) {
                pos = conn.start;
            }
            if ((f = conn.catenaryVertices) == null || f.length < 1) continue;
            int color = conn.cableType.getColour(conn);
            float[] rgb = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f};
            if (rgb[3] == 0.0f) {
                rgb[3] = 1.0f;
            }
            Vector3f start = new Vector3f((float)conn.start.func_177958_n(), (float)conn.start.func_177956_o(), (float)conn.start.func_177952_p());
            float radius = (float)(conn.cableType.getRenderDiameter() / 2.0);
            ArrayList<Integer> crossings = new ArrayList<Integer>();
            for (int i = 1; i < f.length; ++i) {
                if (!ClientUtils.crossesChunkBoundary(f[i], f[i - 1])) continue;
                crossings.add(i);
            }
            int index = crossings.size() / 2;
            boolean bl = greater = conn.start.compareTo((Vec3i)conn.end) > 0;
            if (crossings.size() % 2 == 0 && greater) {
                --index;
            }
            int max = crossings.size() > 0 ? (Integer)crossings.get(index) + (greater ? 1 : 2) : (greater ? f.length + 1 : 0);
            for (int i = 1; i < max && i < f.length; ++i) {
                boolean vertical;
                boolean fading = i == max - 1;
                List curr = ret[fading ? 1 : 0];
                int j = i - 1;
                Vector3f here = new Vector3f((float)f[i].field_72450_a, (float)f[i].field_72448_b, (float)f[i].field_72449_c);
                Vector3f.sub((Vector3f)here, (Vector3f)start, (Vector3f)here);
                Vector3f there = new Vector3f((float)f[j].field_72450_a, (float)f[j].field_72448_b, (float)f[j].field_72449_c);
                Vector3f.sub((Vector3f)there, (Vector3f)start, (Vector3f)there);
                if (fading) {
                    Vector3f.add((Vector3f)here, (Vector3f)fadingOffset, (Vector3f)here);
                    Vector3f.add((Vector3f)there, (Vector3f)fadingOffset, (Vector3f)there);
                }
                boolean bl2 = vertical = here.x == there.x && here.z == there.z;
                if (!vertical) {
                    Vector3f.sub((Vector3f)here, (Vector3f)there, (Vector3f)dir);
                    Vector3f.cross((Vector3f)up, (Vector3f)dir, (Vector3f)cross);
                    cross.scale(radius / cross.length());
                } else {
                    cross.set(radius, 0.0f, 0.0f);
                }
                Vector3f[] vertices = new Vector3f[]{Vector3f.add((Vector3f)here, (Vector3f)cross, null), Vector3f.sub((Vector3f)here, (Vector3f)cross, null), Vector3f.sub((Vector3f)there, (Vector3f)cross, null), Vector3f.add((Vector3f)there, (Vector3f)cross, null)};
                curr.add(ClientUtils.createSmartLightingBakedQuad(DefaultVertexFormats.field_176599_b, vertices, EnumFacing.DOWN, t, rgb, false, fading ? alphaFirst2Fading : alphaNoFading, pos));
                curr.add(ClientUtils.createSmartLightingBakedQuad(DefaultVertexFormats.field_176599_b, vertices, EnumFacing.UP, t, rgb, true, fading ? alphaFirst2Fading : alphaNoFading, pos));
                if (!vertical) {
                    Vector3f.cross((Vector3f)cross, (Vector3f)dir, (Vector3f)cross);
                    cross.scale(radius / cross.length());
                } else {
                    cross.set(0.0f, 0.0f, radius);
                }
                vertices = new Vector3f[]{Vector3f.add((Vector3f)here, (Vector3f)cross, null), Vector3f.sub((Vector3f)here, (Vector3f)cross, null), Vector3f.sub((Vector3f)there, (Vector3f)cross, null), Vector3f.add((Vector3f)there, (Vector3f)cross, null)};
                curr.add(ClientUtils.createSmartLightingBakedQuad(DefaultVertexFormats.field_176599_b, vertices, EnumFacing.WEST, t, rgb, false, fading ? alphaFirst2Fading : alphaNoFading, pos));
                curr.add(ClientUtils.createSmartLightingBakedQuad(DefaultVertexFormats.field_176599_b, vertices, EnumFacing.EAST, t, rgb, true, fading ? alphaFirst2Fading : alphaNoFading, pos));
            }
        }
        return ret;
    }

    private static void storeVertexData(int[] faceData, int storeIndex, Vector3f position, TextureAtlasSprite t, int u, int v, int color) {
        int i = storeIndex * 7;
        faceData[i] = Float.floatToRawIntBits(position.x);
        faceData[i + 1] = Float.floatToRawIntBits(position.y);
        faceData[i + 2] = Float.floatToRawIntBits(position.z);
        faceData[i + 3] = ClientUtils.invertRgb(color);
        faceData[i + 4] = Float.floatToRawIntBits(t.func_94214_a((double)u));
        faceData[i + 5] = Float.floatToRawIntBits(t.func_94207_b((double)v));
    }

    public static Vector3f[] applyMatrixToVertices(Matrix4 matrix, Vector3f ... vertices) {
        if (matrix == null) {
            return vertices;
        }
        Vector3f[] ret = new Vector3f[vertices.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = matrix.apply(vertices[i]);
        }
        return ret;
    }

    public static Set<BakedQuad> createBakedBox(Vector3f from, Vector3f to, Matrix4 matrix, Function<EnumFacing, TextureAtlasSprite> textureGetter, float[] colour) {
        return ClientUtils.createBakedBox(from, to, matrix, EnumFacing.NORTH, textureGetter, colour);
    }

    public static Set<BakedQuad> createBakedBox(Vector3f from, Vector3f to, Matrix4 matrix, EnumFacing facing, Function<EnumFacing, TextureAtlasSprite> textureGetter, float[] colour) {
        return ClientUtils.createBakedBox(from, to, matrix, facing, vertices -> vertices, textureGetter, colour);
    }

    public static Set<BakedQuad> createBakedBox(Vector3f from, Vector3f to, Matrix4 matrix, EnumFacing facing, Function<Vector3f[], Vector3f[]> vertexTransformer, Function<EnumFacing, TextureAtlasSprite> textureGetter, float[] colour) {
        HashSet<BakedQuad> quads = new HashSet<BakedQuad>();
        if (vertexTransformer == null) {
            vertexTransformer = v -> v;
        }
        Vector3f[] vertices = new Vector3f[]{new Vector3f(from.x, from.y, from.z), new Vector3f(from.x, from.y, to.z), new Vector3f(to.x, from.y, to.z), new Vector3f(to.x, from.y, from.z)};
        TextureAtlasSprite sprite = textureGetter.apply(EnumFacing.DOWN);
        if (sprite != null) {
            quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertexTransformer.apply(vertices)), Utils.rotateFacingTowardsDir(EnumFacing.DOWN, facing), sprite, new double[]{from.x * 16.0f, 16.0f - from.z * 16.0f, to.x * 16.0f, 16.0f - to.z * 16.0f}, colour, true));
        }
        for (Vector3f v2 : vertices) {
            v2.setY(to.y);
        }
        sprite = textureGetter.apply(EnumFacing.UP);
        if (sprite != null) {
            quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertexTransformer.apply(vertices)), Utils.rotateFacingTowardsDir(EnumFacing.UP, facing), sprite, new double[]{from.x * 16.0f, from.z * 16.0f, to.x * 16.0f, to.z * 16.0f}, colour, false));
        }
        vertices = new Vector3f[]{new Vector3f(to.x, to.y, from.z), new Vector3f(to.x, from.y, from.z), new Vector3f(from.x, from.y, from.z), new Vector3f(from.x, to.y, from.z)};
        sprite = textureGetter.apply(EnumFacing.NORTH);
        if (sprite != null) {
            quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertexTransformer.apply(vertices)), Utils.rotateFacingTowardsDir(EnumFacing.NORTH, facing), sprite, new double[]{from.x * 16.0f, 16.0f - to.y * 16.0f, to.x * 16.0f, 16.0f - from.y * 16.0f}, colour, false));
        }
        for (Vector3f v2 : vertices) {
            v2.setZ(to.z);
        }
        sprite = textureGetter.apply(EnumFacing.SOUTH);
        if (sprite != null) {
            quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertexTransformer.apply(vertices)), Utils.rotateFacingTowardsDir(EnumFacing.SOUTH, facing), sprite, new double[]{to.x * 16.0f, 16.0f - to.y * 16.0f, from.x * 16.0f, 16.0f - from.y * 16.0f}, colour, true));
        }
        vertices = new Vector3f[]{new Vector3f(from.x, to.y, to.z), new Vector3f(from.x, from.y, to.z), new Vector3f(from.x, from.y, from.z), new Vector3f(from.x, to.y, from.z)};
        sprite = textureGetter.apply(EnumFacing.WEST);
        if (sprite != null) {
            quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertexTransformer.apply(vertices)), Utils.rotateFacingTowardsDir(EnumFacing.WEST, facing), sprite, new double[]{to.z * 16.0f, 16.0f - to.y * 16.0f, from.z * 16.0f, 16.0f - from.y * 16.0f}, colour, true));
        }
        for (Vector3f v2 : vertices) {
            v2.setX(to.x);
        }
        sprite = textureGetter.apply(EnumFacing.EAST);
        if (sprite != null) {
            quads.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, ClientUtils.applyMatrixToVertices(matrix, vertexTransformer.apply(vertices)), Utils.rotateFacingTowardsDir(EnumFacing.EAST, facing), sprite, new double[]{from.z * 16.0f, 16.0f - to.y * 16.0f, to.z * 16.0f, 16.0f - from.y * 16.0f}, colour, false));
        }
        return quads;
    }

    public static BakedQuad createBakedQuad(VertexFormat format, Vector3f[] vertices, EnumFacing facing, TextureAtlasSprite sprite, float[] colour, boolean invert, float[] alpha) {
        return ClientUtils.createBakedQuad(format, vertices, facing, sprite, new double[]{0.0, 0.0, 16.0, 16.0}, colour, invert, alpha);
    }

    public static BakedQuad createSmartLightingBakedQuad(VertexFormat format, Vector3f[] vertices, EnumFacing facing, TextureAtlasSprite sprite, float[] colour, boolean invert, float[] alpha, BlockPos base) {
        return ClientUtils.createBakedQuad(format, vertices, facing, sprite, new double[]{0.0, 0.0, 16.0, 16.0}, colour, invert, alpha, true, base);
    }

    public static BakedQuad createBakedQuad(VertexFormat format, Vector3f[] vertices, EnumFacing facing, TextureAtlasSprite sprite, double[] uvs, float[] colour, boolean invert) {
        return ClientUtils.createBakedQuad(format, vertices, facing, sprite, uvs, colour, invert, alphaNoFading);
    }

    public static BakedQuad createBakedQuad(VertexFormat format, Vector3f[] vertices, EnumFacing facing, TextureAtlasSprite sprite, double[] uvs, float[] colour, boolean invert, float[] alpha) {
        return ClientUtils.createBakedQuad(format, vertices, facing, sprite, uvs, colour, invert, alpha, false, null);
    }

    public static BakedQuad createBakedQuad(VertexFormat format, Vector3f[] vertices, EnumFacing facing, TextureAtlasSprite sprite, double[] uvs, float[] colour, boolean invert, float[] alpha, boolean smartLighting, BlockPos basePos) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        builder.setQuadOrientation(facing);
        builder.setTexture(sprite);
        OBJModel.Normal faceNormal = new OBJModel.Normal((float)facing.func_176730_m().func_177958_n(), (float)facing.func_176730_m().func_177956_o(), (float)facing.func_176730_m().func_177952_p());
        int vId = invert ? 3 : 0;
        int u = vId > 1 ? 2 : 0;
        ClientUtils.putVertexData(format, builder, vertices[vId], faceNormal, uvs[u], uvs[1], sprite, colour, alpha[invert ? 3 : 0]);
        vId = invert ? 2 : 1;
        u = vId > 1 ? 2 : 0;
        ClientUtils.putVertexData(format, builder, vertices[invert ? 2 : 1], faceNormal, uvs[u], uvs[3], sprite, colour, alpha[invert ? 2 : 1]);
        vId = invert ? 1 : 2;
        u = vId > 1 ? 2 : 0;
        ClientUtils.putVertexData(format, builder, vertices[invert ? 1 : 2], faceNormal, uvs[u], uvs[3], sprite, colour, alpha[invert ? 1 : 2]);
        vId = invert ? 1 : 3;
        u = vId > 1 ? 2 : 0;
        ClientUtils.putVertexData(format, builder, vertices[invert ? 0 : 3], faceNormal, uvs[u], uvs[1], sprite, colour, alpha[invert ? 0 : 3]);
        UnpackedBakedQuad tmp = builder.build();
        return smartLighting ? new SmartLightingQuad(tmp.func_178209_a(), -1, facing, sprite, format, basePos) : tmp;
    }

    protected static void putVertexData(VertexFormat format, UnpackedBakedQuad.Builder builder, Vector3f pos, OBJModel.Normal faceNormal, double u, double v, TextureAtlasSprite sprite, float[] colour, float alpha) {
        block6: for (int e = 0; e < format.func_177345_h(); ++e) {
            switch (format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{pos.getX(), pos.getY(), pos.getZ(), 0.0f});
                    continue block6;
                }
                case COLOR: {
                    float d = 1.0f;
                    builder.put(e, new float[]{d * colour[0], d * colour[1], d * colour[2], 1.0f * colour[3] * alpha});
                    continue block6;
                }
                case UV: {
                    if (sprite == null) {
                        sprite = Minecraft.func_71410_x().func_147117_R().func_174944_f();
                    }
                    builder.put(e, new float[]{sprite.func_94214_a(u), sprite.func_94207_b(v), 0.0f, 1.0f});
                    continue block6;
                }
                case NORMAL: {
                    builder.put(e, new float[]{faceNormal.x, faceNormal.y, faceNormal.z, 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    public static boolean crossesChunkBoundary(Vec3d start, Vec3d end) {
        if ((int)Math.floor(start.field_72450_a / 16.0) != (int)Math.floor(end.field_72450_a / 16.0)) {
            return true;
        }
        if ((int)Math.floor(start.field_72448_b / 16.0) != (int)Math.floor(end.field_72448_b / 16.0)) {
            return true;
        }
        return (int)Math.floor(start.field_72449_c / 16.0) != (int)Math.floor(end.field_72449_c / 16.0);
    }

    public static void renderQuads(Collection<BakedQuad> quads, float brightness, float red, float green, float blue) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        for (BakedQuad bakedquad : quads) {
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            vertexbuffer.func_178981_a(bakedquad.func_178209_a());
            if (bakedquad.func_178212_b()) {
                vertexbuffer.func_178990_f(red * brightness, green * brightness, blue * brightness);
            } else {
                vertexbuffer.func_178990_f(brightness, brightness, brightness);
            }
            Vec3i vec3i = bakedquad.func_178210_d().func_176730_m();
            vertexbuffer.func_178975_e((float)vec3i.func_177958_n(), (float)vec3i.func_177956_o(), (float)vec3i.func_177952_p());
            tessellator.func_78381_a();
        }
    }

    public static ResourceLocation getSideTexture(@Nonnull ItemStack stack, EnumFacing side) {
        IBakedModel model = ClientUtils.mc().func_175599_af().func_184393_a(stack, null, null);
        List quads = model.func_188616_a(null, side, 0L);
        if (quads == null || quads.isEmpty()) {
            quads = model.func_188616_a(null, null, 0L);
        }
        if (quads == null || quads.isEmpty()) {
            return null;
        }
        return new ResourceLocation(((BakedQuad)quads.get(0)).func_187508_a().func_94215_i());
    }

    public static ResourceLocation getSideTexture(@Nonnull IBlockState state, EnumFacing side) {
        IBakedModel model = ClientUtils.mc().func_175602_ab().func_184389_a(state);
        List quads = model.func_188616_a(state, side, 0L);
        if (quads == null || quads.isEmpty()) {
            quads = model.func_188616_a(state, null, 0L);
        }
        if (quads == null || quads.isEmpty()) {
            return null;
        }
        return new ResourceLocation(((BakedQuad)quads.get(0)).func_187508_a().func_94215_i());
    }

    private static int invertRgb(int in) {
        int ret = in & 0xFF00;
        ret += in >> 16 & 0xFF;
        return ret += (in & 0xFF) << 16;
    }

    public static void renderBox(VertexBuffer wr, double x0, double y0, double z0, double x1, double y1, double z1) {
        wr.func_181662_b(x0, y0, z1).func_181675_d();
        wr.func_181662_b(x1, y0, z1).func_181675_d();
        wr.func_181662_b(x1, y1, z1).func_181675_d();
        wr.func_181662_b(x0, y1, z1).func_181675_d();
        wr.func_181662_b(x0, y1, z0).func_181675_d();
        wr.func_181662_b(x1, y1, z0).func_181675_d();
        wr.func_181662_b(x1, y0, z0).func_181675_d();
        wr.func_181662_b(x0, y0, z0).func_181675_d();
        wr.func_181662_b(x0, y0, z0).func_181675_d();
        wr.func_181662_b(x1, y0, z0).func_181675_d();
        wr.func_181662_b(x1, y0, z1).func_181675_d();
        wr.func_181662_b(x0, y0, z1).func_181675_d();
        wr.func_181662_b(x0, y1, z1).func_181675_d();
        wr.func_181662_b(x1, y1, z1).func_181675_d();
        wr.func_181662_b(x1, y1, z0).func_181675_d();
        wr.func_181662_b(x0, y1, z0).func_181675_d();
        wr.func_181662_b(x0, y0, z0).func_181675_d();
        wr.func_181662_b(x0, y0, z1).func_181675_d();
        wr.func_181662_b(x0, y1, z1).func_181675_d();
        wr.func_181662_b(x0, y1, z0).func_181675_d();
        wr.func_181662_b(x1, y1, z0).func_181675_d();
        wr.func_181662_b(x1, y1, z1).func_181675_d();
        wr.func_181662_b(x1, y0, z1).func_181675_d();
        wr.func_181662_b(x1, y0, z0).func_181675_d();
    }

    public static void renderTexturedBox(VertexBuffer wr, double x0, double y0, double z0, double x1, double y1, double z1, double u0, double v0, double u1, double v1) {
        wr.func_181662_b(x0, y0, z1).func_187315_a(u0, v0).func_181675_d();
        wr.func_181662_b(x1, y0, z1).func_187315_a(u1, v0).func_181675_d();
        wr.func_181662_b(x1, y1, z1).func_187315_a(u1, v1).func_181675_d();
        wr.func_181662_b(x0, y1, z1).func_187315_a(u0, v1).func_181675_d();
        wr.func_181662_b(x0, y1, z0).func_187315_a(u0, v0).func_181675_d();
        wr.func_181662_b(x1, y1, z0).func_187315_a(u1, v0).func_181675_d();
        wr.func_181662_b(x1, y0, z0).func_187315_a(u1, v1).func_181675_d();
        wr.func_181662_b(x0, y0, z0).func_187315_a(u0, v1).func_181675_d();
        wr.func_181662_b(x0, y0, z0).func_187315_a(u0, v0).func_181675_d();
        wr.func_181662_b(x1, y0, z0).func_187315_a(u1, v0).func_181675_d();
        wr.func_181662_b(x1, y0, z1).func_187315_a(u1, v1).func_181675_d();
        wr.func_181662_b(x0, y0, z1).func_187315_a(u0, v1).func_181675_d();
        wr.func_181662_b(x0, y1, z1).func_187315_a(u0, v0).func_181675_d();
        wr.func_181662_b(x1, y1, z1).func_187315_a(u1, v0).func_181675_d();
        wr.func_181662_b(x1, y1, z0).func_187315_a(u1, v1).func_181675_d();
        wr.func_181662_b(x0, y1, z0).func_187315_a(u0, v1).func_181675_d();
        wr.func_181662_b(x0, y0, z0).func_187315_a(u0, v0).func_181675_d();
        wr.func_181662_b(x0, y0, z1).func_187315_a(u1, v0).func_181675_d();
        wr.func_181662_b(x0, y1, z1).func_187315_a(u1, v1).func_181675_d();
        wr.func_181662_b(x0, y1, z0).func_187315_a(u0, v1).func_181675_d();
        wr.func_181662_b(x1, y1, z0).func_187315_a(u0, v0).func_181675_d();
        wr.func_181662_b(x1, y1, z1).func_187315_a(u1, v0).func_181675_d();
        wr.func_181662_b(x1, y0, z1).func_187315_a(u1, v1).func_181675_d();
        wr.func_181662_b(x1, y0, z0).func_187315_a(u0, v1).func_181675_d();
    }

    public static int intFromRgb(float[] rgb) {
        int ret = (int)(255.0f * rgb[0]);
        ret = (ret << 8) + (int)(255.0f * rgb[1]);
        ret = (ret << 8) + (int)(255.0f * rgb[2]);
        return ret;
    }

    public static void renderModelTESRFancy(List<BakedQuad> quads, VertexBuffer renderer, World world, BlockPos pos, boolean useCached) {
        if (Config.IEConfig.disableFancyTESR) {
            ClientUtils.renderModelTESRFast(quads, renderer, world, pos);
        } else {
            if (!useCached) {
                for (EnumFacing f : EnumFacing.field_82609_l) {
                    int val = world.func_175626_b(pos.func_177972_a(f), 0);
                    ClientUtils.neighbourBrightness[0][f.func_176745_a()] = val >> 16 & 0xFF;
                    ClientUtils.neighbourBrightness[1][f.func_176745_a()] = val & 0xFF;
                }
                for (int type = 0; type < 2; ++type) {
                    for (int i = 0; i < 8; ++i) {
                        float sSquared = 0.0f;
                        sSquared = (i & 1) != 0 ? (sSquared += ClientUtils.scaledSquared(neighbourBrightness[type][5], 255.0f)) : (sSquared += ClientUtils.scaledSquared(neighbourBrightness[type][4], 255.0f));
                        sSquared = (i & 2) != 0 ? (sSquared += ClientUtils.scaledSquared(neighbourBrightness[type][1], 255.0f)) : (sSquared += ClientUtils.scaledSquared(neighbourBrightness[type][0], 255.0f));
                        sSquared = (i & 4) != 0 ? (sSquared += ClientUtils.scaledSquared(neighbourBrightness[type][3], 255.0f)) : (sSquared += ClientUtils.scaledSquared(neighbourBrightness[type][2], 255.0f));
                        ClientUtils.normalizationFactors[type][i] = (float)Math.sqrt(sSquared);
                    }
                }
            }
            int localBrightness = world.func_175626_b(pos, 0);
            for (BakedQuad quad : quads) {
                int[] vData = quad.func_178209_a();
                VertexFormat format = quad.getFormat();
                int size = format.func_181719_f();
                int uv = format.func_177344_b(0) / 4;
                for (int i = 0; i < 4; ++i) {
                    ClientUtils.quadCoords[i][0] = Float.intBitsToFloat(vData[size * i]);
                    ClientUtils.quadCoords[i][1] = Float.intBitsToFloat(vData[size * i + 1]);
                    ClientUtils.quadCoords[i][2] = Float.intBitsToFloat(vData[size * i + 2]);
                }
                ClientUtils.side1.x = quadCoords[1][0] - quadCoords[3][0];
                ClientUtils.side1.y = quadCoords[1][1] - quadCoords[3][1];
                ClientUtils.side1.z = quadCoords[1][2] - quadCoords[3][2];
                ClientUtils.side2.x = quadCoords[2][0] - quadCoords[0][0];
                ClientUtils.side2.y = quadCoords[2][1] - quadCoords[0][1];
                ClientUtils.side2.z = quadCoords[2][2] - quadCoords[0][2];
                Vector3f.cross((Vector3f)side1, (Vector3f)side2, (Vector3f)normal);
                normal.normalise();
                int l1 = ClientUtils.getLightValue(neighbourBrightness[0], normalizationFactors[0], localBrightness >> 16 & 0xFF);
                int l2 = ClientUtils.getLightValue(neighbourBrightness[1], normalizationFactors[1], localBrightness & 0xFF);
                for (int i = 0; i < 4; ++i) {
                    renderer.func_181662_b((double)quadCoords[i][0], (double)quadCoords[i][1], (double)quadCoords[i][2]).func_181669_b(255, 255, 255, 255).func_187315_a((double)Float.intBitsToFloat(vData[size * i + uv]), (double)Float.intBitsToFloat(vData[size * i + uv + 1])).func_187314_a(l1, l2).func_181675_d();
                }
            }
        }
    }

    private static int getLightValue(int[] neighbourBrightness, float[] normalizationFactors, int localBrightness) {
        float sideBrightness;
        byte type = 0;
        if (ClientUtils.normal.x > 0.0f) {
            sideBrightness = ClientUtils.normal.x * (float)neighbourBrightness[5];
            type = (byte)(type | 1);
        } else {
            sideBrightness = -ClientUtils.normal.x * (float)neighbourBrightness[4];
        }
        if (ClientUtils.normal.y > 0.0f) {
            sideBrightness += ClientUtils.normal.y * (float)neighbourBrightness[1];
            type = (byte)(type | 2);
        } else {
            sideBrightness += -ClientUtils.normal.y * (float)neighbourBrightness[0];
        }
        if (ClientUtils.normal.z > 0.0f) {
            sideBrightness += ClientUtils.normal.z * (float)neighbourBrightness[3];
            type = (byte)(type | 4);
        } else {
            sideBrightness += -ClientUtils.normal.z * (float)neighbourBrightness[2];
        }
        return (int)(((float)localBrightness + sideBrightness / normalizationFactors[type]) / 2.0f);
    }

    private static float scaledSquared(int val, float scale) {
        return (float)val / scale * ((float)val / scale);
    }

    public static void renderModelTESRFast(List<BakedQuad> quads, VertexBuffer renderer, World world, BlockPos pos) {
        int brightness = world.func_175626_b(pos, 0);
        int l1 = brightness >> 16 & 0xFFFF;
        int l2 = brightness & 0xFFFF;
        for (BakedQuad quad : quads) {
            int[] vData = quad.func_178209_a();
            VertexFormat format = quad.getFormat();
            int size = format.func_181719_f();
            int uv = format.func_177344_b(0) / 4;
            for (int i = 0; i < 4; ++i) {
                renderer.func_181662_b((double)Float.intBitsToFloat(vData[size * i]), (double)Float.intBitsToFloat(vData[size * i + 1]), (double)Float.intBitsToFloat(vData[size * i + 2])).func_181669_b(255, 255, 255, 255).func_187315_a((double)Float.intBitsToFloat(vData[size * i + uv]), (double)Float.intBitsToFloat(vData[size * i + uv + 1])).func_187314_a(l1, l2).func_181675_d();
            }
        }
    }

    public static enum TimestampFormat {
        D,
        H,
        M,
        S,
        MS,
        HMS,
        HM,
        DHMS,
        DHM,
        DH;

        static TimestampFormat[] coreValues;

        public boolean containsFormat(TimestampFormat format) {
            return this.toString().contains(format.toString());
        }

        public long getTickCut() {
            return this == D ? 1728000L : (this == H ? 72000L : (this == M ? 1200L : (this == S ? 20L : 1L)));
        }

        public String getLocalKey() {
            return this == D ? "day" : (this == H ? "hour" : (this == M ? "minute" : (this == S ? "second" : "")));
        }

        static {
            coreValues = new TimestampFormat[]{D, H, M, S};
        }
    }
}

