/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.oredict.OreDictionary;

public class BlueprintCraftingRecipe
extends MultiblockRecipe {
    public static float energyModifier = 1.0f;
    public static float timeModifier = 1.0f;
    public static ArrayList<String> blueprintCategories = new ArrayList();
    public static ArrayListMultimap<String, BlueprintCraftingRecipe> recipeList = ArrayListMultimap.create();
    public static HashMap<String, ItemStack> villagerPrices = new HashMap();
    public String blueprintCategory;
    public ItemStack output;
    public IngredientStack[] inputs;

    public BlueprintCraftingRecipe(String blueprintCategory, ItemStack output, Object[] inputs) {
        this.blueprintCategory = blueprintCategory;
        this.output = output;
        this.inputs = new IngredientStack[inputs.length];
        for (int io = 0; io < inputs.length; ++io) {
            this.inputs[io] = ApiUtils.createIngredientStack(inputs[io]);
        }
        this.inputList = Lists.newArrayList((Object[])this.inputs);
        this.outputList = Lists.newArrayList((Object[])new ItemStack[]{this.output});
        this.totalProcessEnergy = (int)Math.floor(23040.0f * energyModifier);
        this.totalProcessTime = (int)Math.floor(180.0f * timeModifier);
    }

    public boolean matchesRecipe(ItemStack[] query) {
        return this.getMaxCrafted(query) > 0;
    }

    public int getMaxCrafted(ItemStack[] query) {
        HashMap<ItemStack, Integer> queryAmount = new HashMap<ItemStack, Integer>();
        for (ItemStack q : query) {
            if (q == null) continue;
            boolean inc = false;
            for (ItemStack key : queryAmount.keySet()) {
                if (!OreDictionary.itemMatches((ItemStack)q, (ItemStack)key, (boolean)true)) continue;
                queryAmount.put(key, (Integer)queryAmount.get(key) + q.field_77994_a);
                inc = true;
            }
            if (inc) continue;
            queryAmount.put(q, q.field_77994_a);
        }
        int maxCrafted = 0;
        ArrayList<IngredientStack> formattedInputList = this.getFormattedInputs();
        for (IngredientStack ingr : formattedInputList) {
            int supplied = 0;
            int req = ingr.inputSize;
            Iterator queryIt = queryAmount.entrySet().iterator();
            while (queryIt.hasNext()) {
                int taken;
                Map.Entry e = queryIt.next();
                ItemStack compStack = (ItemStack)e.getKey();
                if (!ingr.matchesItemStackIgnoringSize(compStack) || (taken = (Integer)e.getValue() / req) <= 0) continue;
                e.setValue((Integer)e.getValue() - taken * req);
                if ((Integer)e.getValue() <= 0) {
                    queryIt.remove();
                }
                supplied += taken;
            }
            if (supplied <= 0) {
                return 0;
            }
            maxCrafted = maxCrafted == 0 ? supplied : Math.min(maxCrafted, supplied);
        }
        return maxCrafted;
    }

    public ItemStack[] consumeInputs(ItemStack[] query, int crafted) {
        ArrayList<IngredientStack> inputList = new ArrayList<IngredientStack>(this.inputs.length);
        for (IngredientStack i : this.inputs) {
            if (i == null) continue;
            inputList.add(i);
        }
        ArrayList<ItemStack> consumed = new ArrayList<ItemStack>(inputList.size());
        Iterator inputIt = inputList.iterator();
        block1: while (inputIt.hasNext()) {
            IngredientStack ingr = (IngredientStack)inputIt.next();
            int inputSize = ingr.inputSize * crafted;
            for (int i = 0; i < query.length; ++i) {
                if (query[i] == null || !ingr.matchesItemStackIgnoringSize(query[i])) continue;
                int taken = Math.min(query[i].field_77994_a, inputSize);
                consumed.add(ApiUtils.copyStackWithAmount(query[i], taken));
                query[i].field_77994_a -= taken;
                if (query[i].field_77994_a <= 0) {
                    query[i] = null;
                }
                if ((inputSize -= taken) > 0) continue;
                inputIt.remove();
                continue block1;
            }
        }
        return consumed.toArray(new ItemStack[consumed.size()]);
    }

    public ArrayList<IngredientStack> getFormattedInputs() {
        ArrayList<IngredientStack> formattedInputs = new ArrayList<IngredientStack>();
        for (IngredientStack ingr : this.inputs) {
            if (ingr == null) continue;
            boolean isNew = true;
            for (IngredientStack formatted : formattedInputs) {
                if (ingr.oreName != null && ingr.oreName.equals(formatted.oreName)) {
                    isNew = false;
                } else if (ingr.stackList != null && formatted.stackList != null) {
                    block2: for (ItemStack iStack : ingr.stackList) {
                        for (ItemStack iStack2 : formatted.stackList) {
                            if (!OreDictionary.itemMatches((ItemStack)iStack, (ItemStack)iStack2, (boolean)false)) continue;
                            isNew = false;
                            continue block2;
                        }
                    }
                } else if (ingr.stack != null && OreDictionary.itemMatches((ItemStack)ingr.stack, (ItemStack)formatted.stack, (boolean)false)) {
                    isNew = false;
                }
                if (isNew) continue;
                formatted.inputSize += ingr.inputSize;
            }
            if (!isNew) continue;
            if (ingr.oreName != null) {
                formattedInputs.add(new IngredientStack(ingr.oreName, ingr.inputSize));
                continue;
            }
            if (ingr.stackList != null) {
                formattedInputs.add(new IngredientStack(Lists.newArrayList(ingr.stackList), ingr.inputSize));
                continue;
            }
            if (ingr.stack == null) continue;
            formattedInputs.add(new IngredientStack(ApiUtils.copyStackWithAmount(ingr.stack, ingr.inputSize)));
        }
        return formattedInputs;
    }

    public static void addRecipe(String blueprintCategory, ItemStack output, Object ... inputs) {
        recipeList.put((Object)blueprintCategory, (Object)new BlueprintCraftingRecipe(blueprintCategory, output, inputs));
        if (!blueprintCategories.contains(blueprintCategory)) {
            blueprintCategories.add(blueprintCategory);
        }
    }

    public static BlueprintCraftingRecipe[] findRecipes(String blueprintCategory) {
        if (recipeList.containsKey((Object)blueprintCategory)) {
            List list = recipeList.get((Object)blueprintCategory);
            return list.toArray(new BlueprintCraftingRecipe[list.size()]);
        }
        return new BlueprintCraftingRecipe[0];
    }

    public static void addVillagerTrade(String blueprintCategory, ItemStack villagerPrice) {
        villagerPrices.put(blueprintCategory, villagerPrice);
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (IngredientStack ingr : this.inputs) {
            list.func_74742_a((NBTBase)ingr.writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74782_a("inputs", (NBTBase)list);
        nbt.func_74778_a("blueprintCategory", this.blueprintCategory);
        return nbt;
    }

    public static BlueprintCraftingRecipe loadFromNBT(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("inputs", 10);
        IngredientStack[] inputs = new IngredientStack[list.func_74745_c()];
        for (int i = 0; i < inputs.length; ++i) {
            inputs[i] = IngredientStack.readFromNBT(list.func_150305_b(i));
        }
        List recipeList = BlueprintCraftingRecipe.recipeList.get((Object)nbt.func_74779_i("blueprintCategory"));
        for (BlueprintCraftingRecipe recipe : recipeList) {
            boolean b = false;
            for (int i = 0; i < inputs.length; ++i) {
                for (int j = 0; j < recipe.inputs.length; ++j) {
                    if (!recipe.inputs[j].matches(inputs[i])) continue;
                    b = true;
                    break;
                }
                if (!b) break;
            }
            if (!b) continue;
            return recipe;
        }
        return null;
    }
}

