/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.block;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.chisel.api.block.ICarvable;
import team.chisel.api.block.VariationData;
import team.chisel.client.ClientUtil;
import team.chisel.common.init.ChiselTabs;
import team.chisel.common.util.PropertyAnyInteger;

@ParametersAreNonnullByDefault
public class BlockCarvable
extends Block
implements ICarvable {
    private final PropertyAnyInteger metaProp;
    private final int index;
    private final VariationData[] variations;
    private final int maxVariation;
    private final BlockStateContainer states;

    public BlockCarvable(Material material, int index, int max, VariationData ... variations) {
        super(material);
        this.func_149647_a(ChiselTabs.tab);
        this.index = index;
        this.variations = variations;
        this.maxVariation = max;
        this.metaProp = PropertyAnyInteger.create("variation", 0, max > index * 16 ? 15 : max % 16);
        this.states = new BlockStateContainer((Block)this, new IProperty[]{this.metaProp});
        this.func_180632_j(this.func_176194_O().func_177621_b());
    }

    protected BlockStateContainer func_180661_e() {
        return Blocks.field_150350_a.func_176194_O();
    }

    public BlockStateContainer func_176194_O() {
        return this.states;
    }

    @Override
    public int getVariationIndex(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Override
    public int getTotalVariations() {
        return this.maxVariation + 1;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public VariationData getVariationData(int meta) {
        return this.variations[MathHelper.func_76125_a((int)meta, (int)0, (int)(this.variations.length - 1))];
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176194_O().func_177621_b().func_177226_a((IProperty)this.metaProp, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.metaProp);
    }

    public String getIndexName() {
        if (this.index == 0) {
            return this.func_149739_a();
        }
        return this.func_149739_a() + this.index;
    }

    public static BlockPos pos(int x, int y, int z) {
        return new BlockPos(x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        int curIndex = 0;
        for (VariationData var : this.variations) {
            if (var == null) continue;
            ItemStack stack = new ItemStack(item, 1, curIndex);
            ++curIndex;
            list.add(stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager effectRenderer) {
        ClientUtil.addHitEffects(worldObj, target.func_178782_a(), target.field_178784_b);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager effectRenderer) {
        ClientUtil.addDestroyEffects(world, pos, world.func_180495_p(pos));
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return super.canRenderInLayer(state, layer);
    }

    public boolean func_149730_j(IBlockState state) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return state.func_185914_p();
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return this.getVariationData((int)this.func_176201_c((IBlockState)state)).opaque;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.func_149662_c(state) ? 255 : 0;
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return super.func_176225_a(blockState, blockAccess, pos, side) && blockState != blockAccess.func_180495_p(pos.func_177972_a(side));
    }

    public boolean func_176214_u() {
        return true;
    }

    public PropertyAnyInteger getMetaProp() {
        return this.metaProp;
    }

    @Override
    public VariationData[] getVariations() {
        return this.variations;
    }
}

