/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.core.config;

import com.gendeathrow.hatchery.core.config.ConfigHandler;
import com.gendeathrow.hatchery.util.JsonConfig;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandom;

public class ConfigLootHandler {
    public static final File LuckyFile = new File(ConfigHandler.dir, "lucky_egg.json");
    public static JsonConfig config = new JsonConfig(LuckyFile);
    public static List<ItemDrop> drops = new ArrayList<ItemDrop>();
    public static ArrayList<ItemDrop> defaultList = new ArrayList();

    public static void load() {
        JsonObject array;
        boolean shouldCreate = false;
        if (!LuckyFile.exists()) {
            shouldCreate = true;
        }
        config.Load();
        if (shouldCreate) {
            ConfigLootHandler.createDefault(config);
        }
        if ((array = config.getFullJson()) != null) {
            drops = ItemDrop.getArrayItemDrops(array);
        }
        if (config.hasChanged()) {
            config.Save();
        }
    }

    private static void createDefault(JsonConfig config2) {
        JsonObject newobj = new JsonObject();
        for (ItemDrop item : defaultList) {
            newobj.add(item.itemID + ":" + item.metaID, (JsonElement)item.toJsonObj());
        }
        config.setFullJson(newobj);
    }

    static {
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151034_e), 10, 1, 2));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151103_aS), 13, 1, 3));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151122_aG), 14, 1, 3));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151025_P), 10, 1, 1));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151105_aU), 8, 1, 1));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151172_bF), 12, 1, 1));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151044_h), 15, 1, 3));
        defaultList.add(new ItemDrop(new ItemStack((Item)Items.field_151112_aM), 10, 1, 1));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151145_ak), 12, 1, 3));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151162_bE), 10, 1, 1));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151016_H), 8, 1, 1));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151007_F), 12, 1, 2));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151055_y), 12, 1, 3));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151058_ca), 6, 1, 1));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151054_z), 10, 1, 1));
        for (EnumDyeColor color : EnumDyeColor.values()) {
            defaultList.add(new ItemDrop(new ItemStack(Items.field_151100_aR, 1, color.func_176765_a()), 10, 1, 2));
        }
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151059_bz), 10, 1, 1));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151102_aT), 10, 1, 2));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151032_g), 10, 1, 3));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151119_aD), 10, 1, 3));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151069_bo), 10, 1, 3));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151152_bP), 10, 1, 2));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_179556_br), 4, 1, 1));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151121_aF), 15, 1, 2));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151144_bL), 15, 1, 1));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151086_cn), 8, 1, 1));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151096_cd), 8, 1, 1));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151093_ce), 8, 1, 1));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151088_cl), 8, 1, 1));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151085_cm), 8, 1, 1));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151092_ch), 8, 1, 1));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151057_cb), 5, 1, 1));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151045_i), 1, 1, 1));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151166_bC), 1, 1, 1));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151079_bi), 2, 1, 1));
        defaultList.add(new ItemDrop(new ItemStack(Items.field_151153_ao), 2, 1, 1));
    }

    public static class ItemDrop
    extends WeightedRandom.Item {
        private String itemID;
        private int metaID;
        private int weight;
        private int minQty;
        private int maxQty;
        private NBTTagCompound tag;
        private static final Random rand = new Random();

        public ItemDrop(ItemStack stack, int weight, int minqty, int maxqty) {
            this(stack.func_77973_b().getRegistryName().toString(), stack.func_77960_j(), weight, minqty, maxqty, stack.func_77942_o() ? stack.func_77978_p() : null);
        }

        public ItemDrop(String itemID, int metaID, int weight, int minQty, int maxQty, NBTTagCompound tag) {
            super(weight);
            this.itemID = itemID;
            this.metaID = metaID;
            this.weight = weight;
            this.minQty = minQty;
            this.maxQty = maxQty;
            this.tag = tag;
        }

        public static ArrayList<ItemDrop> getArrayItemDrops(JsonObject itemList) {
            ArrayList<ItemDrop> drops = new ArrayList<ItemDrop>();
            for (Map.Entry item : itemList.entrySet()) {
                try {
                    drops.add(ItemDrop.getItemDrop((JsonObject)item.getValue()));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            return drops;
        }

        public ItemStack getItemStack() {
            Item item = Item.func_111206_d((String)this.itemID);
            if (item == null) {
                return null;
            }
            ItemStack stack = new ItemStack(item, rand.nextInt(this.maxQty - this.minQty + 1) + this.minQty, this.metaID);
            if (this.tag != null) {
                stack.func_77982_d(this.tag);
            }
            return stack;
        }

        public Item getItem() {
            return Item.func_111206_d((String)this.itemID);
        }

        public int getMeta() {
            return this.metaID;
        }

        public static ItemDrop getItemDrop(JsonObject dataIn) throws NumberFormatException {
            String[] split = dataIn.get("item").getAsString().split(":");
            String itemID = split[0] + ":" + split[1];
            int metaID = 0;
            int minqty = 1;
            int maxqty = 1;
            int weight = 10;
            NBTTagCompound tag = null;
            if (split.length == 3) {
                metaID = Integer.parseInt(split[2]);
            }
            if (dataIn.has("weight")) {
                weight = dataIn.get("weight").getAsInt();
            }
            if (dataIn.has("nbt")) {
                try {
                    tag = JsonToNBT.func_180713_a((String)dataIn.get("nbt").getAsString());
                }
                catch (NBTException e) {
                    e.printStackTrace();
                }
            }
            if (dataIn.has("qty")) {
                minqty = maxqty = dataIn.get("qty").getAsInt();
            } else {
                if (dataIn.has("minQty")) {
                    minqty = dataIn.get("minQty").getAsInt();
                }
                if (dataIn.has("maxQty")) {
                    maxqty = dataIn.get("maxQty").getAsInt();
                }
            }
            return new ItemDrop(itemID, metaID, weight, minqty, maxqty, tag);
        }

        public JsonObject toJsonObj() {
            JsonObject obj = new JsonObject();
            if (this.itemID != null) {
                String stringitem = this.itemID + (this.metaID != 0 ? ":" + this.metaID : "");
                obj.addProperty("item", stringitem);
            }
            if (this.minQty == this.maxQty) {
                obj.addProperty("qty", (Number)this.minQty);
            } else {
                obj.addProperty("minQty", (Number)this.minQty);
                obj.addProperty("maxQty", (Number)this.maxQty);
            }
            obj.addProperty("weight", (Number)this.weight);
            if (this.tag != null) {
                obj.addProperty("nbt", this.tag.toString());
            }
            return obj;
        }
    }
}

