/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.block.nestpen;

import com.gendeathrow.hatchery.Hatchery;
import com.gendeathrow.hatchery.api.tileentities.IChickenNestingPen;
import com.gendeathrow.hatchery.block.nestpen.NestingPenBlock;
import com.gendeathrow.hatchery.core.Settings;
import com.gendeathrow.hatchery.core.init.ModBlocks;
import com.gendeathrow.hatchery.core.init.ModItems;
import com.gendeathrow.hatchery.inventory.InventoryStorage;
import com.gendeathrow.hatchery.item.HatcheryEgg;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class NestPenTileEntity
extends TileEntity
implements ITickable,
IInventory {
    private static final AxisAlignedBB EMPTY_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private EntityChicken chickenStored;
    private NBTTagCompound entityNBT;
    private int TimetoNextEgg = 0;
    private Random rand = new Random();
    InventoryStorage inventory = new InventoryStorage(this, 5);
    private int isMating = 600;
    private boolean updateEntity = false;
    private boolean wasChild = false;
    private boolean notFlapping = false;
    private float newWingRotDelta;
    private float newWingRotation;

    public NestPenTileEntity() {
        this.entityNBT = new NBTTagCompound();
        this.TimetoNextEgg = this.rand.nextInt(5000) + 2000;
    }

    public int getTimeToNextDrop() {
        return this.TimetoNextEgg;
    }

    public EntityAgeable storedEntity() {
        return this.chickenStored;
    }

    public boolean trySetEntity(Entity entityin) {
        if (this.storedEntity() != null) {
            return false;
        }
        if (entityin instanceof EntityChicken) {
            this.chickenStored = (EntityChicken)entityin;
            this.entityNBT = new NBTTagCompound();
            ((EntityChicken)entityin).func_70014_b(this.entityNBT);
            entityin.func_70107_b((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p());
            entityin.field_70181_x = 0.0;
            if (!((EntityChicken)entityin).func_70631_g_()) {
                ((EntityChicken)entityin).func_70873_a(6000);
            }
            NestingPenBlock.setState(true, this.field_145850_b, this.field_174879_c);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public Entity tryGetRemoveEntity() {
        if (this.storedEntity() == null) {
            return null;
        }
        this.chickenStored.func_94061_f(false);
        this.chickenStored.captureDrops = false;
        this.chickenStored.func_189654_d(false);
        EntityAgeable returnEntity = this.storedEntity();
        this.entityNBT = new NBTTagCompound();
        this.chickenStored = null;
        NestingPenBlock.setState(false, this.field_145850_b, this.field_174879_c);
        this.func_70296_d();
        return returnEntity;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        if (!(oldState.func_177230_c() != ModBlocks.pen && oldState.func_177230_c() != ModBlocks.pen_chicken || newSate.func_177230_c() != ModBlocks.pen && newSate.func_177230_c() != ModBlocks.pen_chicken)) {
            return false;
        }
        return oldState != newSate;
    }

    private void createEntity() {
        if (this.entityNBT.func_82582_d()) {
            this.chickenStored = null;
        } else {
            try {
                this.chickenStored = (EntityChicken)EntityList.func_75615_a((NBTTagCompound)this.entityNBT, (World)this.func_145831_w());
            }
            catch (Throwable e) {
                this.chickenStored = null;
                this.entityNBT = new NBTTagCompound();
                Hatchery.logger.error("Error trying to add chicken tp pen 'Null NBT' " + e);
            }
        }
        if (this.chickenStored != null) {
            this.chickenStored.func_174826_a(EMPTY_AABB);
            this.chickenStored.func_94061_f(true);
        }
    }

    private ItemStack createEgg() {
        ItemStack egg = new ItemStack((Item)ModItems.hatcheryEgg, 1, 0);
        EntityChicken mate = (EntityChicken)NestingPenBlock.getNearByMate(this.field_145850_b, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_174879_c);
        EntityChicken baby = null;
        if (mate != null) {
            if (this.chickenStored instanceof IChickenNestingPen) {
                baby = ((IChickenNestingPen)this.chickenStored).getChild((EntityAnimal)this.chickenStored, (EntityAnimal)mate);
            } else {
                baby = this.chickenStored.func_90011_a((EntityAgeable)mate);
                mate.func_70873_a(6000 + this.rand.nextInt(5500));
            }
        } else if (this.rand.nextInt(99) + 1 < Settings.EGG_NESTINGPEN_DROP_RATE) {
            baby = this.chickenStored.func_90011_a(this.storedEntity());
        } else {
            return null;
        }
        if (baby == null) {
            return null;
        }
        baby.func_70875_t();
        baby.func_70606_j(baby.func_110138_aP());
        baby.func_70873_a(-24000);
        baby.func_70875_t();
        if (baby instanceof EntityChicken) {
            baby.field_70887_j = 6000;
        }
        this.chickenStored.func_70873_a(6000 + this.rand.nextInt(6000));
        return HatcheryEgg.createEggFromEntity(this.field_145850_b, (EntityAgeable)baby);
    }

    public void func_73660_a() {
        if (!this.entityNBT.func_82582_d() && this.chickenStored == null || this.updateEntity) {
            this.createEntity();
            this.updateEntity = false;
        }
        if (this.chickenStored == null) {
            return;
        }
        if (this.chickenStored.func_70631_g_()) {
            this.wasChild = true;
        }
        this.chickenStored.field_70145_X = true;
        this.chickenStored.field_70122_E = true;
        this.chickenStored.func_189654_d(true);
        this.chickenStored.func_94061_f(true);
        this.chickenStored.func_70636_d();
        this.chickenStored.field_70181_x = 0.0;
        this.chickenStored.field_70159_w = 0.0;
        this.chickenStored.field_70179_y = 0.0;
        this.chickenStored.field_70145_X = false;
        this.chickenStored.func_189654_d(false);
        this.chickenStored.func_94061_f(false);
        this.chickenStored.captureDrops = true;
        this.playChickenSound();
        if (this.field_145850_b.field_72995_K) {
            if (!Settings.SHOULD_RENDER_CHICKEN_FLAPS) {
                return;
            }
            this.chickenStored.field_70888_h = this.chickenStored.field_70886_e;
            this.chickenStored.field_70884_g = this.chickenStored.field_70883_f;
            this.chickenStored.field_70883_f = (float)((double)this.chickenStored.field_70883_f + (double)(this.notFlapping ? -1 : 4) * 0.3);
            this.chickenStored.field_70883_f = MathHelper.func_76131_a((float)this.chickenStored.field_70883_f, (float)0.0f, (float)1.0f);
            if (this.notFlapping || this.chickenStored.func_70681_au().nextFloat() < 0.02f) {
                this.notFlapping = true;
                if (this.newWingRotDelta < 1.0f) {
                    this.newWingRotDelta = 1.0f;
                }
                this.newWingRotDelta = (float)((double)this.newWingRotDelta * 0.9);
                if (this.chickenStored.func_70681_au().nextFloat() < 0.02f) {
                    this.notFlapping = false;
                }
            }
            this.newWingRotation += this.newWingRotDelta * 2.0f;
            this.chickenStored.field_70889_i = this.newWingRotDelta;
            this.chickenStored.field_70886_e = this.newWingRotation;
            this.chickenStored.field_70122_E = true;
        }
        if (!(this.field_145850_b.field_72995_K || this.chickenStored.func_70631_g_() || this.chickenStored.func_152116_bZ())) {
            if (this.wasChild && !this.chickenStored.func_70631_g_()) {
                this.wasChild = false;
                this.updateClient();
            }
            if (this.chickenStored.func_70874_b() == 0 && this.chickenStored.getClass() != EntityChicken.class) {
                NestPenTileEntity.putStackInInventoryAllSlots(this, this.createEgg(), EnumFacing.DOWN);
            }
            if (--this.TimetoNextEgg <= 0) {
                if (this.rand.nextInt(1) == 0) {
                    NestPenTileEntity.putStackInInventoryAllSlots(this, new ItemStack(Items.field_151008_G, 1), EnumFacing.DOWN);
                }
                NestPenTileEntity.putStackInInventoryAllSlots(this, new ItemStack((Item)ModItems.manure, this.rand.nextInt(1) + 1), EnumFacing.DOWN);
                this.TimetoNextEgg = this.rand.nextInt(5000) + 2000;
            }
            if (this.chickenStored.capturedDrops != null && this.chickenStored.capturedDrops.size() > 0) {
                for (EntityItem entity : this.chickenStored.capturedDrops) {
                    NestPenTileEntity.putStackInInventoryAllSlots(this, entity.func_92059_d(), EnumFacing.DOWN);
                }
                this.chickenStored.capturedDrops.clear();
            }
        }
    }

    private void playChickenSound() {
        if (this.chickenStored.func_70089_S() && this.rand.nextInt(1000) < this.chickenStored.field_70757_a++) {
            this.chickenStored.field_70757_a = -this.chickenStored.func_70627_aG();
            if (!this.chickenStored.func_174814_R()) {
                this.chickenStored.func_70642_aH();
            }
        }
    }

    public void updateClient() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b("storedEntity")) {
            this.entityNBT = (NBTTagCompound)compound.func_74781_a("storedEntity");
        }
        this.inventory.readFromNBT(compound);
        this.updateEntity = true;
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound storedEntity = new NBTTagCompound();
        if (this.chickenStored != null) {
            storedEntity.func_74778_a("id", EntityList.func_75621_b((Entity)this.chickenStored));
            this.chickenStored.func_70014_b(storedEntity);
        } else if (!this.entityNBT.func_82582_d()) {
            storedEntity = this.entityNBT;
        }
        compound.func_74782_a("storedEntity", (NBTBase)storedEntity);
        NBTTagList nbttaglist = new NBTTagList();
        this.inventory.writeToNBT(compound);
        return super.func_189515_b(compound);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void dropContents() {
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = ItemStackHelper.func_188383_a((ItemStack[])this.inventory.getInventory(), (int)i);
            if (stack == null) continue;
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), stack));
        }
    }

    public boolean grabItems(EntityPlayer playerIn) {
        boolean flag = false;
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = ItemStackHelper.func_188383_a((ItemStack[])this.inventory.getInventory(), (int)i);
            if (stack == null) continue;
            if (!playerIn.field_71071_by.func_70441_a(stack)) {
                ForgeHooks.onPlayerTossEvent((EntityPlayer)playerIn, (ItemStack)stack, (boolean)false);
            }
            flag = true;
        }
        return flag;
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory.func_70301_a(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.inventory.func_70298_a(index, count);
    }

    public ItemStack func_70304_b(int index) {
        return this.inventory.func_70304_b(index);
    }

    public void func_70299_a(int index, @Nullable ItemStack stack) {
        this.inventory.func_70299_a(index, stack);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }

    public static ItemStack putStackInInventoryAllSlots(IInventory inventoryIn, ItemStack stack, @Nullable EnumFacing side) {
        if (inventoryIn instanceof ISidedInventory && side != null) {
            ISidedInventory isidedinventory = (ISidedInventory)inventoryIn;
            int[] aint = isidedinventory.func_180463_a(side);
            for (int k = 0; k < aint.length && stack != null && stack.field_77994_a > 0; ++k) {
                stack = NestPenTileEntity.insertStack(inventoryIn, stack, aint[k], side);
            }
        } else {
            int i = inventoryIn.func_70302_i_();
            for (int j = 0; j < i && stack != null && stack.field_77994_a > 0; ++j) {
                stack = NestPenTileEntity.insertStack(inventoryIn, stack, j, side);
            }
        }
        if (stack != null && stack.field_77994_a == 0) {
            stack = null;
        }
        return stack;
    }

    private static ItemStack insertStack(IInventory inventoryIn, ItemStack stack, int index, EnumFacing side) {
        ItemStack itemstack = inventoryIn.func_70301_a(index);
        if (NestPenTileEntity.canInsertItemInSlot(inventoryIn, stack, index, side)) {
            int max;
            boolean flag = false;
            if (itemstack == null) {
                int max2 = Math.min(stack.func_77976_d(), inventoryIn.func_70297_j_());
                if (max2 >= stack.field_77994_a) {
                    inventoryIn.func_70299_a(index, stack);
                    stack = null;
                } else {
                    inventoryIn.func_70299_a(index, stack.func_77979_a(max2));
                }
                flag = true;
            } else if (NestPenTileEntity.canCombine(itemstack, stack) && (max = Math.min(stack.func_77976_d(), inventoryIn.func_70297_j_())) > itemstack.field_77994_a) {
                int i = max - itemstack.field_77994_a;
                int j = Math.min(stack.field_77994_a, i);
                stack.field_77994_a -= j;
                itemstack.field_77994_a += j;
                flag = j > 0;
            }
        }
        return stack;
    }

    private static boolean canInsertItemInSlot(IInventory inventoryIn, ItemStack stack, int index, EnumFacing side) {
        return !inventoryIn.func_94041_b(index, stack) ? false : !(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).func_180462_a(index, stack, side);
    }

    private static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() != stack2.func_77973_b() ? false : (stack1.func_77960_j() != stack2.func_77960_j() ? false : (stack1.field_77994_a > stack1.func_77976_d() ? false : ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2)));
    }

    public static NBTTagList getInventoryContents(NestPenTileEntity te) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < te.inventory.func_70302_i_(); ++i) {
            if (te.inventory.func_70301_a(i) == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            nbttagcompound.func_74778_a("id", te.inventory.func_70301_a(i).func_82833_r());
            nbttagcompound.func_74768_a("cnt", te.inventory.func_70301_a((int)i).field_77994_a);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        return nbttaglist;
    }

    public static IItemHandler getItemHandler(TileEntity tile, EnumFacing side) {
        if (tile == null) {
            return null;
        }
        IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        if (handler == null) {
            if (side != null && tile instanceof ISidedInventory) {
                handler = new SidedInvWrapper((ISidedInventory)tile, side);
            } else if (tile instanceof IInventory) {
                handler = new InvWrapper((IInventory)tile);
            }
        }
        return handler;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)new InvWrapper((IInventory)this);
        }
        return (T)super.getCapability(capability, facing);
    }
}

